/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.bundleupgrade.utils;

import com.huawei.bundleupgrade.entity.DeviceEntity;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.entity.UpgradeDeviceEntity;
import com.huawei.bundleupgrade.service.DeviceInfoByRedfishService;
import com.huawei.ism.tool.base.utils.StringUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchDogSettingUtil {
    private static final Logger log = LoggerFactory.getLogger(WatchDogSettingUtil.class);
    private static final String DISABLED = "Disabled";
    private static final String ENABLED = "Enabled";

    private WatchDogSettingUtil() {
    }

    public static HashMap<String, String> getBiosConfigItem(DeviceEntity.WatchDogModel watchDogModel) {
        String osWdtEnable;
        String bmcWdtEnable;
        HashMap<String, String> biosConfigItemMap = new HashMap<String, String>(3);
        String spBoot = watchDogModel.getSpBoot();
        if (StringUtils.isNULLStr((String)spBoot) || spBoot.equals(DISABLED)) {
            biosConfigItemMap.put("SPBoot", ENABLED);
        }
        if (StringUtils.isNULLStr((String)(bmcWdtEnable = watchDogModel.getBmcWdtEnable())) || bmcWdtEnable.equals(ENABLED)) {
            biosConfigItemMap.put("BMCWDTEnable", DISABLED);
        }
        if (StringUtils.isNULLStr((String)(osWdtEnable = watchDogModel.getOsWdtEnable())) || osWdtEnable.equals(ENABLED)) {
            biosConfigItemMap.put("OSWDTEnable", DISABLED);
        }
        return biosConfigItemMap;
    }

    public static OperationResultEntity setSpbootWatchDog(UpgradeDeviceEntity upgradeDevice, DeviceInfoByRedfishService service) {
        HashMap<String, String> dataMap = WatchDogSettingUtil.getBiosConfigItem(upgradeDevice.getDeviceEntity().getWatchDogModel());
        if (dataMap.size() != 0) {
            log.info(String.format(Locale.ENGLISH, "Device %s need to set SPBoot and WatchDog", upgradeDevice.getDeviceEntity().getIp()));
            return service.setBiosConfiguration(dataMap);
        }
        log.info(String.format(Locale.ENGLISH, "Device %s do not need to set SPBoot and WatchDog", upgradeDevice.getDeviceEntity().getIp()));
        return new OperationResultEntity(true, "");
    }

    public static HashMap<String, String> getOrgBiosCfgItem(HashMap<String, String> biosConfigItemMap) {
        for (Map.Entry<String, String> entry : biosConfigItemMap.entrySet()) {
            String biosCfgItemValue;
            switch (biosCfgItemValue = entry.getValue()) {
                case "Disabled": {
                    biosConfigItemMap.put(entry.getKey(), ENABLED);
                    break;
                }
                case "Enabled": {
                    biosConfigItemMap.put(entry.getKey(), DISABLED);
                }
            }
        }
        return biosConfigItemMap;
    }

    public static OperationResultEntity resumSpbootWatchDog(UpgradeDeviceEntity upgradeDevice, DeviceInfoByRedfishService service, HashMap<String, String> orgBiosCfgItem) {
        if (orgBiosCfgItem.size() != 0) {
            log.info(String.format(Locale.ENGLISH, "Device %s need to resuming SPBoot and WatchDog", upgradeDevice.getDeviceEntity().getIp()));
            return service.setBiosConfiguration(orgBiosCfgItem);
        }
        log.info(String.format(Locale.ENGLISH, "Device %s do not need to resuming SPBoot and WatchDog", upgradeDevice.getDeviceEntity().getIp()));
        return new OperationResultEntity(true, "");
    }
}

