/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.framework.platform.common.ui.IStartAction;
import com.huawei.ism.tool.service.rest.handle.SmartKitSceneInterceptor;
import com.huawei.ism.tool.service.rest.util.CertsUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication(scanBasePackages={"com.huawei.ism.tool.distributedfwupg.web", "com.huawei.ism.tool.service.rest"})
public class WebStartAction
implements IStartAction {
    private static final Logger log = LoggerFactory.getLogger(WebStartAction.class);

    public void actionPerformed(Window parent, ActionEvent e) {
        CompletableFuture.runAsync(WebStartAction::startBrowser);
        System.setProperty("tool.scene.start", "true");
        CertsUtil.generateDefaultSelfSignedCerts();
        SpringApplication.run(WebStartAction.class, (String[])new String[0]);
    }

    private static void startBrowser() {
        try {
            String browser = Paths.get(SystemEnvUtil.getDefaultUserDir(), "electron", "ftd-browser.exe").toString();
            ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", "\"" + browser + "\"", "common");
            String token = SecurityUtils.generateAuthorizationKey();
            SmartKitSceneInterceptor.setScene((String)token);
            builder.environment().put("scene", token);
            builder.environment().put("stepId", WebStartAction.getCurrentScene("stepID"));
            builder.environment().put("subScene", WebStartAction.getCurrentScene("subScene"));
            builder.redirectErrorStream(true);
            Process process = builder.start();
            while (process.isAlive()) {
                Thread.sleep(1000L);
                WebStartAction.refreshOutput(process.getInputStream());
            }
        }
        catch (Exception e) {
            log.info("Error exec!", (Throwable)e);
        }
    }

    private static String getCurrentScene(String sceneName) {
        String jsonScene = System.getenv("jsonScene");
        if (StringUtils.isNULLStr((String)jsonScene)) {
            return "";
        }
        return JSON.parseObject((String)jsonScene).getOrDefault((Object)sceneName, (Object)"").toString();
    }

    private static void refreshOutput(InputStream is) throws IOException {
        int len;
        if (is == null) {
            return;
        }
        while ((len = is.available()) > 0) {
            byte[] bs = new byte[len];
            int bSize = is.read(bs);
            String outputStr = new String(bs, 0, bSize, Charset.defaultCharset());
            log.info("browser : {}", (Object)outputStr);
        }
    }
}

