/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCardLayout;
import com.huawei.ism.tool.distributedfwupg.utils.ExcelUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class BatchExportTemplateAction
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BatchExportTemplateAction.class);
    private static final int SELECT_NODE_NUM_LIMIT = Integer.parseInt(ResourceUtil.getString((String)"upgrade.compute.node.import.template.large.limit")) - 1;
    private SelectNodeCardLayout cardLayout;
    private JDialog parent;

    public BatchExportTemplateAction(JDialog parent, SelectNodeCardLayout cardLayout) {
        this.cardLayout = cardLayout;
        this.parent = parent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<FSDevNode> selectFsDevNodes = this.cardLayout.getSelectedFsNode();
        if (selectFsDevNodes.isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"dsfwupgrade.wizard.select.no.node"));
            return;
        }
        if (selectFsDevNodes.size() > SELECT_NODE_NUM_LIMIT) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getStringWithParams((String)"dsfwupgrade.wizard.select.max.node", (Object[])new Integer[]{SELECT_NODE_NUM_LIMIT}));
            return;
        }
        String saveFilePath = ToolFileChooser.getSaveFilePath((String)ResourceUtil.getString((String)"upgrade.compute.node.export.template.title"), (String)"xls", (Window)UpgradeContext.getInstance().getMainDialog(), (String)"template.xls", (String)"");
        if (StringUtils.isNULLStr((String)saveFilePath)) {
            return;
        }
        try {
            ExcelUtils.exportTemplate(selectFsDevNodes, saveFilePath);
            DialogUtils.showSuccessDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"upgrade.compute.node.export.template.success"));
        }
        catch (IOException ex) {
            LOGGER.error(ex.getMessage());
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"upgrade.compute.node.export.template.failed"));
        }
    }
}

