/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.devicecenter.ui.dialog.OsDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.OsDeviceAddLayout;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCardLayout;
import com.huawei.ism.tool.distributedfwupg.utils.ExcelUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class BatchImportDeviceAction
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(BatchImportDeviceAction.class);
    private static final String OS_ROOT_USER_NAME = "root";
    private SelectNodeCardLayout cardLayout;
    private JDialog parent;

    public BatchImportDeviceAction(JDialog parent, SelectNodeCardLayout cardLayout) {
        this.parent = parent;
        this.cardLayout = cardLayout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<AbstractDevice> importExcelFSDevNode;
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put("description", ".xls");
        extParams.put("PathId", "template_select_path_id");
        extParams.put("title", ResourceUtil.getString((String)"upgrade.compute.node.import.template.title"));
        File importFile = ToolFileChooser.selectFile((Window)this.parent, (String[])new String[]{"xls"}, (int)0, (boolean)true, extParams);
        List<FSDevNode> allFsNode = this.cardLayout.getAllFsNode();
        if (importFile == null || StringUtils.isNULLStr((String)importFile.getPath())) {
            LOGGER.info("select file is null");
            return;
        }
        try {
            importExcelFSDevNode = ExcelUtils.importTemplate(allFsNode, importFile);
            if (importExcelFSDevNode.isEmpty()) {
                LOGGER.info("excel import data is empty");
                DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"upgrade.compute.node.import.template.invalid"));
                return;
            }
        }
        catch (ToolException toolException) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)toolException.getDes());
            return;
        }
        catch (Exception exception) {
            LOGGER.error(exception.getMessage());
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"upgrade.compute.node.import.template.failed"));
            return;
        }
        List<AbstractDevice> needLoginDevice = importExcelFSDevNode.stream().filter(node -> !StringUtils.isNULLStr((String)((HwServerDevice)node).getUserName())).collect(Collectors.toList());
        if (this.isInvalidImportTemplateData(needLoginDevice)) {
            DialogUtils.showInfoDialog((JDialog)this.parent, (String)ResourceUtil.getString((String)"upgrade.compute.node.import.template.invalid"));
            return;
        }
        this.openBatchAddDialog(needLoginDevice);
    }

    private void openBatchAddDialog(List<AbstractDevice> needLoginDevice) {
        HashMap<String, String> fsIpMap = new HashMap<String, String>();
        this.getAbstractDevices(needLoginDevice, fsIpMap);
        SelectNodeCardLayout.setServerType(ITDeviceType.SERVER_OS);
        OsDeviceAddLayout modifyLayout = new OsDeviceAddLayout(Constants.FUSIONSTORAGE, true);
        OsDeviceAddDialog addDialog = new OsDeviceAddDialog(modifyLayout, fsIpMap, true);
        String title = ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.os");
        addDialog.setTitle(title);
        this.cardLayout.setFsNode2Selected(needLoginDevice);
        addDialog.setHwServerDevs(needLoginDevice);
        addDialog.setExcelImport(true);
        addDialog.findDevice();
        addDialog.setExcelImport(false);
    }

    private void getAbstractDevices(List<AbstractDevice> needLoginFsDevice, Map<String, String> fsDevMap) {
        for (AbstractDevice node : needLoginFsDevice) {
            FSDevNode fsDevNode = (FSDevNode)node;
            fsDevMap.put(fsDevNode.getDevKey(), fsDevNode.getBmcIP());
        }
    }

    private boolean isInvalidImportTemplateData(List<AbstractDevice> needLoginFsDevice) {
        if (needLoginFsDevice.isEmpty()) {
            return true;
        }
        return needLoginFsDevice.stream().anyMatch(node -> !((HwServerDevice)node).getUserName().equals(OS_ROOT_USER_NAME) && StringUtils.isNULLStr((String)((HwServerDevice)node).getRootPwd()));
    }
}

