/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.entity.UpdateType;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeFlowService;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeNodeOfflineUpgradeAction
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(ComputeNodeOfflineUpgradeAction.class);
    private static final String TIPS = ResourceUtil.getString((String)"upgrade.compute.node.dpc.offline.tips");
    private static final String CONTINUE_TIPS = ResourceUtil.getString((String)"upgrade.compute.node.dpc.offline.continue");
    private final UpgradeComputeNodeDialog dialog;
    private final FsUpgradeFlowService service;

    public ComputeNodeOfflineUpgradeAction(UpgradeComputeNodeDialog dialog) {
        this.dialog = dialog;
        this.service = new FsUpgradeFlowService(dialog.getDialogLayout());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Click 'Offline Upgrade' button");
        if (!this.dialog.isSupportOffline()) {
            DialogUtils.showInfoDialog((JDialog)this.dialog, (String)ResourceUtil.getString((String)"upgrade.compute.node.dpc.offline.notsupport.desc"));
            return;
        }
        int value = DialogUtils.showWarnConfirmDialog((Window)this.dialog, (String)TIPS, (String)CONTINUE_TIPS).getValue();
        if (0 != value) {
            log.info("User abort upgrade.");
            return;
        }
        log.info("Set update model {} ", (Object)UpdateType.DPC_OFFLINE);
        FsUpgradeFlowService.setUpdateType(UpdateType.DPC_OFFLINE);
        this.dialog.allButtonDimmed();
        this.initComputeNodeResult();
        this.service.submitTask(this.service::parallelUpgrade);
    }

    private void initComputeNodeResult() {
        List<FSDevNode> allNodes = this.dialog.getDialogLayout().getAllNodes();
        FsUpgradeService.initUpgradeResult(allNodes, ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.offlineUpgrade"));
    }
}

