/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeFlowService;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeLayout;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class ComputeNodeRetryAction
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ComputeNodeRetryAction.class);
    private FsUpgradeFlowService service;
    private UpgradeComputeNodeLayout layout;
    private FSDevNode node;

    public ComputeNodeRetryAction(UpgradeComputeNodeLayout layout, FSDevNode node) {
        this.layout = layout;
        this.node = node;
        this.service = new FsUpgradeFlowService(layout, node);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOGGER.info("Click 'Retry' button");
        if (this.node.isVbsNode() && !this.layout.getAllNodesExceptVbsMaster().stream().allMatch(node -> node.getUpgradeStatus().isSuccessUpgradeOrRollback())) {
            this.service.updateNodeStatus(this.node, Constants.NodeUpgradeState.PREPARE_FAILED);
            LOGGER.info("Exist failed node, abort to update vbs node {} .", (Object)this.node.getManagementIP());
            DialogUtils.showInfoDialog((JDialog)UpgradeContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"upgrade.compute.vbs.waring"));
            return;
        }
        if (!CommonUtils.showWaringInfoAndConfirmContinue(Arrays.asList(this.node), this.service)) {
            return;
        }
        LOGGER.info("ComputeNode {} retry...", (Object)this.node.getManagementIP());
        this.service.retryNode();
    }
}

