/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeFlowService;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeLayout;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ComputeNodeRetryAllAction
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ComputeNodeRetryAllAction.class);
    private FsUpgradeFlowService service;
    private UpgradeComputeNodeLayout layout;

    public ComputeNodeRetryAllAction(UpgradeComputeNodeLayout layout) {
        this.layout = layout;
        this.service = new FsUpgradeFlowService(layout);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LOGGER.info("Click 'Batch Retry' button");
        List<FSDevNode> failedNodes = this.layout.getAllNodes().stream().filter(FSDevNode::isFailed).collect(Collectors.toList());
        if (!CommonUtils.showWaringInfoAndConfirmContinue(failedNodes, this.service)) {
            return;
        }
        this.layout.getRetryAllBtn().setEnabled(false);
        this.layout.getRollbackAllBtn().setEnabled(false);
        this.service.submitTask(() -> this.service.retryAll());
    }
}

