/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.entity.UpdateType;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeFlowService;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeNodeUpgradeAction
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(ComputeNodeUpgradeAction.class);
    private static final String DPC_ONLINE_TIPS = ResourceUtil.getString((String)"upgrade.compute.node.dpc.online.tips");
    private static final String DPC_ONLINE_CONTINUE_TIPS = ResourceUtil.getString((String)"upgrade.compute.node.dpc.online.continue");
    private FsUpgradeFlowService service;
    private UpgradeComputeNodeDialog dialog;

    public ComputeNodeUpgradeAction(UpgradeComputeNodeDialog dialog) {
        this.dialog = dialog;
        this.service = new FsUpgradeFlowService(dialog.getDialogLayout());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info("Click 'Online Upgrade' button");
        if (this.isDpcUpgrade()) {
            if (0 != DialogUtils.showWarnConfirmDialog((Window)this.dialog, (String)DPC_ONLINE_TIPS, (String)DPC_ONLINE_CONTINUE_TIPS).getValue()) {
                log.info("User abort upgrade.");
                return;
            }
            log.info("Set update model {} ", (Object)UpdateType.DPC_ONLINE);
            FsUpgradeFlowService.setUpdateType(UpdateType.DPC_ONLINE);
        }
        this.dialog.allButtonDimmed();
        this.initComputeNodeResult();
        this.service.submitTask(() -> this.service.parallelUpgrade());
    }

    private void initComputeNodeResult() {
        List<FSDevNode> allNodes = this.dialog.getDialogLayout().getAllNodes();
        FsUpgradeService.initUpgradeResult(allNodes, ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.upgrade"));
    }

    private boolean isDpcUpgrade() {
        return this.dialog.getDialogLayout().getAllNodes().stream().anyMatch(FSDevNode::isDpcComputeNode);
    }

    public void recoverProgress() {
        if (this.service.isRecoverRollback()) {
            this.service.submitTask(() -> this.service.recoverParallelRollback());
        } else {
            this.service.submitTask(() -> this.service.recoverParallelUpgrade());
        }
    }
}

