/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.AddFSDeviceDialog;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDeviceAction
extends ToolHyperLinkLabel.ClickAdapter
implements INodeSupport {
    private static final Logger log = LoggerFactory.getLogger(QueryDeviceAction.class);
    private INodeObserver obsver;

    public QueryDeviceAction(INodeObserver obsver) {
        this.obsver = obsver;
    }

    public void actionPerformed(ActionEvent e) {
        DSstorageInfoQryServiceImpl query = new DSstorageInfoQryServiceImpl();
        query.setNodeSupport((INodeSupport)this);
        DeviceAddDialog.InfoTips tips = new DeviceAddDialog.InfoTips("devicemanager.layout.device.add.deviceadddialog.deviceduplicatebyupgrade");
        JDialog parentDialog = UpgradeContext.getInstance().getDialog();
        AddFSDeviceDialog dialog = new AddFSDeviceDialog(parentDialog, (INodeTypeQuery)query, tips);
        DefaultNodeProviderImpl.getInstance().addNodeObservers(this.obsver);
        dialog.setVisible(true);
    }

    public boolean isNodeSupport(DevNode devNode) {
        if (this.isContainsVerison(devNode, UpgradeContext.getInstance().getBlackDevTypes())) {
            log.info("current device {} do not support to upgrade", (Object)devNode.getIp());
            return false;
        }
        return this.isContainsVerison(devNode, UpgradeContext.getInstance().getSupportDevTypeList());
    }

    private boolean isContainsVerison(DevNode devNode, List<DeviceType> deviceTypes) {
        String tmpType = String.join((CharSequence)" ", devNode.getDeviceType().toString(), devNode.getProductVersion());
        return deviceTypes.stream().anyMatch(blackDevType -> tmpType.startsWith(blackDevType.toString()));
    }
}

