/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.google.common.collect.ArrayListMultimap;
import com.huawei.bundleupgrade.entity.FwUpgradeScenarioAdaptation;
import com.huawei.bundleupgrade.entity.OperationResultEntity;
import com.huawei.bundleupgrade.utils.NodeServiceUtils;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCardLayout;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.FSClusterDevManager;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class SelectNodesConfirm {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SelectNodesConfirm.class);
    private SelectNodeCardLayout cardLayout;
    private FSClusterDevice fsClusterDevice;
    private String[] waringTableHeader = new String[]{ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.manageip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.bmcip")};

    public SelectNodesConfirm(SelectNodeCardLayout cardLayout, FSClusterDevice fsClusterDevice) {
        this.cardLayout = cardLayout;
        this.fsClusterDevice = fsClusterDevice;
    }

    public boolean doConfirm() {
        List<FSDevNode> selectedNodes;
        JDialog parentDialog = UpgradeContext.getInstance().getDialog();
        if (!this.checkSelectNodeCanUpgrade(parentDialog, selectedNodes = this.cardLayout.getSelectedFsNode())) {
            return false;
        }
        if (!CommonUtils.checkSelectedNode(parentDialog, selectedNodes, this.fsClusterDevice.needOSAuth(), this.fsClusterDevice.needBMCAuth())) {
            return false;
        }
        if (!this.checkNodeAuthIfExistDirectPlaneNode(parentDialog, selectedNodes)) {
            return false;
        }
        if (!this.checkHasDPCServerAndShowWaring(parentDialog, selectedNodes)) {
            return false;
        }
        if (!this.checkBmcIpIsBlankAndShowWaring(parentDialog, selectedNodes)) {
            return false;
        }
        this.saveDevInfo2MainTable();
        return true;
    }

    private List<String> getNodeIpInErasureStatus(List<FSDevNode> selectedNodes) throws ToolException {
        DevNode devNode = CommonUtils.transFsClusterDev2DevNode(this.fsClusterDevice);
        List nodeIps = selectedNodes.stream().map(FSDevNode::getManagementIP).collect(Collectors.toList());
        Map param = Collections.singletonMap("ipList", nodeIps);
        ResponseInfo responseInfo = NodeServiceUtils.queryNodeDataErasureStatus(devNode, param);
        return NodeServiceUtils.getNodeIpsInErasureStatusIp(responseInfo);
    }

    private boolean checkNodeAuthIfExistDirectPlaneNode(Dialog parentDialog, List<FSDevNode> selectedNodes) {
        List directPlaneNodes = selectedNodes.stream().filter(FSDevNode::isDirectPlane).collect(Collectors.toList());
        if (directPlaneNodes.isEmpty()) {
            return true;
        }
        Map<String, List<FSDevNode>> chassisId2Node = this.cardLayout.getAllFsNode().stream().filter(node -> !node.isDirectPlane()).collect(Collectors.groupingBy(FSDevNode::getChassisId));
        List infos = directPlaneNodes.stream().filter(directNode -> chassisId2Node.containsKey(directNode.getChassisId())).map(directNode -> this.initNotAuthNodeInfo(chassisId2Node, (FSDevNode)((Object)directNode))).filter(Objects::nonNull).collect(Collectors.toList());
        if (!infos.isEmpty()) {
            String msg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.directPlaneCheck");
            DialogUtils.showMultiErrorDialog((Window)parentDialog, (String)msg, (String[])new String[]{ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.direct.table.directIP"), ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.direct.table.waring")}, infos);
            LOGGER.info("Select direct node but exist node has not finish os auth.");
            return false;
        }
        return true;
    }

    private ArrayList<Object> initNotAuthNodeInfo(Map<String, List<FSDevNode>> chassisId2Node, FSDevNode directNode) {
        ArrayList<Object> info = new ArrayList<Object>();
        info.add(directNode.getBmcIP());
        String msg = chassisId2Node.get(directNode.getChassisId()).stream().filter(node -> !node.isOsAuthSuccess()).map(FSDevNode::getManagementIP).collect(Collectors.joining(","));
        if (StringUtils.isNULLStr((String)msg)) {
            return null;
        }
        LOGGER.info("The direct node {} in chassis {} exist nodes {} not finish os auth.", new Object[]{directNode.getBmcIP(), directNode.getChassisId(), msg});
        info.add(ResourceUtil.getStringWithParams((String)"dsfwupgrade.scene.selectnodevice.directPlaneCheck.waring", (Object[])new Object[]{msg}));
        return info;
    }

    private boolean checkBmcIpIsBlankAndShowWaring(Dialog parentDialog, List<FSDevNode> selectedNodes) {
        if (Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(UpgradeContext.getInstance().getUpgradeScene())) {
            return true;
        }
        List nodes = selectedNodes.stream().filter(fsDevNode -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fsDevNode.getBmcIP())).collect(Collectors.toList());
        if (nodes.isEmpty()) {
            return true;
        }
        List data = nodes.stream().map(node -> this.corverNode2ShowData((FSDevNode)((Object)node))).collect(Collectors.toList());
        String msg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.bmcIpIsNull");
        DialogUtils.showMultiErrorDialog((Window)parentDialog, (String)msg, (String[])this.waringTableHeader, data);
        return false;
    }

    private boolean checkHasDPCServerAndShowWaring(Dialog parentDialog, List<FSDevNode> selectedNodes) {
        if (Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(UpgradeContext.getInstance().getUpgradeScene())) {
            return true;
        }
        if (Boolean.parseBoolean(CommonUtils.getSystemConfig("ignore_check", "false"))) {
            LOGGER.info("Ignore dpc service check.");
            return true;
        }
        List dpcNodes = selectedNodes.stream().filter(FSDevNode::isDpcComputeNode).collect(Collectors.toList());
        if (dpcNodes.isEmpty()) {
            return true;
        }
        List data = dpcNodes.stream().map(node -> this.corverNode2ShowData((FSDevNode)((Object)node))).collect(Collectors.toList());
        String msg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.dpcCheck");
        DialogUtils.showMultiErrorDialog((Window)parentDialog, (String)msg, (String[])this.waringTableHeader, data);
        LOGGER.info("Exist node has DPC service, do not support upgrade firmware.");
        return false;
    }

    private boolean checkSelectNodeCanUpgrade(Dialog parentDialog, List<FSDevNode> selectedNodes) {
        if (Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(UpgradeContext.getInstance().getUpgradeScene())) {
            return true;
        }
        OperationResultEntity operationResultEntity = new OperationResultEntity(true, "");
        AsyncExcutor.execute((Window)parentDialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> {
            this.checkErasureStatus(parentDialog, selectedNodes, operationResultEntity);
            return true;
        }});
        if (!operationResultEntity.isNextStep()) {
            return false;
        }
        this.checkVolume(selectedNodes, operationResultEntity);
        if (operationResultEntity.getArrayListCheckInfo().isEmpty()) {
            return true;
        }
        this.showWaring(parentDialog, operationResultEntity.getArrayListCheckInfo());
        return false;
    }

    void checkErasureStatus(Dialog parentDialog, List<FSDevNode> selectedNodes, OperationResultEntity operationResultEntity) {
        if (!FwUpgradeScenarioAdaptation.ErasureBlockEnum.isSupportErasureProduct(this.fsClusterDevice.getProductModel(), this.fsClusterDevice.getProductVersion())) {
            LOGGER.info("Device {} do not need check erasure status, type:{},version:{}", new Object[]{this.fsClusterDevice.getFloatIp(), this.fsClusterDevice.getProductModel(), this.fsClusterDevice.getProductVersion()});
            return;
        }
        if (Boolean.parseBoolean(CommonUtils.getSystemConfig("fw.ignore.disk.data.erasure.tasks", "false"))) {
            LOGGER.info("Ignore erasure status check.");
        } else {
            List<String> nodeIpsInErasureStatus;
            try {
                nodeIpsInErasureStatus = this.getNodeIpInErasureStatus(selectedNodes);
            }
            catch (ToolException e) {
                LOGGER.error("Query device {} erasure status error", (Object)this.fsClusterDevice.getFloatIp());
                DialogUtils.showInfoDialog((Window)parentDialog, (String)ResourceUtil.getString((String)"net.error"));
                operationResultEntity.setNextStep(false);
                return;
            }
            if (nodeIpsInErasureStatus.isEmpty()) {
                LOGGER.info("Device {} no node in erasure status", (Object)this.fsClusterDevice.getFloatIp());
                return;
            }
            this.promptInfoCombination(selectedNodes, operationResultEntity, nodeIpsInErasureStatus);
        }
    }

    private void promptInfoCombination(List<FSDevNode> selectedNodes, OperationResultEntity operationResultEntity, List<String> nodesInDataWipe) {
        String promptInfo = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.data.erasure.tasks");
        selectedNodes.stream().filter(node -> nodesInDataWipe.contains(node.getManagementIP())).collect(Collectors.toList()).forEach(node -> operationResultEntity.getArrayListCheckInfo().put((Object)node.getBmcIP(), (Object)promptInfo));
    }

    private void checkVolume(List<FSDevNode> selectedNodes, OperationResultEntity operationResultEntity) {
        if (Boolean.parseBoolean(CommonUtils.getSystemConfig("ignore_check", "false"))) {
            LOGGER.info("Ignore volume num check.");
        } else {
            String promptInfo = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.volumeNumCheck");
            selectedNodes.stream().filter(FSDevNode::hasVolume).collect(Collectors.toList()).forEach(node -> operationResultEntity.getArrayListCheckInfo().put((Object)node.getBmcIP(), (Object)promptInfo));
        }
    }

    private void showWaring(Dialog parentDialog, ArrayListMultimap<String, String> arrayListMultimap) {
        DialogUtils.showMultiErrorDialogNoIgnoreButton((Window)parentDialog, (String)ResourceUtil.getString((String)"do.not.support.upgrade.node"), (String[])new String[]{"BMC IP", ResourceUtil.getString((String)"error.info.tip")}, UpgradeCustomizationUtil.getShowInfo(arrayListMultimap));
        LOGGER.info("The cluster has tasks that cannot be stopped, do not support upgrade firmware.");
    }

    private ArrayList<Object> corverNode2ShowData(FSDevNode node) {
        ArrayList<Object> nodeData = new ArrayList<Object>();
        nodeData.add(node.getManagementIP());
        nodeData.add(node.getBmcIP());
        return nodeData;
    }

    private void saveDevInfo2MainTable() {
        List<FSDevNode> allFsNodes = this.fsClusterDevice.getFsDevNodeList();
        for (FSDevNode fsDevNode : allFsNodes) {
            fsDevNode.setSelected(false);
        }
        List<FSDevNode> selectedFsNodes = this.cardLayout.getSelectedFsNode();
        for (FSDevNode fsDevNode : selectedFsNodes) {
            fsDevNode.setSelected(true);
        }
        if (this.cardLayout.isModify()) {
            UpgradeContext.getInstance().getUiObserver().updateDev2Table(this.fsClusterDevice);
        } else {
            UpgradeContext.getInstance().getUiObserver().addUpgradeDev2Table(this.fsClusterDevice);
            FSClusterDevManager.getInstance().getTableFsClusterDevs().add(this.fsClusterDevice);
        }
    }
}

