/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.ui.dialog.IbmcDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.IbmcDeviceAddLayout;
import com.huawei.ism.tool.devicecenter.utils.LayUtil;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCardLayout;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;

public class UpdateFSNodeBmcAuthAction
implements ActionListener {
    private List<FSDevNode> fsDevNodeList;
    private IbmcDeviceAddLayout modifyLayout;
    private SelectNodeCardLayout cardLayout;
    private ActionListener[] confirmButtonlisteners;
    private IbmcDeviceAddDialog addDialog;
    private boolean modify;

    public UpdateFSNodeBmcAuthAction(SelectNodeCardLayout cardLayout, FSDevNode fsDevNode) {
        this.cardLayout = cardLayout;
        this.fsDevNodeList = Collections.singletonList(fsDevNode);
        this.modify = true;
    }

    public UpdateFSNodeBmcAuthAction(SelectNodeCardLayout cardLayout, List<FSDevNode> fsDevNodeList) {
        this.cardLayout = cardLayout;
        this.fsDevNodeList = fsDevNodeList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SelectNodeCardLayout.setServerType(ITDeviceType.SERVER_IBMC);
        JDialog wizardDialog = UpgradeContext.getInstance().getDialog();
        if (this.fsDevNodeList.isEmpty()) {
            String errMsg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice");
            DialogUtils.showErrorDialog((JDialog)wizardDialog, (String)errMsg);
            return;
        }
        if (!CommonUtils.checkBmcIp(wizardDialog, this.fsDevNodeList)) {
            return;
        }
        this.modifyLayout = new IbmcDeviceAddLayout(true);
        this.initData();
        HashMap<String, String> fsIpMap = new HashMap<String, String>();
        if (!this.modify) {
            for (FSDevNode fsNode : this.fsDevNodeList) {
                fsIpMap.put(fsNode.getBmcIP(), fsNode.getBmcIP());
            }
        }
        this.addDialog = new IbmcDeviceAddDialog(this.modifyLayout, fsIpMap);
        if (e.getSource() instanceof JButton) {
            String title = ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.bmc");
            this.addDialog.setTitle(title);
        }
        for (ActionListener listener : this.confirmButtonlisteners = this.modifyLayout.getConfirmBtn().getActionListeners()) {
            this.modifyLayout.getConfirmBtn().removeActionListener(listener);
        }
        this.addListeners();
        SwingUtil.putParentCenter((Window)this.addDialog, (Window)wizardDialog);
        this.addDialog.setVisible(true);
    }

    private void addListeners() {
        this.modifyLayout.getConfirmBtn().addActionListener(event -> {
            if (this.checkBmcIpExist()) {
                this.exeConfirmParentListener(event);
            }
        });
    }

    private void exeConfirmParentListener(ActionEvent e) {
        for (ActionListener listener : this.confirmButtonlisteners) {
            listener.actionPerformed(e);
        }
    }

    private void initData() {
        FSDevNode fsDevNode = this.fsDevNodeList.get(0);
        if (this.modify) {
            this.modifyLayout.getBmcIpField().setText(fsDevNode.getBmcIP());
        } else {
            this.modifyLayout.getBmcIpField().setVisible(false);
            this.modifyLayout.getBmcIpLabel().setVisible(false);
            this.modifyLayout.getManageIpField().setVisible(false);
            this.modifyLayout.getManageIpLabel().setVisible(false);
            this.modifyLayout.getUserNameField().setText(LayUtil.filterItemInfo((String)""));
            this.modifyLayout.getKeypwdField().setText(LayUtil.filterItemInfo((String)""));
        }
        this.modifyLayout.getManageIpField().setEnabled(false);
        this.modifyLayout.getStartIpAddress().setText(fsDevNode.getBmcIP());
        this.modifyLayout.getEndIpField().setText(fsDevNode.getBmcIP());
        this.modifyLayout.getSnmpPortField().setText(StringUtils.toString((Object)fsDevNode.getSnmpPort()));
        this.modifyLayout.getIpmiField().setText(StringUtils.toString((Object)fsDevNode.getIpmiPort()));
        this.modifyLayout.getSshSfipField().setText(StringUtils.toString((Object)fsDevNode.getSshPort()));
        this.modifyLayout.getVmField().setText(StringUtils.toString((Object)fsDevNode.getVmmPort()));
        this.modifyLayout.getRedfishField().setText(StringUtils.toString((Object)(fsDevNode.getRedFishPort().equals("") ? "443" : fsDevNode.getRedFishPort())));
    }

    private boolean checkBmcIpExist() {
        List<FSDevNode> allDevNodes = this.cardLayout.getAllFsNode();
        if (this.modify) {
            String bmcIP = this.modifyLayout.getBmcIpField().getText();
            if (bmcIP.isEmpty()) {
                String errMsg = ResourceUtil.getString((String)"dsfwupgrade.wizard.select.mustfill");
                DialogUtils.showErrorDialog((JDialog)this.addDialog, (String)errMsg);
                return false;
            }
            FSDevNode node = this.fsDevNodeList.get(0);
            for (FSDevNode fsNode : allDevNodes) {
                if (fsNode == node || !fsNode.getBmcIP().equals(bmcIP)) continue;
                String errMsg = ResourceUtil.getString((String)"dsfwupgrade.wizard.select.bmcip.exist");
                DialogUtils.showErrorDialog((JDialog)this.addDialog, (String)errMsg);
                return false;
            }
        }
        if (!CommonUtils.checkAuthNodeBmcIpEmpty((Dialog)this.addDialog, this.fsDevNodeList)) {
            return false;
        }
        return CommonUtils.checkAuthNodeIPHasDuplicate((Dialog)this.addDialog, this.fsDevNodeList, allDevNodes);
    }
}

