/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.ui.dialog.OsDeviceAddDialog;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.OsDeviceAddLayout;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCardLayout;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JDialog;

public class UpdateFSNodeOsAuthAction
implements ActionListener {
    private List<FSDevNode> fsDevNodeList;
    private OsDeviceAddLayout modifyLayout;
    private ActionListener[] confirmButtonlisteners;
    private OsDeviceAddDialog addDialog;

    public UpdateFSNodeOsAuthAction(FSDevNode fsDevNode) {
        this.fsDevNodeList = Collections.singletonList(fsDevNode);
    }

    public UpdateFSNodeOsAuthAction(List<FSDevNode> fsDevNodeList) {
        this.fsDevNodeList = fsDevNodeList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SelectNodeCardLayout.setServerType(ITDeviceType.SERVER_OS);
        JDialog wizardDialog = UpgradeContext.getInstance().getDialog();
        List<FSDevNode> nodeList = this.filterDev(this.fsDevNodeList);
        this.modifyLayout = new OsDeviceAddLayout(Constants.FUSIONSTORAGE, true);
        if (nodeList.isEmpty()) {
            String errMsg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice");
            DialogUtils.showErrorDialog((JDialog)wizardDialog, (String)errMsg);
            return;
        }
        for (Object fsNode : nodeList) {
            if (!fsNode.isSanBoxOpened()) continue;
            String errMsg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectdevicenotclosed");
            DialogUtils.showErrorDialog((JDialog)wizardDialog, (String)errMsg);
            return;
        }
        HashMap<String, String> fsIpMap = new HashMap<String, String>();
        for (FSDevNode fsNode : nodeList) {
            fsIpMap.put(fsNode.getManagementIP(), fsNode.getBmcIP());
        }
        this.addDialog = new OsDeviceAddDialog(this.modifyLayout, fsIpMap, true);
        if (e.getSource() instanceof JButton) {
            String title = ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.os");
            this.addDialog.setTitle(title);
        }
        for (ActionListener listener : this.confirmButtonlisteners = this.modifyLayout.getConfirmBtn().getActionListeners()) {
            this.modifyLayout.getConfirmBtn().removeActionListener(listener);
        }
        this.addListeners();
        SwingUtil.putParentCenter((Window)this.addDialog, (Window)wizardDialog);
        this.addDialog.setVisible(true);
    }

    private List<FSDevNode> filterDev(List<FSDevNode> fsDevNodeList) {
        return fsDevNodeList.stream().filter(node -> !node.isDirectPlane()).collect(Collectors.toList());
    }

    private void addListeners() {
        this.modifyLayout.getConfirmBtn().addActionListener(event -> this.exeConfirmParentListener(event));
    }

    private void exeConfirmParentListener(ActionEvent e) {
        for (ActionListener listener : this.confirmButtonlisteners) {
            listener.actionPerformed(e);
        }
    }
}

