/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.action;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.ui.dialog.layout.SandboxLayout;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCardLayout;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.rest.model.entity.vo.SandboxOperateInfo;
import com.huawei.ism.tool.service.sanbox.ISandBoxService;
import com.huawei.ism.tool.service.sanbox.SandBoxService;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateFSNodeSandboxAction
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateFSNodeSandboxAction.class);
    protected final ISandBoxService sandBoxService = new SandBoxService();
    private List<FSDevNode> fsDevNodes;
    private FSClusterDevice fsClusterDevice;
    private SandboxLayout modifyLayout;
    private ActionListener[] confirmButtonListeners;
    private JDialog sandboxDialog;
    private List<String> nodeIps = new ArrayList<String>();
    private List<FSDevNode> nodes;
    private SelectNodeCardLayout cardLayout;

    public UpdateFSNodeSandboxAction(SelectNodeCardLayout cardLayout, FSDevNode fsDevNode, FSClusterDevice fsClusterDevice) {
        this.fsDevNodes = Collections.singletonList(fsDevNode);
        this.fsClusterDevice = fsClusterDevice;
        this.cardLayout = cardLayout;
    }

    public UpdateFSNodeSandboxAction(SelectNodeCardLayout cardLayout, List<FSDevNode> fsDevNodeList, FSClusterDevice fsClusterDevice) {
        this.fsDevNodes = fsDevNodeList;
        this.fsClusterDevice = fsClusterDevice;
        this.cardLayout = cardLayout;
    }

    @Override
    public void actionPerformed(ActionEvent ee) {
        SelectNodeCardLayout.setServerType(ITDeviceType.SERVER_OS);
        JDialog wizardDialog = UpgradeContext.getInstance().getDialog();
        this.nodes = this.filterDev(this.fsDevNodes);
        this.modifyLayout = new SandboxLayout();
        if (this.nodes.isEmpty()) {
            String errMsg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice");
            DialogUtils.showErrorDialog((JDialog)wizardDialog, (String)errMsg);
            return;
        }
        for (FSDevNode node : this.nodes) {
            if (node.getNodeServiceInfo().getSandboxStatus().equals("0")) continue;
            String errMsg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.nosandbox");
            DialogUtils.showErrorDialog((JDialog)wizardDialog, (String)errMsg);
            return;
        }
        this.sandboxDialog = new JDialog();
        this.sandboxDialog.setLayout(new BorderLayout());
        this.sandboxDialog.add((Component)this.modifyLayout, "Center");
        this.sandboxDialog.setTitle(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.shutdown.sandbox"));
        this.sandboxDialog.setModal(true);
        this.sandboxDialog.setSize(new Dimension(420, 170));
        this.confirmBtnActionListener();
        this.cancelBtnActionListener();
        for (ActionListener listener : this.confirmButtonListeners = this.modifyLayout.getConfirmBtn().getActionListeners()) {
            this.modifyLayout.getConfirmBtn().removeActionListener(listener);
        }
        this.addListeners();
        SwingUtil.putParentCenter((Window)this.sandboxDialog, (Window)wizardDialog);
        this.sandboxDialog.setVisible(true);
    }

    private List<FSDevNode> filterDev(List<FSDevNode> fsDevNodeList) {
        return fsDevNodeList.stream().filter(node -> !node.isDirectPlane()).collect(Collectors.toList());
    }

    private void addListeners() {
        this.modifyLayout.getConfirmBtn().addActionListener(event -> this.exeConfirmParentListener(event));
    }

    private void exeConfirmParentListener(ActionEvent ee) {
        for (ActionListener listener : this.confirmButtonListeners) {
            listener.actionPerformed(ee);
        }
    }

    private void confirmBtnActionListener() {
        this.modifyLayout.getConfirmBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ee) {
                UpdateFSNodeSandboxAction.this.sandboxDialog.setVisible(false);
                UpdateFSNodeSandboxAction.this.sandboxDialog.dispose();
                UpdateFSNodeSandboxAction.this.sandboxCloseWaiting();
            }
        });
    }

    private void sandboxCloseWaiting() {
        String custMizeMsg = ResourceUtil.getString((String)"loading.close.text");
        JDialog parent = UpgradeContext.getInstance().getDialog();
        AsyncExcutor.execute((ProgressDialog)new ProgressDialog((Window)parent, custMizeMsg), (boolean)true, (long)0L, (Callable[])new Callable[]{new Callable<Boolean>(){

            @Override
            public Boolean call() {
                UpdateFSNodeSandboxAction.this.sandboxClose();
                return true;
            }
        }});
    }

    private void sandboxClose() {
        log.info("Start to disable the sandbox.");
        this.setNodeIps(this.nodes);
        String rootPwd = String.valueOf(this.modifyLayout.getRootPwdField().getPassword());
        SandboxOperateInfo info = this.setSandboxInfo(rootPwd, this.nodeIps);
        if (!this.sandBoxService.querySupportDisabledSandbox(this.fsClusterDevice.createDevNodeByClusterDevice())) {
            String errMsg = ResourceUtil.getString((String)"sandbox.not.supported.disabled");
            DialogUtils.showErrorDialog((JDialog)UpgradeContext.getInstance().getDialog(), (String)errMsg);
        }
        List successIps = this.sandBoxService.batchCloseSandBox(this.fsClusterDevice.createDevNodeByClusterDevice(), info.getNodeIps(), info.getRootPassword());
        this.updateNodeSandboxStatus(successIps, "1");
        List<ArrayList<Object>> errorIps = this.getErrorIps(successIps, info.getNodeIps());
        if (CollectionUtil.isEmpty(errorIps)) {
            this.fsClusterDevice.recordSandboxClose(successIps);
            String successMsg = ResourceUtil.getString((String)"sandbox.disabled.success");
            DialogUtils.showSuccessDialog((JDialog)UpgradeContext.getInstance().getDialog(), (String)successMsg);
            log.info("Sandbox disabled successfully on the following nodes:{}", (Object)successIps);
        } else {
            String errMsg = ResourceUtil.getString((String)"sandbox.disabled.failed");
            String[] headers = new String[]{ResourceUtil.getString((String)"sandbox.failed.close.ip")};
            DialogUtils.showMultiErrorDialog((Window)UpgradeContext.getInstance().getDialog(), (String)errMsg, (String[])headers, errorIps);
            log.info("Failed to disable the sandbox for the following nodes:{}", errorIps);
        }
    }

    private void setNodeIps(List<FSDevNode> nodes) {
        for (FSDevNode fsNode : nodes) {
            if (!fsNode.isSanBoxOpened()) continue;
            this.nodeIps.add(fsNode.getManagementIP());
        }
    }

    private List<ArrayList<Object>> getErrorIps(List<String> successIps, List<String> inputIps) {
        return inputIps.stream().filter(ip -> !successIps.contains(ip)).map(errorIp -> this.errorIpData((String)errorIp)).collect(Collectors.toList());
    }

    private ArrayList<Object> errorIpData(String errorIp) {
        ArrayList<Object> ipData = new ArrayList<Object>();
        ipData.add(errorIp);
        return ipData;
    }

    private void updateNodeSandboxStatus(List<String> nodeIps, String status) {
        for (FSDevNode node : this.nodes) {
            if (!nodeIps.contains(node.getManagementIP())) continue;
            node.getNodeServiceInfo().setSandboxStatus(status);
            this.cardLayout.updateTableRowData(node);
        }
    }

    private void cancelBtnActionListener() {
        this.modifyLayout.getCancelBtn().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ee) {
                UpdateFSNodeSandboxAction.this.sandboxDialog.setVisible(false);
                UpdateFSNodeSandboxAction.this.sandboxDialog.dispose();
            }
        });
    }

    private SandboxOperateInfo setSandboxInfo(String roodPwd, List<String> nodeIps) {
        SandboxOperateInfo sandboxInfo = new SandboxOperateInfo();
        sandboxInfo.setNodeIps(nodeIps);
        sandboxInfo.setRootPassword(roodPwd);
        return sandboxInfo;
    }
}

