/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.entity;

import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;
import javax.swing.ImageIcon;

public class Constants {
    public static final String DPC_MARK = "dpc_";
    public static final String SPLIT_REGEX = "[ \t\r]";
    public static final String DPC_DETAIL_URL = "/deploy_manager/compute_components_detail";
    public static final String DPC_PARAM_IP_LIST = "ipList";
    public static final String DPC_RESP_ERROR_CODE = "errorCode";
    public static final String DPC_RESP_DESCRIPTION = "description";
    public static final String DPC_RESP_SUGGESTION = "suggestion";
    public static final String DPC_RESP_DATA = "data";
    public static final String DPC_DETAIL_IP = "ip";
    public static final String DPC_DETAIL_CURRENT_VERSION = "currentVersion";
    public static final String DPC_DETAIL_TARGET_VERSION = "targetVersion";
    public static final String DPC_DETAIL_CONSISTENT = "consistent";
    public static String FUSIONSTORAGE = "FusionStorage";
    public static String LOCAL_SEPARATOR = "#";
    public static String UPDATE_TYPE = "UpdateType";
    public static String FS_UPGRADE_BATCH_FILE_PATH = ContextUtil.getToolBoxPath() + File.separator + "temp" + File.separator + "sceneTemplates" + File.separator + "server";
    public static final String LOCAL_UPGRADE_SCRIPT_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator + "upgrade_script";
    public static String UPGRADE_SCRIPT_PACKAGE_NAME = "action.zip";
    public static String SERVER_UPGRADE_SCRIPT_PATH = "/opt/fusionstorage/deploymanager/compute_upgrade";
    public static String UPGRADE_SCRIPT_FILE_NAME = "compute_upgrade.sh";
    public static final String PULL_UPGRADE_COMMAND = "compute_download.sh";
    public static String ROLLBACK_SCRIPT_FILE_NAME = "compute_rollback.sh";
    public static String ROLLBACK_DIRECTORY_PATH = "/opt/fusionstorage/deploymanager/compute_backup";
    public static String SERVER_TMP_PATH = "/tmp";
    public static String COMPUTE = "compute";
    public static String DPC_COMPUTE = "dpc_compute";
    public static final ImageIcon RUNNING_IMG = ResourceUtil.getImage((String)"running.gif");
    public static final ImageIcon SUCCESS_IMG = ResourceUtil.getImage((String)"pass.png");
    public static final ImageIcon WAIT_IMG = ResourceUtil.getImage((String)"waiting.png");
    public static final ImageIcon NOT_PASS_IMG = ResourceUtil.getImage((String)"notpass.png");
    public static final ImageIcon PAUSE_IMG = ResourceUtil.getImage((String)"pause.png");

    public static enum AutoAnswerUpgrade {
        MEMORY_HIGHER(ResourceUtil.getString((String)"upgrade.compute.node.dpc.memory.waring"), ResourceUtil.getString((String)"upgrade.compute.node.dpc.memory.waring.suggestion")),
        CPU_HIGHER(ResourceUtil.getString((String)"upgrade.compute.node.dpc.cpu.waring"), ResourceUtil.getString((String)"upgrade.compute.node.dpc.cpu.waring.suggestion"));

        private String warning;
        private String suggestion;

        private AutoAnswerUpgrade(String warning, String suggestion) {
            this.warning = warning;
            this.suggestion = suggestion;
        }

        public String getWarning() {
            return this.warning;
        }

        public String getSuggestion() {
            return this.suggestion;
        }
    }

    public class BoardType {
        public static final String DEFAULT = "DEFAULT";
        public static final String DIRECT_PLANE = "DirectPlane";
    }

    public static enum FsUpgradeScene {
        FirmwarePrepare("UpgradePrepare"),
        FirmwareUpgrade("Fusion_Strg_Svr_Upgrade"),
        ComputeNodePrepare("ComputeNodePrepare"),
        ComputeNodeUpgrade("ComputeNodeUpgrade");

        private String desc;

        private FsUpgradeScene(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum NodeUpgradeState {
        NOT_START(0, WAIT_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.not.start")),
        PREPARED(1, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.prepared")),
        PREPARE_FAILED(2, PAUSE_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.prepare.failed")),
        SCRIPT_UPLOADED(3, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.script.uploaded")),
        SCRIPT_UPLOAD_FAILED(4, PAUSE_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.script.upload.failed")),
        STARTED(5, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.started")),
        START_FAILED(6, PAUSE_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.start.failed")),
        UPGRADING(7, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.upgrading")),
        FAILED(8, NOT_PASS_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.failed")),
        SUCCEEDED(9, SUCCESS_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.succeeded")),
        ROLLBACKING(10, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.rollback")),
        ROLLBACK_FAILED(11, PAUSE_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.rollback.failed")),
        ROLLBACK_SUCCEEDED(12, SUCCESS_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.rollback.success")),
        NO_NEED_ROLLBACK(13, SUCCESS_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.rollback.no.need")),
        TIMEOUT(14, PAUSE_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.timeout")),
        PULL_UPGRADE_PKG(15, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.get.upgrade.pkg")),
        PULL_UPGRADE_PKG_FAILED(16, PAUSE_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.get.upgrade.pkg.failed")),
        PULL_UPGRADE_PKG_SUCCESS(17, WAIT_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.get.upgrade.pkg.success")),
        UPGRADE_CHECK(18, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.upgrade.check")),
        UPGRADE_CHECK_SUCCESS(19, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.upgrade.check.success")),
        UPGRADE_CHECK_FAILED(20, PAUSE_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.upgrade.check.failed")),
        ROLLBACK_CHECK(21, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.rollback.check")),
        ROLLBACK_CHECK_SUCCESS(22, RUNNING_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.rollback.check.success")),
        ROLLBACK_CHECK_FAILED(23, PAUSE_IMG, ResourceUtil.getString((String)"upgrade.compute.node.status.rollback.check.failed"));

        private int code;
        private ImageIcon imageIcon;
        private String desc;

        public boolean isFailedStatus() {
            return Stream.of(PREPARE_FAILED, SCRIPT_UPLOAD_FAILED, START_FAILED, FAILED, ROLLBACK_FAILED, TIMEOUT, PULL_UPGRADE_PKG_FAILED, UPGRADE_CHECK_FAILED, UPGRADE_CHECK_FAILED, ROLLBACK_CHECK_FAILED).anyMatch(status -> status == this);
        }

        public boolean isPullPkgFinishStatus() {
            return Stream.of(PULL_UPGRADE_PKG_SUCCESS, PULL_UPGRADE_PKG_FAILED).anyMatch(status -> status == this);
        }

        public boolean isSuccessStatus() {
            return this == SUCCEEDED;
        }

        public boolean isUpgradePrepareFailedStatus() {
            return Stream.of(PREPARE_FAILED, SCRIPT_UPLOAD_FAILED, PULL_UPGRADE_PKG_FAILED).anyMatch(status -> status == this);
        }

        public boolean isExecuteStatus() {
            return Stream.of(STARTED, UPGRADING, PULL_UPGRADE_PKG).anyMatch(status -> status == this);
        }

        public boolean isRollBackStatus() {
            return Stream.of(ROLLBACKING, ROLLBACK_FAILED, ROLLBACK_SUCCEEDED, NO_NEED_ROLLBACK, ROLLBACK_CHECK, ROLLBACK_CHECK_FAILED, ROLLBACK_CHECK_SUCCESS).anyMatch(status -> status == this);
        }

        public boolean isUpgradeFailed() {
            return Stream.of(FAILED, UPGRADE_CHECK_FAILED, START_FAILED).anyMatch(status -> status == this);
        }

        public boolean isUpgradeCheckFailed() {
            return this == UPGRADE_CHECK_FAILED;
        }

        public boolean isUpgradeCheckStatus() {
            return Stream.of(UPGRADE_CHECK, UPGRADE_CHECK_SUCCESS, UPGRADE_CHECK_FAILED, STARTED, START_FAILED).anyMatch(status -> status == this);
        }

        public boolean isRollBackCheckFailed() {
            return Stream.of(ROLLBACK_FAILED, ROLLBACK_CHECK_FAILED).anyMatch(status -> status == this);
        }

        public boolean isRollbackSuccess() {
            return this == ROLLBACK_SUCCEEDED;
        }

        public boolean isRollbackFailed() {
            return this == ROLLBACK_FAILED;
        }

        public boolean isSuccessUpgradeOrRollback() {
            return this == SUCCEEDED || this == ROLLBACK_SUCCEEDED || this == NO_NEED_ROLLBACK;
        }

        public boolean isFinishedStatus() {
            return this.isFailedStatus() || this.isSuccessStatus() || this.isPullPkgSuccessStatus() || this.isRollbackSuccess() || this == NO_NEED_ROLLBACK;
        }

        public boolean isPullPkgSuccessStatus() {
            return this == PULL_UPGRADE_PKG_SUCCESS;
        }

        public boolean isRetryStatus() {
            return Stream.of(FAILED, PULL_UPGRADE_PKG_SUCCESS).anyMatch(status -> status == this);
        }

        public boolean isUpgradePrepareStatus() {
            return Stream.of(NOT_START, PREPARED, PREPARE_FAILED, SCRIPT_UPLOADED, SCRIPT_UPLOAD_FAILED, PULL_UPGRADE_PKG, PULL_UPGRADE_PKG_FAILED, PULL_UPGRADE_PKG_SUCCESS).anyMatch(status -> status == this);
        }

        public boolean isPullPkgStatus() {
            return Stream.of(PULL_UPGRADE_PKG, PULL_UPGRADE_PKG_FAILED, PULL_UPGRADE_PKG_SUCCESS).anyMatch(status -> status == this);
        }

        private NodeUpgradeState(int code, ImageIcon icon, String desc) {
            this.code = code;
            this.imageIcon = icon;
            this.desc = desc;
        }

        public ImageIcon getImageIcon() {
            return this.imageIcon;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        public static NodeUpgradeState getStateByDesc(String desc) {
            return Arrays.stream(NodeUpgradeState.values()).filter(value -> value.getDesc().equals(desc)).findFirst().orElse(NOT_START);
        }
    }

    public static enum NodeAuthState {
        UNAUTH,
        SUCCESS,
        FAIL,
        NOT_REQUIRED;


        public String getDesc() {
            String name = this.name().toLowerCase(Locale.ENGLISH);
            String desc = ResourceUtil.getString((String)("dsfwupgrade.auth.state." + name));
            return desc;
        }
    }
}

