/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.entity;

import java.util.Arrays;

public enum DpcInstallDirectoryEnum {
    OCEANSTOR_PACIFIC_816("8.1.6", true),
    OCEANSTOR_PACIFIC_820("8.2.0L15Y01", false),
    OCEANSTOR_PACIFIC_821("8.2.1", true);

    private final String version;
    private boolean fuzzy;

    public static boolean isSupportVersion(String currentProductVersion) {
        return Arrays.stream(DpcInstallDirectoryEnum.values()).anyMatch(version -> DpcInstallDirectoryEnum.isEquals(currentProductVersion, version));
    }

    private static boolean isEquals(String currentProductVersion, DpcInstallDirectoryEnum version) {
        if (version.isFuzzy()) {
            return currentProductVersion.contains(version.getVersion());
        }
        return currentProductVersion.equalsIgnoreCase(version.getVersion());
    }

    private DpcInstallDirectoryEnum(String version, boolean fuzzy) {
        this.version = version;
        this.fuzzy = fuzzy;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isFuzzy() {
        return this.fuzzy;
    }
}

