/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.entity;

import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class FSClusterDevice {
    private String floatIp = "";
    private User loginUser = null;
    private String productName = "";
    private String productVersion = "";
    private String hotPatchVersion = "";
    private String distributedHotPatchVersion = "";
    private String productModel = "";
    private String sn = "";
    private boolean selected = false;
    private List<FSDevNode> fsDevNodeList = new ArrayList<FSDevNode>();
    private String innerFloatIp = "";
    private boolean initialized = false;
    private List<String> sandboxClosedList = new ArrayList<String>();
    private ClusterNode.BaseBoardType baseBoardType;

    public FSClusterDevice() {
    }

    public FSClusterDevice(DevNode devNode, boolean initialized) {
        this.floatIp = devNode.getIp();
        this.productVersion = devNode.getProductVersion();
        this.hotPatchVersion = devNode.getHotPatchVersion();
        this.distributedHotPatchVersion = devNode.getProductVersionToShow();
        this.productName = devNode.getDeviceName();
        this.productModel = null == devNode.getDeviceType() ? devNode.getProductModel() : devNode.getDeviceType().toString();
        this.loginUser = devNode.getLoginUser();
        this.sn = devNode.getDeviceSerialNumber();
        this.initialized = initialized;
        this.baseBoardType = devNode.getBaseBoardType();
    }

    public FSClusterDevice(DevNode devNode) {
        this(devNode, false);
    }

    public DevNode createDevNodeByClusterDevice() {
        DevNode devNode = new DevNode();
        devNode.setIp(this.floatIp);
        devNode.setProductVersion(this.productVersion);
        devNode.setHotPatchVersion(this.hotPatchVersion);
        devNode.setDeviceName(this.productName);
        devNode.setProductModel(this.getProductModel());
        devNode.setLoginUser(this.loginUser);
        devNode.setDeviceSerialNumber(this.sn);
        devNode.setItDeviceType(ItDeviceType.DStorage);
        devNode.setSelectedNodeIps(this.getSelectNodeIps());
        return devNode;
    }

    @NotNull
    private List<String> getSelectNodeIps() {
        return this.getFsDevNodeList().stream().filter(FSDevNode::isSelected).map(FSDevNode::getManagementIP).collect(Collectors.toList());
    }

    public String getFloatIp() {
        return this.floatIp;
    }

    public String getInnerFloatIp() {
        return this.innerFloatIp;
    }

    public void setInnerFloatIp(String innerFloatIp) {
        this.innerFloatIp = innerFloatIp;
    }

    public String getFloatIp2FileName() {
        return this.floatIp.replaceAll(":", "_");
    }

    public void setFloatIp(String floatIp) {
        this.floatIp = floatIp;
    }

    public User getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(User loginUser) {
        this.loginUser = loginUser;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductModel() {
        return this.productModel;
    }

    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    public String getSn() {
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public List<FSDevNode> getFsDevNodeList() {
        return this.fsDevNodeList;
    }

    public void setFsDevNodeList(List<FSDevNode> fsDevNodeList) {
        this.fsDevNodeList = fsDevNodeList;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void recordSandboxClose(List<String> successIps) {
        this.sandboxClosedList.addAll(successIps);
    }

    public boolean needOSAuth() {
        return UpgradeContext.getInstance().needOsAuth();
    }

    public boolean needBMCAuth() {
        return UpgradeContext.getInstance().needBmcAuth();
    }

    public static boolean isTwoOcean(DevNode node) {
        return ResourceUtil.getString((String)"pacific.model", (Locale)Locale.CHINESE).contains(node.getProductModel());
    }

    public String toString() {
        return "FSClusterDevice(floatIp=" + this.getFloatIp() + ")";
    }

    public String getHotPatchVersion() {
        return this.hotPatchVersion;
    }

    public void setHotPatchVersion(String hotPatchVersion) {
        this.hotPatchVersion = hotPatchVersion;
    }

    public void setDistributedHotPatchVersion(String distributedHotPatchVersion) {
        this.distributedHotPatchVersion = distributedHotPatchVersion;
    }

    public String getDistributedHotPatchVersion() {
        return this.distributedHotPatchVersion;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public List<String> getSandboxClosedList() {
        return this.sandboxClosedList;
    }

    public ClusterNode.BaseBoardType getBaseBoardType() {
        return this.baseBoardType;
    }
}

