/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.entity;

import com.google.gson.annotations.Expose;
import com.huawei.bundleupgrade.entity.ComputeNodeUpgradeResult;
import com.huawei.bundleupgrade.entity.NodeServiceInfo;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicecenter.entity.HwServerDevice;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class FSDevNode
extends HwServerDevice {
    private String managementIP = "";
    private String managementExternalFloatIp = "";
    private String managementInnerFloatIp = "";
    private String storageFrontIp = "";
    private String deployPrefix = "";
    private List<String> managementIps;
    private List<String> storageBackEndPortList = new ArrayList<String>();
    private List<String> storageFrontendEndPortList = new ArrayList<String>();
    private String BmcIP = "";
    private List<String> roles = new ArrayList<String>();
    private String productName = "";
    private String oldVersion = "";
    private String currentVersion = "";
    private String targetVersion = "";
    private boolean isConsistent;
    private boolean isQueryDpcSuccess;
    private Constants.NodeAuthState bmcAuthState = Constants.NodeAuthState.UNAUTH;
    private Constants.NodeAuthState osAuthState = Constants.NodeAuthState.UNAUTH;
    private boolean selected = false;
    private List<String> services = new ArrayList<String>();
    private String bmcUserName;
    private String bmcPassword;
    private String osUserName;
    private String osPassword;
    private String osRootPassword;
    private String serialNumber;
    private Constants.NodeUpgradeState upgradeStatus = Constants.NodeUpgradeState.NOT_START;
    private String borderType = "DEFAULT";
    private int volumeNum = -1;
    private NodeServiceInfo nodeServiceInfo;
    @Expose(serialize=false)
    private boolean uploadSuccess;
    private String chassisId = "--";
    private String errorDescription = "";
    private String errorSuggestion = "";
    private boolean isSingleRetryRunning;
    private boolean isOemSetting;
    private ComputeNodeUpgradeResult computeNodeUpgradeResult = new ComputeNodeUpgradeResult();
    private boolean isRetryQueryNodeStatus;
    private boolean isVbsNode = false;

    public String getDpcNodeDeployPrefix() {
        return this.isDpcComputeNode() ? this.deployPrefix : "";
    }

    public String getScriptPath() {
        return this.getDpcNodeDeployPrefix().concat(Constants.SERVER_UPGRADE_SCRIPT_PATH);
    }

    public void setNeedQueryStatus(FSDevNode fsDevNode) {
        this.isRetryQueryNodeStatus = Constants.NodeUpgradeState.FAILED.equals((Object)fsDevNode.getUpgradeStatus());
    }

    public boolean isVbsNode() {
        return this.isVbsNode;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setOldVersion(String oldVersion) {
        if (!StringUtils.isNULLStr((String)this.oldVersion)) {
            return;
        }
        this.oldVersion = oldVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public boolean isRollbackStatus() {
        return this.getUpgradeStatus().isRollBackStatus();
    }

    public String getStorageFrontIp() {
        return this.storageFrontIp;
    }

    public void setStorageFrontIp(String storageFrontIp) {
        this.storageFrontIp = storageFrontIp;
    }

    public boolean isFsmNode() {
        return !StringUtils.isNULLStr((String)this.managementExternalFloatIp) || !StringUtils.isNULLStr((String)this.managementInnerFloatIp);
    }

    public void setVbsNode(boolean vbsNode) {
        this.isVbsNode = vbsNode;
    }

    public String getManagementExternalFloatIp() {
        return this.managementExternalFloatIp;
    }

    public void setManagementExternalFloatIp(String managementExternalFloatIp) {
        this.managementExternalFloatIp = managementExternalFloatIp;
    }

    public String getManagementInnerFloatIp() {
        return this.managementInnerFloatIp;
    }

    public void setManagementInnerFloatIp(String managementInnerFloatIp) {
        this.managementInnerFloatIp = managementInnerFloatIp;
    }

    public String getManagementIP() {
        return this.managementIP;
    }

    public String getDevKey() {
        if (this.isDirectPlane()) {
            return this.getBmcIP();
        }
        return this.managementIP;
    }

    public void setManagementIP(String managementIP) {
        this.managementIP = managementIP;
    }

    public String getBmcIP() {
        return this.BmcIP;
    }

    public void setBmcIP(String bmcIP) {
        this.BmcIP = bmcIP;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Constants.NodeAuthState getBmcAuthState() {
        return this.bmcAuthState;
    }

    public void setBmcAuthState(Constants.NodeAuthState bmcAuthState) {
        this.bmcAuthState = bmcAuthState;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    public Constants.NodeAuthState getOsAuthState() {
        return this.osAuthState;
    }

    public void setOsAuthState(Constants.NodeAuthState osAuthState) {
        this.osAuthState = osAuthState;
    }

    public String getBmcUserName() {
        return this.bmcUserName;
    }

    public void setBmcUserName(String bmcUserName) {
        this.bmcUserName = bmcUserName;
    }

    public String getBmcPassword() {
        return AESEncrypt.decrypt((String)this.bmcPassword);
    }

    public String getBmcPasswordWithoutDecrypt() {
        return this.bmcPassword;
    }

    public void setBmcPassword(String bmcPassword) {
        this.bmcPassword = AESEncrypt.encrypt((String)bmcPassword);
    }

    public String getOsUserName() {
        return this.osUserName;
    }

    public void setOsUserName(String osUserName) {
        this.osUserName = osUserName;
    }

    public String getOsPassword() {
        return AESEncrypt.decrypt((String)this.osPassword);
    }

    public String getOsPasswordWithoutDecrypt() {
        return this.osPassword;
    }

    public void setOsPassword(String osPassword) {
        this.osPassword = AESEncrypt.encrypt((String)osPassword);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void addStorageBackEndPortName(String portName) {
        this.storageBackEndPortList.add(portName);
    }

    public void addStorageFrontEndPortName(String portName) {
        this.storageFrontendEndPortList.add(portName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FSDevNode)) {
            return false;
        }
        FSDevNode fs = (FSDevNode)((Object)obj);
        if (!this.toString().equals(fs.toString())) {
            return false;
        }
        if (!this.getManagementIP().equals(fs.getManagementIP())) {
            return false;
        }
        return this.getBmcIP().equals(fs.getBmcIP());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getAuthStateDesc() {
        return this.getAuthStateDesc(true, true);
    }

    public String getAuthStateDesc(boolean needBmcAuth, boolean needOsAuth) {
        if (needBmcAuth && needOsAuth) {
            return String.format(Locale.ENGLISH, "BMC:%s; OS:%s", this.bmcAuthState.getDesc(), this.osAuthState.getDesc());
        }
        if (needBmcAuth) {
            return this.bmcAuthState.getDesc();
        }
        if (needOsAuth) {
            return this.osAuthState.getDesc();
        }
        return String.format(Locale.ENGLISH, "BMC:%s; OS:%s", this.bmcAuthState.getDesc(), this.osAuthState.getDesc());
    }

    public String getsandboxStateDesc(String sandboxstatus) {
        if ("0".equals(sandboxstatus)) {
            return ResourceUtil.getString((String)"dsfwupgrade.wizard.status.sandbox.closed");
        }
        if ("1".equals(sandboxstatus)) {
            return ResourceUtil.getString((String)"dsfwupgrade.wizard.status.sandbox.opened");
        }
        if ("-1".equals(sandboxstatus)) {
            return ResourceUtil.getString((String)"dsfwupgrade.wizard.status.sandbox.notOS");
        }
        return ResourceUtil.getString((String)"dsfwupgrade.wizard.status.sandbox.notconfigured");
    }

    public Constants.NodeUpgradeState getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public void setUpgradeStatus(Constants.NodeUpgradeState upgradeStatus) {
        this.upgradeStatus = upgradeStatus;
        this.setEndTime(upgradeStatus);
    }

    public void setUpgradeStatus(String upgradeStatus) {
        this.upgradeStatus = Constants.NodeUpgradeState.getStateByDesc(upgradeStatus);
    }

    private void setEndTime(Constants.NodeUpgradeState upgradeStatus) {
        if (this.isFinished()) {
            this.computeNodeUpgradeResult.setEndTime(new Date());
        }
    }

    public boolean isFailed() {
        return this.upgradeStatus.isFailedStatus();
    }

    public boolean isUpgradePrepare() {
        return this.upgradeStatus.isUpgradeCheckStatus();
    }

    public boolean isUpgradeFailed() {
        return this.upgradeStatus.isUpgradeFailed();
    }

    public boolean isFinished() {
        return this.upgradeStatus.isFinishedStatus();
    }

    public boolean isRunning() {
        return Arrays.asList(Constants.NodeUpgradeState.STARTED, Constants.NodeUpgradeState.UPGRADING, Constants.NodeUpgradeState.ROLLBACKING).stream().anyMatch(upgrading -> this.upgradeStatus == upgrading);
    }

    public boolean isRecoverable() {
        return Constants.NodeUpgradeState.STARTED == this.upgradeStatus || Constants.NodeUpgradeState.UPGRADING == this.upgradeStatus;
    }

    public boolean isRollbackSucceeded() {
        return Constants.NodeUpgradeState.ROLLBACK_SUCCEEDED.equals((Object)this.upgradeStatus);
    }

    public boolean isRollbackFailed() {
        return this.upgradeStatus.isRollBackCheckFailed();
    }

    public boolean isStartedUpgrade() {
        return this.upgradeStatus == Constants.NodeUpgradeState.STARTED || this.upgradeStatus == Constants.NodeUpgradeState.UPGRADING;
    }

    public String getOsRootPassword() {
        return AESEncrypt.decrypt((String)this.osRootPassword);
    }

    public String getOsRootPasswordWithoutEncrypt() {
        return this.osRootPassword;
    }

    public void setOsRootPassword(String osRootPassword) {
        this.osRootPassword = AESEncrypt.encrypt((String)osRootPassword);
    }

    public boolean hasUpload() {
        return this.uploadSuccess;
    }

    public void setUploadSuccess() {
        this.uploadSuccess = true;
    }

    public boolean isPureComputeNode() {
        return this.getRoles().size() == 1 && this.getRoles().get(0).contains(Constants.COMPUTE);
    }

    public boolean isPureDpcComputeNode() {
        return this.getRoles().size() == 1 && this.getRoles().get(0).contains(Constants.DPC_COMPUTE);
    }

    public boolean isComputeNode() {
        return this.getRoles().stream().anyMatch(role -> role.contains(Constants.COMPUTE));
    }

    public boolean isDpcComputeNode() {
        return this.getRoles().stream().anyMatch(role -> role.contains("dpc")) || this.getServices().stream().anyMatch(service -> service.contains("dpc"));
    }

    public boolean isManagementNode() {
        return this.getRoles().stream().anyMatch(role -> role.contains("management"));
    }

    public void setNodeServiceInfo(NodeServiceInfo nodeServiceInfo) {
        this.nodeServiceInfo = nodeServiceInfo;
    }

    public NodeServiceInfo getNodeServiceInfo() {
        return this.nodeServiceInfo;
    }

    public boolean isSanBoxOpened() {
        if (this.nodeServiceInfo != null) {
            return "0".equals(this.nodeServiceInfo.getSandboxStatus());
        }
        return false;
    }

    public String getBorderType() {
        return this.borderType;
    }

    public void setBorderType(String borderType) {
        this.borderType = borderType;
    }

    public boolean isDirectPlane() {
        return "DirectPlane".equals(this.borderType);
    }

    public boolean isBmcAuthRequired() {
        return this.bmcAuthState != Constants.NodeAuthState.NOT_REQUIRED;
    }

    public void setVolumeNum(int volumeNum) {
        this.volumeNum = volumeNum;
    }

    public boolean hasVolume() {
        return this.volumeNum > 0;
    }

    public int getVolumeNum() {
        return this.volumeNum;
    }

    public boolean isOsAuthSuccess() {
        return Constants.NodeAuthState.SUCCESS.equals((Object)this.getOsAuthState());
    }

    public void clearMsg() {
        this.errorDescription = "";
        this.errorSuggestion = "";
    }

    public boolean isProprietaryHardware() {
        return ClusterNode.BaseBoardType.getProprietaryHardwareProductName().contains(this.borderType);
    }

    public void setDeployPrefix(String deployPrefix) {
        this.deployPrefix = deployPrefix;
    }

    public String getDeployPrefix() {
        return this.deployPrefix;
    }

    public void setManagementIps(List<String> managementIps) {
        this.managementIps = managementIps;
    }

    public List<String> getManagementIps() {
        return this.managementIps;
    }

    public List<String> getStorageBackEndPortList() {
        return this.storageBackEndPortList;
    }

    public void setStorageBackEndPortList(List<String> storageBackEndPortList) {
        this.storageBackEndPortList = storageBackEndPortList;
    }

    public List<String> getStorageFrontendEndPortList() {
        return this.storageFrontendEndPortList;
    }

    public void setStorageFrontendEndPortList(List<String> storageFrontendEndPortList) {
        this.storageFrontendEndPortList = storageFrontendEndPortList;
    }

    public String getOldVersion() {
        return this.oldVersion;
    }

    public boolean isConsistent() {
        return this.isConsistent;
    }

    public void setConsistent(boolean isConsistent) {
        this.isConsistent = isConsistent;
    }

    public boolean isQueryDpcSuccess() {
        return this.isQueryDpcSuccess;
    }

    public void setQueryDpcSuccess(boolean isQueryDpcSuccess) {
        this.isQueryDpcSuccess = isQueryDpcSuccess;
    }

    public String getChassisId() {
        return this.chassisId;
    }

    public void setChassisId(String chassisId) {
        this.chassisId = chassisId;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public String getErrorSuggestion() {
        return this.errorSuggestion;
    }

    public void setErrorSuggestion(String errorSuggestion) {
        this.errorSuggestion = errorSuggestion;
    }

    public boolean isSingleRetryRunning() {
        return this.isSingleRetryRunning;
    }

    public void setSingleRetryRunning(boolean isSingleRetryRunning) {
        this.isSingleRetryRunning = isSingleRetryRunning;
    }

    public boolean isOemSetting() {
        return this.isOemSetting;
    }

    public void setOemSetting(boolean isOemSetting) {
        this.isOemSetting = isOemSetting;
    }

    public void setComputeNodeUpgradeResult(ComputeNodeUpgradeResult computeNodeUpgradeResult) {
        this.computeNodeUpgradeResult = computeNodeUpgradeResult;
    }

    public ComputeNodeUpgradeResult getComputeNodeUpgradeResult() {
        return this.computeNodeUpgradeResult;
    }

    public void setRetryQueryNodeStatus(boolean isRetryQueryNodeStatus) {
        this.isRetryQueryNodeStatus = isRetryQueryNodeStatus;
    }

    public boolean isRetryQueryNodeStatus() {
        return this.isRetryQueryNodeStatus;
    }
}

