/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.entity;

import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class UpgradeScriptConfig {
    public static final String DIRECT_EXEC = "Direct";
    private String scriptExecType = "Direct";
    private String scriptName;
    private String scriptPath;
    private Set<String> supportModelSet = new HashSet<String>();
    private Set<String> supportVersionSet = new HashSet<String>();

    public boolean isSupport(FSClusterDevice clusterDev) {
        if (clusterDev.getProductVersion().contains("8.1.6")) {
            return this.modelSupport(clusterDev.getProductModel()) && this.supportVersionSet.contains("8.1.6");
        }
        return this.modelSupport(clusterDev.getProductModel()) && this.versionSupport(clusterDev.getProductVersion());
    }

    private boolean modelSupport(String clusterModel) {
        if (this.supportModelSet.isEmpty()) {
            return true;
        }
        return this.supportModelSet.stream().anyMatch(configModel -> configModel.equals(clusterModel));
    }

    private boolean versionSupport(String clusterVersion) {
        if (this.supportVersionSet.isEmpty()) {
            return true;
        }
        return this.supportVersionSet.stream().anyMatch(configVersion -> clusterVersion.contains((CharSequence)configVersion));
    }

    public Set<String> getSupportModelSet() {
        return this.supportModelSet;
    }

    public Set<String> getSupportVersionSet() {
        return this.supportVersionSet;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getScriptPath() {
        if (this.scriptPath == null) {
            return Constants.LOCAL_UPGRADE_SCRIPT_PATH + File.separator + this.scriptName;
        }
        return this.scriptPath;
    }

    public String getScriptExecType() {
        return this.scriptExecType;
    }

    public void setScriptExecType(String scriptExecType) {
        this.scriptExecType = scriptExecType;
    }
}

