/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.service;

import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.entity.UpdateType;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeDialog;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeLayout;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.SingletonToken;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;

public class FsUpgradeFlowService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FsUpgradeFlowService.class);
    private static final int QUERY_INTERVAL_TIMES = 30000;
    private static final Object lock = new Object();
    public static final String AUTO_ANSWER_YES = "yes";
    public static final String AUTO_ANSWER_NO = "no";
    private static int maxUpgradeTime = 60;
    private static int maxRollbackTime = 60;
    private static UpdateType updateType = UpdateType.VBS;
    private UpgradeComputeNodeLayout layout;
    private FSDevNode node;
    private int parallelSize;
    private static ExecutorService executor = Executors.newSingleThreadExecutor();
    private static ExecutorService executorSingleRetry = Executors.newFixedThreadPool(10);
    private static ExecutorService executorUpgrade = Executors.newFixedThreadPool(20);
    private static List<String> oldVersions = Collections.synchronizedList(new ArrayList());
    private DevNode clusterDevNode;
    private Date upgradeTaskStartTime;
    private Date upgradeTaskEndTime;
    private String autoAnswer = "no";

    public FsUpgradeFlowService(UpgradeComputeNodeLayout layout) {
        String parallelSizeConfValue;
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        List selectNodes = clusterDev.getFsDevNodeList().stream().filter(FSDevNode::isSelected).collect(Collectors.toList());
        boolean isDpcScene = selectNodes.stream().anyMatch(FSDevNode::isDpcComputeNode);
        String configKey = "compute.node.upgrade.config.parallel.size";
        String defaultSize = "200";
        if (isDpcScene) {
            configKey = "compute.node.upgrade.config.parallel.size.dpc";
            defaultSize = "1000";
        }
        if (StringUtils.isNULLStr((String)(parallelSizeConfValue = ApplicationContext.getInstance().getAppConfig(configKey)))) {
            parallelSizeConfValue = defaultSize;
        }
        this.parallelSize = Integer.parseInt(parallelSizeConfValue);
        LOGGER.info("current parallelSize:{}", (Object)this.parallelSize);
        if (this.parallelSize > 200) {
            FsUpgradeService.setReleaseConn(true);
        }
        this.layout = layout;
        this.clusterDevNode = CommonUtils.transFsClusterDev2DevNode(clusterDev);
    }

    public void submitTask(Runnable task) {
        executor.execute(task);
    }

    public FsUpgradeFlowService(UpgradeComputeNodeLayout layout, FSDevNode node) {
        this.layout = layout;
        this.node = node;
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        this.clusterDevNode = CommonUtils.transFsClusterDev2DevNode(clusterDev);
    }

    private void init() {
        SingletonToken.getInstance().setToken("");
    }

    public void parallelUpgrade() {
        this.layout.setCurrentUpgradeType(FsUpgradeFlowService.getUpdateType().getTypeDesc());
        String batchId = UpgradeContext.getInstance().getBatchId();
        List<FSDevNode> canUpgradeNode = this.layout.getAllNodes().stream().filter(fsNode -> fsNode.getUpgradeStatus().isPullPkgSuccessStatus()).collect(Collectors.toList());
        this.layout.updateDeviceTableRow(canUpgradeNode, Constants.NodeUpgradeState.UPGRADE_CHECK);
        this.executeUpgrade(batchId, this.getBatchList(canUpgradeNode));
    }

    public void recoverParallelUpgrade() {
        String batchId = UpgradeContext.getInstance().getBatchId();
        LOGGER.info("ComputeNode recoverParallelUpgrade batchId: {}", (Object)batchId);
        List<FSDevNode> allFsNode = this.layout.getAllNodes();
        LOGGER.info("ComputeNode recoverParallelUpgrade allNodes count: {}", (Object)allFsNode.size());
        ArrayList<FSDevNode> notStartedNodes = new ArrayList<FSDevNode>();
        ArrayList<FSDevNode> recoverNodes = new ArrayList<FSDevNode>();
        for (FSDevNode fsDevNode : allFsNode) {
            if (Constants.NodeUpgradeState.UPGRADE_CHECK.equals((Object)fsDevNode.getUpgradeStatus())) {
                LOGGER.info("ComputeNode recoverParallelUpgrade not start node: {}", (Object)fsDevNode.getManagementIP());
                notStartedNodes.add(fsDevNode);
            }
            if (!fsDevNode.isRecoverable()) continue;
            LOGGER.info("ComputeNode recoverParallelUpgrade recover node: {}", (Object)fsDevNode.getManagementIP());
            recoverNodes.add(fsDevNode);
        }
        this.recoverNodesUpgrade(recoverNodes);
        this.layout.updateDeviceTableRow(notStartedNodes, Constants.NodeUpgradeState.UPGRADE_CHECK);
        this.executeUpgrade(batchId, this.getBatchList(notStartedNodes));
    }

    private void postUpgradeHandle() {
        this.refreshRetryAndRollbackBtn();
        this.layout.resetFailedNum((int)this.layout.getAllNodes().stream().filter(FSDevNode::isUpgradeFailed).count());
        try {
            if (this.layout.getAllNodes().stream().allMatch(FSDevNode::isFinished)) {
                RestConnectionManager.releaseConn((DevNode)this.clusterDevNode);
                SingletonToken.getInstance().setToken("");
            }
        }
        catch (Exception e) {
            LOGGER.error("Release conn for {} error.", (Object)this.clusterDevNode.getIp());
        }
    }

    private void postUpgradePrepareHandle() {
        this.refreshUpgradeBtn();
        this.refreshRetryAndRollbackBtn();
        if (this.layout.getAllNodes().stream().allMatch(FSDevNode::isFinished)) {
            RestConnectionManager.releaseConn((DevNode)this.clusterDevNode);
            SingletonToken.getInstance().setToken("");
        }
    }

    private void executeUpgrade(String batchId, List<List<FSDevNode>> batchList) {
        try {
            batchList.forEach(batchNodes -> this.batchUpgrade((List<FSDevNode>)batchNodes, batchId));
        }
        finally {
            FsUpgradeService.setEndTime();
            this.postUpgradeHandle();
        }
    }

    private void recoverNodesUpgrade(List<FSDevNode> fsDevNodes) {
        String batchId = UpgradeContext.getInstance().getBatchId();
        LOGGER.info("ComputeNode recoverNodesUpgrade batchId: {}", (Object)batchId);
        List<FSDevNode> notStartedNodes = fsDevNodes.stream().filter(fsDevNode -> !fsDevNode.isStartedUpgrade()).collect(Collectors.toList());
        this.batchPrepareAndStartUpgrade(notStartedNodes, batchId);
        this.waitNodesFinish(fsDevNodes, batchId);
    }

    private void waitNodesFinish(List<FSDevNode> fsDevNodes, String batchId) {
        List<FSDevNode> loopNodes = Collections.synchronizedList(new ArrayList<FSDevNode>(fsDevNodes));
        try {
            CompletableFuture.supplyAsync(() -> {
                while (!this.isAllNodesFinished(loopNodes)) {
                    CommonUtils.safeSleep(30000);
                    long start = System.currentTimeMillis();
                    this.batchGetStatus(loopNodes, batchId);
                    LOGGER.info("Query node status cost {}", (Object)(System.currentTimeMillis() - start));
                }
                return true;
            }).get(maxUpgradeTime, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Query upgrade status timeout,update running node status to timeout.");
            this.batchRefreshLoopNodesStatus(loopNodes, Constants.NodeUpgradeState.TIMEOUT);
        }
        catch (Exception e) {
            LOGGER.warn("Execute task ocean unknown err", (Throwable)e);
            this.batchRefreshLoopNodesStatus(loopNodes, Constants.NodeUpgradeState.FAILED);
        }
    }

    private List<List<FSDevNode>> getBatchList(List<FSDevNode> fsDevNodes) {
        ArrayList<List<FSDevNode>> batchList = new ArrayList<List<FSDevNode>>();
        ArrayList<FSDevNode> vbsNodes = new ArrayList<FSDevNode>();
        ArrayList<FSDevNode> pureComputeNodes = new ArrayList<FSDevNode>();
        for (FSDevNode fsDevNode : fsDevNodes) {
            if (fsDevNode.isVbsNode()) {
                vbsNodes.add(fsDevNode);
                continue;
            }
            pureComputeNodes.add(fsDevNode);
        }
        int i = 0;
        int total = pureComputeNodes.size();
        if (total > 0) {
            List batchNodes;
            while ((i + 1) * this.parallelSize <= total) {
                batchNodes = pureComputeNodes.subList(i * this.parallelSize, (i + 1) * this.parallelSize);
                batchList.add(batchNodes);
                ++i;
            }
            if (total - i * this.parallelSize > 0) {
                batchNodes = pureComputeNodes.subList(i * this.parallelSize, total);
                batchList.add(batchNodes);
            }
        }
        batchList.add(vbsNodes);
        return batchList;
    }

    private void createLocalUpgradeBatchIdFile(List<FSDevNode> nodes) {
        try {
            HashMap<String, String> nodeStatusMap = new HashMap<String, String>();
            for (FSDevNode fsDevNode : nodes) {
                nodeStatusMap.put(fsDevNode.getManagementIP(), Constants.NodeUpgradeState.NOT_START.getDesc());
            }
            FsUpgradeService.createLocalUpgradeBatchIdFile(nodeStatusMap);
        }
        catch (ToolException e) {
            LOGGER.error("createLocalUpgradeBatchIdFile error: ", (Throwable)e);
        }
    }

    private void batchUpgrade(List<FSDevNode> batchNodes, String batchId) {
        LOGGER.info("Batch execute Upgrade...");
        List<FSDevNode> nodeNeedUpgrade = this.getNeedUpgradeNodeInRetry(batchNodes, batchId);
        this.init();
        if (!this.vbsMasterCanExecuteUpgrade(nodeNeedUpgrade)) {
            LOGGER.info(" Exist failed node, abort to update vbs node.");
            nodeNeedUpgrade.forEach(node -> this.updateNodeStatus((FSDevNode)((Object)node), Constants.NodeUpgradeState.UPGRADE_CHECK_FAILED));
            return;
        }
        this.batchPrepareAndStartUpgrade(nodeNeedUpgrade, batchId);
        this.waitNodesFinish(nodeNeedUpgrade, batchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<FSDevNode> getNeedUpgradeNodeInRetry(List<FSDevNode> batchNodes, String batchId) {
        List<Object> nodeJustQueryStatus = new ArrayList();
        try {
            nodeJustQueryStatus = batchNodes.stream().filter(node -> node.isRetryQueryNodeStatus()).collect(Collectors.toList());
            if (!CollectionUtil.isEmpty(nodeJustQueryStatus)) {
                this.waitNodesFinish(nodeJustQueryStatus, batchId);
                LOGGER.info("get node need upgrade from retry upgede fsNodes");
                List<FSDevNode> list = batchNodes.stream().filter(node -> node.isUpgradePrepare()).collect(Collectors.toList());
                return list;
            }
        }
        finally {
            if (!CollectionUtil.isEmpty(nodeJustQueryStatus)) {
                LOGGER.info("recover need retry upgede fsNodes status fasle");
                nodeJustQueryStatus.forEach(node -> node.setRetryQueryNodeStatus(false));
            }
        }
        LOGGER.info("all node need retry upgede");
        return batchNodes;
    }

    private void refreshRetryAndRollbackBtn() {
        this.layout.coverRetryBtn();
        this.layout.coverRollbackBtn();
    }

    private void refreshUpgradeBtn() {
        this.layout.coverUpgradeBth();
        this.layout.coverOfflineUpgradeBth();
    }

    private boolean vbsMasterCanExecuteUpgrade(List<FSDevNode> batchNodes) {
        if (batchNodes.stream().noneMatch(FSDevNode::isVbsNode)) {
            return true;
        }
        return this.layout.getAllNodesExceptVbsMaster().stream().allMatch(node -> node.getUpgradeStatus().isSuccessStatus());
    }

    private boolean isAllNodesFinished(List<FSDevNode> batchNodes) {
        return batchNodes.stream().noneMatch(fsNode -> fsNode.getUpgradeStatus().isExecuteStatus() || fsNode.isRetryQueryNodeStatus());
    }

    private void batchPrepareAndStartUpgrade(List<FSDevNode> batchNodes, String batchId) {
        ArrayList resultList = new ArrayList(batchNodes.size());
        this.getToken();
        batchNodes.forEach(node -> resultList.add(CompletableFuture.runAsync(() -> this.startUpgradeAndReleaseConn((FSDevNode)((Object)node), batchId), executorUpgrade)));
        CompletableFuture.allOf(resultList.toArray(new CompletableFuture[0])).join();
        resultList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startUpgradeAndReleaseConn(FSDevNode fsnode, String batchId) {
        boolean result;
        try {
            result = this.prepareAndStartUpgrade(fsnode, batchId);
        }
        finally {
            if (FsUpgradeService.isReleaseConn()) {
                CommonUtils.closeConnection(fsnode);
            }
        }
        return result;
    }

    private boolean prepareAndStartUpgrade(FSDevNode fsnode, String batchId) {
        if (!this.upgradeCheckToken(fsnode)) {
            return false;
        }
        return this.startUpgrade(fsnode, SingletonToken.getInstance().getToken(), batchId);
    }

    public void upgradePrepare(UpgradeComputeNodeDialog dialog) {
        List<FSDevNode> allNodes = this.layout.getAllNodes();
        this.createLocalUpgradeBatchIdFile(allNodes);
        this.layout.allButtonDimmed();
        this.layout.updateDeviceTableRow(allNodes, Constants.NodeUpgradeState.NOT_START);
        this.executeUpgradePrepare(UpgradeContext.getInstance().getBatchId(), this.getBatchList(allNodes));
        dialog.setUpgradeEnableSpecialScene(oldVersions);
    }

    public void executeUpgradePrepare(String batchId, List<List<FSDevNode>> batchList) {
        try {
            batchList.forEach(batchNodes -> {
                this.init();
                this.batchUpLoadScriptAndPullPkg((List<FSDevNode>)batchNodes, batchId);
                this.waitNodesFinish((List<FSDevNode>)batchNodes, batchId);
            });
        }
        finally {
            FsUpgradeService.setEndTime();
            this.postUpgradePrepareHandle();
        }
    }

    private void batchUpLoadScriptAndPullPkg(List<FSDevNode> batchNodes, String batchId) {
        LOGGER.info("Batch execute Preparation before upgrade...");
        this.getToken();
        CompletableFuture.allOf((CompletableFuture[])batchNodes.stream().map(fsNode -> CompletableFuture.runAsync(() -> this.startWorkReleaseConn((FSDevNode)((Object)fsNode), batchId), executorUpgrade)).toArray(CompletableFuture[]::new)).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startWorkReleaseConn(FSDevNode fsNode, String batchId) {
        try {
            oldVersions.add(FsUpgradeService.queryUpgradeCurrentVersion(fsNode));
            if (!this.checkToken(fsNode)) {
                LOGGER.error("Check token error in upgradePrepare");
                boolean bl = false;
                return bl;
            }
            if (!this.uploadUpgradeScript(fsNode, batchId)) {
                LOGGER.error("upload script error in upgradePrepare");
                boolean bl = false;
                return bl;
            }
            boolean bl = this.pullPkg(fsNode, batchId);
            return bl;
        }
        finally {
            if (FsUpgradeService.isReleaseConn()) {
                CommonUtils.closeConnection(fsNode);
            }
        }
    }

    private boolean pullPkg(FSDevNode fsNode, String batchId) {
        if (!FsUpgradeService.isSupportPullPkgVersion()) {
            LOGGER.info("ComputeNode {} not support pull upgrade pkg", (Object)fsNode.getManagementIP());
            this.updateNodeStatus(fsNode, Constants.NodeUpgradeState.PULL_UPGRADE_PKG_SUCCESS);
            return true;
        }
        if (this.needJumpStep(fsNode, batchId)) {
            LOGGER.info("ComputeNode {} not need pull upgrade pkg, skip", (Object)fsNode.getManagementIP());
            if (fsNode.getUpgradeStatus() != Constants.NodeUpgradeState.UPGRADING) {
                this.updateNodeStatus(fsNode, Constants.NodeUpgradeState.UPGRADING);
            }
            return true;
        }
        LOGGER.info("ComputeNode {} start pull pkg", (Object)fsNode.getManagementIP());
        String token = SingletonToken.getInstance().getToken();
        if (!FsUpgradeService.pullDpcUpgrade(fsNode, token)) {
            this.updateNodeStatus(fsNode, Constants.NodeUpgradeState.PULL_UPGRADE_PKG_FAILED);
            return false;
        }
        this.updateNodeStatus(fsNode, Constants.NodeUpgradeState.PULL_UPGRADE_PKG);
        return true;
    }

    public void rollbackAll() {
        String batchId = UpgradeContext.getInstance().getBatchId();
        List<FSDevNode> allNodesWithoutVbs = CommonUtils.getNodeCanRollback(this.layout.getAllNodes(), true);
        List<FSDevNode> vbsNodes = CommonUtils.getNodeCanRollback(this.layout.getAllNodes(), false);
        if (!vbsNodes.isEmpty() && !allNodesWithoutVbs.isEmpty()) {
            this.layout.updateDeviceTableRow(vbsNodes, Constants.NodeUpgradeState.NO_NEED_ROLLBACK);
            FsUpgradeService.batchUpdateLocalUpgradeBatchIdFile(batchId, vbsNodes, Constants.NodeUpgradeState.NO_NEED_ROLLBACK.getDesc());
        } else {
            allNodesWithoutVbs.addAll(vbsNodes);
        }
        this.layout.getRollbackCom().setVisible(true);
        this.layout.updateDeviceTableRow(allNodesWithoutVbs, Constants.NodeUpgradeState.ROLLBACK_CHECK);
        FsUpgradeService.batchUpdateLocalUpgradeBatchIdFile(batchId, allNodesWithoutVbs, Constants.NodeUpgradeState.ROLLBACK_CHECK.getDesc());
        this.executeRollback(batchId, this.getBatchList(allNodesWithoutVbs));
    }

    public boolean isRecoverRollback() {
        List<FSDevNode> allFsNode = this.layout.getAllNodes();
        return allFsNode.stream().anyMatch(FSDevNode::isRollbackStatus);
    }

    public boolean isUpgradePrepare() {
        List<FSDevNode> allFsNode = this.layout.getAllNodes();
        return allFsNode.stream().anyMatch(fsDevNode -> fsDevNode.getUpgradeStatus().isUpgradePrepareStatus());
    }

    public void recoverParallelRollback() {
        String batchId = UpgradeContext.getInstance().getBatchId();
        LOGGER.info("ComputeNode recover Parallel RollBack batchId: {}", (Object)batchId);
        List<FSDevNode> allFsNode = this.layout.getAllNodes();
        LOGGER.info("ComputeNode recover Parallel RollBack allNodes count: {}", (Object)allFsNode.size());
        ArrayList<FSDevNode> notStartedNodes = new ArrayList<FSDevNode>();
        ArrayList<FSDevNode> recoverNodes = new ArrayList<FSDevNode>();
        for (FSDevNode fsDevNode : allFsNode) {
            if (Constants.NodeUpgradeState.ROLLBACK_CHECK.equals((Object)fsDevNode.getUpgradeStatus())) {
                LOGGER.info("ComputeNode recoverParallelUpgrade not start node: {}", (Object)fsDevNode.getManagementIP());
                notStartedNodes.add(fsDevNode);
            }
            if (!fsDevNode.isRollbackStatus()) continue;
            LOGGER.info("ComputeNode recover Parallel Rollback node: {}", (Object)fsDevNode.getManagementIP());
            recoverNodes.add(fsDevNode);
        }
        this.recoverNodesRollback(recoverNodes);
        this.layout.getRollbackCom().setVisible(true);
        this.layout.updateDeviceTableRow(notStartedNodes, Constants.NodeUpgradeState.ROLLBACK_CHECK);
        this.executeRollback(batchId, this.getBatchList(notStartedNodes));
    }

    public void recoverParallelUpgradePrepare() {
        String batchId = UpgradeContext.getInstance().getBatchId();
        LOGGER.info("ComputeNode recover Parallel upgrade prepare batchId: {}", (Object)batchId);
        List<FSDevNode> allFsNode = this.layout.getAllNodes();
        LOGGER.info("ComputeNode recover Parallel upgrade prepare allNodes count: {}", (Object)allFsNode.size());
        ArrayList<FSDevNode> notStartedNodes = new ArrayList<FSDevNode>();
        ArrayList<FSDevNode> recoverNodes = new ArrayList<FSDevNode>();
        allFsNode.forEach(fsDevNode -> {
            if (fsDevNode.getUpgradeStatus() == Constants.NodeUpgradeState.NOT_START) {
                LOGGER.info("ComputeNode recover Parallel upgrade prepare not start node: {}", (Object)fsDevNode.getManagementIP());
                notStartedNodes.add((FSDevNode)((Object)fsDevNode));
            }
            if (fsDevNode.getUpgradeStatus().isPullPkgStatus()) {
                LOGGER.info("ComputeNode recover Parallel Rollback node: {}", (Object)fsDevNode.getManagementIP());
                recoverNodes.add((FSDevNode)((Object)fsDevNode));
            }
        });
        this.recoverPullPkg(recoverNodes);
        this.layout.updateDeviceTableRow(notStartedNodes, Constants.NodeUpgradeState.NOT_START);
        this.executeUpgradePrepare(batchId, this.getBatchList(notStartedNodes));
    }

    private void recoverPullPkg(List<FSDevNode> nodes) {
        String batchId = UpgradeContext.getInstance().getBatchId();
        LOGGER.info("ComputeNode recover Nodes pull pkg batchId: {}", (Object)batchId);
        List<FSDevNode> notStartedNodes = nodes.stream().filter(fsDevNode -> Constants.NodeUpgradeState.PULL_UPGRADE_PKG.equals((Object)fsDevNode.getUpgradeStatus())).collect(Collectors.toList());
        this.waitNodesFinish(notStartedNodes, batchId);
    }

    private void recoverNodesRollback(List<FSDevNode> nodes) {
        String batchId = UpgradeContext.getInstance().getBatchId();
        LOGGER.info("ComputeNode recover Nodes Upgrade batchId: {}", (Object)batchId);
        List<FSDevNode> notStartedNodes = nodes.stream().filter(fsDevNode -> fsDevNode.getUpgradeStatus().equals((Object)Constants.NodeUpgradeState.ROLLBACKING)).collect(Collectors.toList());
        this.waitNodeRollBackFinish(notStartedNodes, batchId);
    }

    private void executeRollback(String batchId, List<List<FSDevNode>> batchList) {
        try {
            batchList.forEach(batchNodes -> this.batchRollback((List<FSDevNode>)batchNodes, batchId));
            this.postRollbackHandle();
        }
        finally {
            FsUpgradeService.setEndTime();
            this.releaseRestConn();
        }
    }

    private void postRollbackHandle() {
        this.layout.getRetryAllBtn().setEnabled(this.layout.getAllNodes().stream().anyMatch(FSDevNode::isFailed));
    }

    private void batchRollback(List<FSDevNode> batchNodes, String batchId) {
        this.init();
        LOGGER.info("Batch execute roll back...");
        List<FSDevNode> filteredBatchNodes = batchNodes;
        if (batchNodes.stream().anyMatch(FSDevNode::isVbsNode) && !this.layout.getAllNodesExceptVbsMaster().stream().allMatch(devNode -> devNode.getUpgradeStatus().isSuccessUpgradeOrRollback())) {
            FSDevNode vbsNode = (FSDevNode)((Object)batchNodes.stream().filter(FSDevNode::isVbsNode).collect(Collectors.toList()).get(0));
            this.updateNodeStatus(vbsNode, Constants.NodeUpgradeState.ROLLBACK_CHECK_FAILED);
            LOGGER.info("Exist failed node, abort to update vbs node {} .", (Object)vbsNode.getManagementIP());
            filteredBatchNodes = batchNodes.stream().filter(devNode -> !devNode.isVbsNode()).collect(Collectors.toList());
        }
        this.layout.updateDeviceTableRow(filteredBatchNodes, Constants.NodeUpgradeState.ROLLBACK_CHECK);
        ArrayList resultList = new ArrayList(filteredBatchNodes.size());
        this.getToken();
        filteredBatchNodes.forEach(node -> resultList.add(CompletableFuture.runAsync(() -> this.startRollback((FSDevNode)((Object)node), batchId))));
        CompletableFuture.allOf(resultList.toArray(new CompletableFuture[0])).join();
        this.waitNodeRollBackFinish(filteredBatchNodes, batchId);
    }

    private boolean startRollback(FSDevNode node, String batchId) {
        if (node.isVbsNode() && !this.layout.getAllNodesExceptVbsMaster().stream().allMatch(devNode -> devNode.getUpgradeStatus().isSuccessUpgradeOrRollback())) {
            this.updateNodeStatus(node, Constants.NodeUpgradeState.ROLLBACK_CHECK_FAILED);
            LOGGER.info("Exist failed node, abort to update vbs node {} .", (Object)node.getManagementIP());
            return false;
        }
        if (!this.rollbackCheckToken(node)) {
            return false;
        }
        if (this.needJumpRollback(node, batchId)) {
            LOGGER.info("ComputeNode {} not need roll back, skip", (Object)node.getManagementIP());
            return true;
        }
        LOGGER.info("ComputeNode {} start roll back", (Object)node.getManagementIP());
        this.updateNodeStatus(node, Constants.NodeUpgradeState.ROLLBACKING);
        return FsUpgradeService.startRollbackForNode(node, batchId, SingletonToken.getInstance().getToken());
    }

    private boolean needJumpRollback(FSDevNode fsNode, String batchId) {
        Constants.NodeUpgradeState status = FsUpgradeService.getRollbackFinishOfNode(fsNode, batchId, 0);
        return Constants.NodeUpgradeState.ROLLBACKING.equals((Object)status) && this.queryIsRollbackRunning(fsNode);
    }

    private void waitNodeRollBackFinish(List<FSDevNode> fsDevNodes, String batchId) {
        List<FSDevNode> loopNodes = Collections.synchronizedList(new ArrayList<FSDevNode>(fsDevNodes));
        try {
            CompletableFuture.supplyAsync(() -> {
                while (loopNodes.stream().map(FSDevNode::getUpgradeStatus).anyMatch(status -> status.equals((Object)Constants.NodeUpgradeState.ROLLBACKING))) {
                    CommonUtils.safeSleep(30000);
                    long startTime = System.currentTimeMillis();
                    this.batchGetRollbackStatus(loopNodes, batchId);
                    LOGGER.info("Rollback query node status cost {}", (Object)(System.currentTimeMillis() - startTime));
                }
                return true;
            }).get(maxRollbackTime, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Query rollback status timeout,update running node status to timeout.");
            this.batchRefreshLoopNodesStatus(loopNodes, Constants.NodeUpgradeState.TIMEOUT);
        }
        catch (Exception e) {
            LOGGER.warn("Execute task ocean unknown err", (Throwable)e);
            this.batchRefreshLoopNodesStatus(loopNodes, Constants.NodeUpgradeState.ROLLBACK_FAILED);
        }
    }

    private void batchGetRollbackStatus(List<FSDevNode> batchNodes, String batchId) {
        List<CompletableFuture> results = batchNodes.stream().filter(node -> !node.isSingleRetryRunning()).filter(node -> !node.isFinished()).map(node -> CompletableFuture.runAsync(() -> this.getRollbackStatusOnce((FSDevNode)((Object)node), batchId))).collect(Collectors.toList());
        CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).join();
    }

    private Constants.NodeUpgradeState getRollbackStatusOnce(FSDevNode node, String batchId) {
        CommonUtils.switchToRootIfNeed(node);
        Constants.NodeUpgradeState status = FsUpgradeService.getRollbackFinishOfNode(node, batchId, 5);
        if (!Constants.NodeUpgradeState.TIMEOUT.equals((Object)node.getUpgradeStatus())) {
            this.updateNodeStatus(node, status);
        }
        this.releaseSsh(node);
        return status;
    }

    public void retryNode() {
        if (this.layout.isBatchExecute()) {
            LOGGER.info("batch executing retry, return and wait");
            DialogUtils.showInfoDialog((JDialog)UpgradeContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"upgrade.compute.batch.execute.warning"));
            return;
        }
        try {
            LOGGER.info("ComputeNode retryNode ...");
            boolean isRollback = this.node.isRollbackStatus();
            this.node.setSingleRetryRunning(true);
            boolean isPrepareFailed = this.node.getUpgradeStatus().isUpgradePrepareFailedStatus();
            this.layout.resetFailedNum(this.countFailed());
            this.layout.coverRetryBtn();
            this.layout.coverRollbackBtn();
            if (isPrepareFailed) {
                executorSingleRetry.execute(() -> this.executeNodeRetryUpgradePrepare(this.node));
            } else if (isRollback) {
                executorSingleRetry.execute(() -> this.executeNodeRollback(this.node));
            } else {
                executorSingleRetry.execute(() -> this.executeNodeUpgrade(this.node));
            }
        }
        finally {
            this.node.setSingleRetryRunning(false);
        }
    }

    private void batchGetStatus(List<FSDevNode> batchNodes, String batchId) {
        CompletableFuture.allOf((CompletableFuture[])batchNodes.stream().filter(node -> !node.isSingleRetryRunning()).filter(node -> !node.isFinished()).map(node -> CompletableFuture.runAsync(() -> this.getUpgradeStatusOnece((FSDevNode)((Object)node), batchId), executorUpgrade)).toArray(CompletableFuture[]::new)).join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retryAll() {
        LOGGER.info("ComputeNode Batch Retry ...");
        try {
            this.layout.setBatchExecute(true);
            List<FSDevNode> allNodes = this.layout.getAllNodes();
            List failedNodes = allNodes.stream().filter(FSDevNode::isFailed).collect(Collectors.toList());
            if (failedNodes.isEmpty()) {
                LOGGER.info("ComputeNode no failed node.");
                return;
            }
            this.layout.resetFailedNum(this.countFailed());
            String batchId = UpgradeContext.getInstance().getBatchId();
            this.layout.resetFailedNum(0);
            this.executeRetryUpgradePrepare(batchId, this.getNodeNeedToRetryUpgradePrepare());
            this.executeRetryRollback(batchId, this.getNodeNeedToRollBack());
            this.executeRetryUpgrade(batchId, this.getNodeToRetryUpgrade());
        }
        finally {
            this.layout.setBatchExecute(false);
        }
    }

    private void executeRetryUpgrade(String batchId, List<FSDevNode> nodeToRetryUpgrade) {
        if (!CollectionUtil.isEmpty(nodeToRetryUpgrade)) {
            nodeToRetryUpgrade.forEach(node -> node.setNeedQueryStatus((FSDevNode)((Object)node)));
            this.layout.updateDeviceTableRow(nodeToRetryUpgrade, Constants.NodeUpgradeState.UPGRADE_CHECK);
            FsUpgradeService.batchUpdateLocalUpgradeBatchIdFile(batchId, nodeToRetryUpgrade, Constants.NodeUpgradeState.UPGRADE_CHECK.getDesc());
            this.executeUpgrade(batchId, this.getBatchList(nodeToRetryUpgrade));
        }
    }

    private void executeRetryRollback(String batchId, List<FSDevNode> needRollBackNode) {
        if (!CollectionUtil.isEmpty(needRollBackNode)) {
            this.layout.updateDeviceTableRow(needRollBackNode, Constants.NodeUpgradeState.ROLLBACK_CHECK);
            FsUpgradeService.batchUpdateLocalUpgradeBatchIdFile(batchId, needRollBackNode, Constants.NodeUpgradeState.ROLLBACK_CHECK.getDesc());
            this.executeRollback(batchId, this.getBatchList(needRollBackNode));
        }
    }

    private void executeRetryUpgradePrepare(String batchId, List<FSDevNode> nodeNeeRetryUpgradePrepare) {
        if (!CollectionUtil.isEmpty(nodeNeeRetryUpgradePrepare)) {
            this.layout.updateDeviceTableRow(nodeNeeRetryUpgradePrepare, Constants.NodeUpgradeState.NOT_START);
            FsUpgradeService.batchUpdateLocalUpgradeBatchIdFile(batchId, nodeNeeRetryUpgradePrepare, Constants.NodeUpgradeState.NOT_START.getDesc());
            this.executeUpgradePrepare(batchId, this.getBatchList(nodeNeeRetryUpgradePrepare));
        }
    }

    private List<FSDevNode> getNodeNeedToRetryUpgradePrepare() {
        return this.layout.getAllNodes().stream().filter(fsDevNode -> fsDevNode.getUpgradeStatus().isUpgradePrepareFailedStatus()).collect(Collectors.toList());
    }

    private List<FSDevNode> getNodeNeedToRollBack() {
        return this.layout.getAllNodes().stream().filter(FSDevNode::isRollbackFailed).collect(Collectors.toList());
    }

    private List<FSDevNode> getNodeToRetryUpgrade() {
        return this.layout.getAllNodes().stream().filter(fsDevNode -> fsDevNode.getUpgradeStatus().isUpgradeFailed()).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeNodeUpgrade(FSDevNode node) {
        node.setNeedQueryStatus(node);
        this.updateNodeStatus(node, Constants.NodeUpgradeState.UPGRADE_CHECK);
        LOGGER.info("ComputeNode executeNodeUpgrade: {}", (Object)node.getManagementIP());
        String batchId = UpgradeContext.getInstance().getBatchId();
        try {
            this.getToken();
            if (!this.isNeedNodeRetry(node, batchId)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.upgradeCheckToken(node) && this.startUpgrade(node, SingletonToken.getInstance().getToken(), batchId) && this.getUpgradeStatusLoop(node, batchId);
            return bl;
        }
        finally {
            FsUpgradeService.getComputeNodeUpgradeResult().setEndTime(new Date());
            this.refreshRetryAndRollbackBtn();
            this.releaseSsh(node);
            this.releaseRestConn();
        }
    }

    private boolean isNeedNodeRetry(FSDevNode node, String batchId) {
        if (!node.isRetryQueryNodeStatus()) {
            return true;
        }
        this.getUpgradeStatusLoop(node, batchId);
        if (node.getUpgradeStatus().isSuccessStatus()) {
            node.setRetryQueryNodeStatus(false);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeNodeRollback(FSDevNode node) {
        node.setUpgradeStatus(Constants.NodeUpgradeState.ROLLBACK_CHECK);
        this.layout.updateDeviceTableRow(node);
        LOGGER.info("ComputeNode rollback Node rollback: {}", (Object)node.getManagementIP());
        String batchId = UpgradeContext.getInstance().getBatchId();
        try {
            this.getToken();
            boolean bl = this.rollbackCheckToken(node) && this.startRollback(node, batchId) && this.getRollbackStatusLoop(node, batchId);
            return bl;
        }
        finally {
            FsUpgradeService.getComputeNodeUpgradeResult().setEndTime(new Date());
            this.postRollbackHandle();
            this.releaseSsh(node);
            this.releaseRestConn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeNodeRetryUpgradePrepare(FSDevNode node) {
        LOGGER.info("ComputeNode executeNodeUpgrade again: {}", (Object)node.getManagementIP());
        String batchId = UpgradeContext.getInstance().getBatchId();
        try {
            this.getToken();
            boolean bl = this.checkToken(node) && this.uploadUpgradeScript(node, batchId) && this.pullPkg(node, batchId) && this.getPullStatusLoop(node, batchId);
            return bl;
        }
        finally {
            FsUpgradeService.getComputeNodeUpgradeResult().setEndTime(new Date());
            this.postUpgradePrepareHandle();
            this.releaseSsh(node);
            this.releaseRestConn();
        }
    }

    private boolean getPullStatusLoop(FSDevNode node, String batchId) {
        LOGGER.info("ComputeNode get node pull pkg satus loop ...");
        try {
            return CompletableFuture.supplyAsync(() -> {
                while (!node.getUpgradeStatus().isPullPkgFinishStatus()) {
                    CommonUtils.safeSleep(5000);
                    this.getUpgradeStatusOnece(node, batchId);
                }
                return true;
            }).get(maxUpgradeTime, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Current node {} query upgrade status timeout , max upgrade time {} .", (Object)node.getManagementIP(), (Object)maxUpgradeTime);
            this.postHandleRetryGetStatus(node, Constants.NodeUpgradeState.TIMEOUT);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Current node {} get pull pkg status ocean unknown error.", (Object)node.getManagementIP(), (Object)e);
            this.postHandleRetryGetStatus(node, Constants.NodeUpgradeState.PULL_UPGRADE_PKG_FAILED);
            return false;
        }
    }

    private void postHandleRetryGetStatus(FSDevNode node, Constants.NodeUpgradeState timeout) {
        this.updateNodeStatus(node, timeout);
        node.setSingleRetryRunning(false);
    }

    private boolean getRollbackStatusLoop(FSDevNode node, String batchId) {
        LOGGER.info("ComputeNode get Rollback Status Loop ...");
        try {
            return CompletableFuture.supplyAsync(() -> {
                Constants.NodeUpgradeState status;
                do {
                    CommonUtils.safeSleep(5000);
                    status = this.getRollbackStatusOnce(node, batchId);
                    if (Constants.NodeUpgradeState.ROLLBACK_SUCCEEDED.getCode() != status.getCode()) continue;
                    node.setSingleRetryRunning(false);
                    return true;
                } while (Constants.NodeUpgradeState.ROLLBACK_FAILED.getCode() != status.getCode());
                node.setSingleRetryRunning(false);
                return false;
            }).get(maxRollbackTime, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Current node {} query rollback status timeout , max upgrade time {} .", (Object)node.getManagementIP(), (Object)maxRollbackTime);
            this.updateNodeStatus(node, Constants.NodeUpgradeState.TIMEOUT);
            node.setSingleRetryRunning(false);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Current node {} upgrade ocean unknown error.", (Object)node.getManagementIP(), (Object)e);
            this.updateNodeStatus(node, Constants.NodeUpgradeState.ROLLBACK_FAILED);
            node.setSingleRetryRunning(false);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRestConn() {
        if (this.layout.getAllNodes().stream().allMatch(FSDevNode::isFinished)) {
            Object object = lock;
            synchronized (object) {
                try {
                    LOGGER.info("Release rest connection in single retry.");
                    RestConnectionManager.releaseConn((DevNode)this.clusterDevNode);
                }
                catch (Exception e) {
                    LOGGER.error("Release rest conn error.", (Throwable)e);
                }
                SingletonToken.getInstance().setToken("");
            }
        }
    }

    public void updateNodeStatus(FSDevNode node, Constants.NodeUpgradeState status) {
        LOGGER.info("node {} status:{};target status:{} ", new Object[]{node.getManagementIP(), node.getUpgradeStatus(), status});
        String batchId = UpgradeContext.getInstance().getBatchId();
        FsUpgradeService.updateLocalUpgradeBatchIdFile(batchId, node, status.getDesc());
        node.setUpgradeStatus(status);
        if (status.equals((Object)Constants.NodeUpgradeState.FAILED) && StringUtils.isNULLStr((String)node.getErrorDescription())) {
            node.setErrorDescription(ResourceUtil.getString((String)"upgrade.compute.node.dpc.upgrade.error.msg"));
        }
        this.layout.updateDeviceTableRow(node);
        if (node.isFinished() || node.getUpgradeStatus().isSuccessUpgradeOrRollback()) {
            this.resetNum();
            FsUpgradeService.clearNode(node);
            this.layout.refreshSingleNodeVersion(node);
            LOGGER.info("node {} upgrade finished. result : {} ", (Object)node.getManagementIP(), (Object)node.getUpgradeStatus());
        }
        this.releaseSsh(node);
    }

    private void resetNum() {
        SwingUtilities.invokeLater(() -> {
            this.layout.resetFailedNum(this.countFailed());
            this.layout.resetSuccessNum(this.countSuccess());
            this.layout.resetRollbackFailedNum(this.countRollBackFailed());
            this.layout.resetRollbackSuccessNum(this.countRollBackSuccess());
            this.layout.resetPullPkgFailedNum(this.countPullPkgFailed());
            this.layout.resetPullPkgSuccessNum(CommonUtils.countPullPkgSuccess(this.layout.getAllNodes()));
        });
    }

    private int countSuccess() {
        return (int)this.layout.getAllNodes().stream().filter(fsDevNode -> fsDevNode.getUpgradeStatus().isSuccessStatus()).count();
    }

    private int countFailed() {
        return (int)this.layout.getAllNodes().stream().filter(fsDevNode -> fsDevNode.isRollbackStatus() || fsDevNode.getUpgradeStatus().isUpgradeFailed()).count();
    }

    private int countPullPkgFailed() {
        return (int)this.layout.getAllNodes().stream().filter(fsDevNode -> fsDevNode.getUpgradeStatus().isUpgradePrepareFailedStatus()).count();
    }

    private int countRollBackSuccess() {
        return (int)this.layout.getAllNodes().stream().filter(FSDevNode::isRollbackSucceeded).count();
    }

    private int countRollBackFailed() {
        return (int)this.layout.getAllNodes().stream().filter(fsDevNode -> fsDevNode.getUpgradeStatus().isRollbackFailed()).count();
    }

    private boolean needJumpStep(FSDevNode fsNode, String batchId) {
        String status = FsUpgradeService.getUpgradeStatusOfNode(fsNode, batchId);
        return Constants.NodeUpgradeState.UPGRADING.getDesc().equals(status) && CommonUtils.queryIsUpgrading(fsNode);
    }

    private boolean queryIsRollbackRunning(FSDevNode fsNode) {
        String cmd = "ps -ef|grep compute_rollback|grep -v grep";
        try {
            List<String> ret = CommonUtils.executeFsDevNodeCmd(fsNode, cmd, true);
            return !ret.isEmpty() && ret.stream().anyMatch(retLine -> retLine.contains("compute_rollback.sh") || retLine.contains("compute_rollback_inner.sh"));
        }
        catch (ToolException e) {
            LOGGER.error("Query rollback progress failed.", (Throwable)e);
            return false;
        }
    }

    private void releaseSsh(FSDevNode node) {
        if (!node.isFinished()) {
            return;
        }
        DevNode devNode = CommonUtils.transFsDevNode2DevNode(node);
        SshConnectionManager.releaseConnection((DevNode)devNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void getToken() {
        LOGGER.info("ComputeNode getToken ...");
        Object object = lock;
        synchronized (object) {
            if (SingletonToken.getInstance().checkAuthentication()) {
                return;
            }
            SingletonToken.getInstance().setToken(FsUpgradeService.queryNodeVersionAndGetToken());
        }
    }

    private synchronized boolean checkToken(FSDevNode node) {
        if (StringUtils.isNULLStr((String)SingletonToken.getInstance().getToken())) {
            LOGGER.warn("ComputeNode token is null");
            this.updateNodeStatus(node, Constants.NodeUpgradeState.PREPARE_FAILED);
            return false;
        }
        LOGGER.info("ComputeNode token is not null");
        this.updateNodeStatus(node, Constants.NodeUpgradeState.PREPARED);
        return true;
    }

    private synchronized boolean upgradeCheckToken(FSDevNode node) {
        if (StringUtils.isNULLStr((String)SingletonToken.getInstance().getToken())) {
            LOGGER.warn("ComputeNode token is null");
            this.updateNodeStatus(node, Constants.NodeUpgradeState.UPGRADE_CHECK_FAILED);
            return false;
        }
        LOGGER.info("ComputeNode token is not null");
        this.updateNodeStatus(node, Constants.NodeUpgradeState.UPGRADE_CHECK_SUCCESS);
        return true;
    }

    private synchronized boolean rollbackCheckToken(FSDevNode node) {
        if (StringUtils.isNULLStr((String)SingletonToken.getInstance().getToken())) {
            LOGGER.warn("ComputeNode token is null");
            this.updateNodeStatus(node, Constants.NodeUpgradeState.ROLLBACK_CHECK_FAILED);
            return false;
        }
        LOGGER.info("ComputeNode token is not null");
        this.updateNodeStatus(node, Constants.NodeUpgradeState.ROLLBACK_CHECK_SUCCESS);
        return true;
    }

    private boolean uploadUpgradeScript(FSDevNode fsDevNode, String batchId) {
        LOGGER.info("ComputeNode {} uploadUpgradeScript", (Object)fsDevNode.getManagementIP());
        if (this.needJumpStep(fsDevNode, batchId)) {
            return true;
        }
        if (FsUpgradeService.uploadUpgradeScriptToNode(fsDevNode)) {
            this.updateNodeStatus(fsDevNode, Constants.NodeUpgradeState.SCRIPT_UPLOADED);
            return true;
        }
        this.updateNodeStatus(fsDevNode, Constants.NodeUpgradeState.SCRIPT_UPLOAD_FAILED);
        return false;
    }

    private boolean startUpgrade(FSDevNode fsNode, String token, String batchId) {
        if (this.needJumpStep(fsNode, batchId)) {
            LOGGER.info("ComputeNode {} not need upgrade, skip", (Object)fsNode.getManagementIP());
            if (Constants.NodeUpgradeState.UPGRADING != fsNode.getUpgradeStatus()) {
                this.updateNodeStatus(fsNode, Constants.NodeUpgradeState.UPGRADING);
            }
            return true;
        }
        LOGGER.info("ComputeNode {} start Upgrade", (Object)fsNode.getManagementIP());
        if (FsUpgradeService.startUpgradeForNode(fsNode, token, batchId, this.autoAnswer)) {
            this.updateNodeStatus(fsNode, Constants.NodeUpgradeState.STARTED);
            return true;
        }
        this.updateNodeStatus(fsNode, Constants.NodeUpgradeState.START_FAILED);
        return false;
    }

    private boolean getUpgradeStatusLoop(FSDevNode node, String batchId) {
        LOGGER.info("ComputeNode {} getUpgradeStatusLoop ...", (Object)node.getManagementIP());
        try {
            return CompletableFuture.supplyAsync(() -> {
                Constants.NodeUpgradeState status;
                do {
                    CommonUtils.safeSleep(5000);
                    status = this.getUpgradeStatusOnece(node, batchId);
                    if (Constants.NodeUpgradeState.SUCCEEDED.getCode() == status.getCode()) {
                        node.setSingleRetryRunning(false);
                        return true;
                    }
                    if (Constants.NodeUpgradeState.FAILED.getCode() != status.getCode()) continue;
                    node.setSingleRetryRunning(false);
                    return false;
                } while (Constants.NodeUpgradeState.UPGRADE_CHECK.getCode() != status.getCode());
                node.setSingleRetryRunning(false);
                return false;
            }).get(maxUpgradeTime, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Current node {} query upgrade status timeout , max upgrade time {} .", (Object)node.getManagementIP(), (Object)maxUpgradeTime);
            this.updateNodeStatus(node, Constants.NodeUpgradeState.TIMEOUT);
            node.setSingleRetryRunning(false);
            return false;
        }
        catch (Exception e) {
            LOGGER.warn("Current node {} upgrade ocean unknown error.", (Object)node.getManagementIP(), (Object)e);
            this.updateNodeStatus(node, Constants.NodeUpgradeState.FAILED);
            node.setSingleRetryRunning(false);
            return false;
        }
    }

    private Constants.NodeUpgradeState getUpgradeStatusOnece(FSDevNode node, String batchId) {
        CommonUtils.switchToRootIfNeed(node);
        String status = FsUpgradeService.getUpgradeStatusOfNode(node, batchId, 6);
        Constants.NodeUpgradeState state = Constants.NodeUpgradeState.getStateByDesc(status);
        if (!Constants.NodeUpgradeState.TIMEOUT.equals((Object)node.getUpgradeStatus())) {
            if (node.isUpgradePrepare() && node.isRetryQueryNodeStatus() && state.isRetryStatus()) {
                node.setRetryQueryNodeStatus(false);
                state = Constants.NodeUpgradeState.UPGRADE_CHECK;
            }
            if (node.getUpgradeStatus().isUpgradePrepareStatus() && state.isUpgradeFailed()) {
                state = Constants.NodeUpgradeState.PULL_UPGRADE_PKG_FAILED;
            }
            this.updateNodeStatus(node, state);
        }
        this.releaseSshForLargeParallelSize(node);
        return state;
    }

    private void releaseSshForLargeParallelSize(FSDevNode fsDevNode) {
        if (FsUpgradeService.isReleaseConn() || fsDevNode.isFinished()) {
            CommonUtils.closeConnection(fsDevNode);
        }
    }

    public void changeAutoAnswer2Yes() {
        this.autoAnswer = AUTO_ANSWER_YES;
    }

    private void batchRefreshLoopNodesStatus(List<FSDevNode> loopNodes, Constants.NodeUpgradeState state) {
        loopNodes.stream().filter(FSDevNode::isRunning).forEach(node -> this.updateNodeStatus((FSDevNode)((Object)node), state));
    }

    public static void setUpdateType(UpdateType updateType) {
        FsUpgradeFlowService.updateType = updateType;
    }

    public static UpdateType getUpdateType() {
        return updateType;
    }

    public UpgradeComputeNodeLayout getLayout() {
        return this.layout;
    }

    public void setUpgradeTaskStartTime(Date upgradeTaskStartTime) {
        this.upgradeTaskStartTime = upgradeTaskStartTime;
    }

    public Date getUpgradeTaskStartTime() {
        return this.upgradeTaskStartTime;
    }

    public void setUpgradeTaskEndTime(Date upgradeTaskEndTime) {
        this.upgradeTaskEndTime = upgradeTaskEndTime;
    }

    public Date getUpgradeTaskEndTime() {
        return this.upgradeTaskEndTime;
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler((thread, e) -> LOGGER.error("Un caught exception thread name : {}", (Object)thread.getName(), (Object)e));
        try {
            maxUpgradeTime = Integer.parseInt(ApplicationContext.getInstance().getAppConfig("compute.node.upgrade.maxTime"));
            maxRollbackTime = Integer.parseInt(ApplicationContext.getInstance().getAppConfig("compute.node.rollback.maxTime"));
        }
        catch (Exception e2) {
            LOGGER.warn("Init upgrade conf error, use default value");
        }
        LOGGER.info("Current max upgrade time {} min, max rollback time {} min.", (Object)maxUpgradeTime, (Object)maxRollbackTime);
    }
}

