/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.service;

import com.huawei.bundleupgrade.entity.ComputeNodeUpgradeResult;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.SHAAndRSAVerifyUtils;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.distributedfwupg.entity.ComputeNodeTypeEnum;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.entity.UpdateType;
import com.huawei.ism.tool.distributedfwupg.entity.UpgradeScriptConfig;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeFlowService;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeScriptConfigUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.common.DevInfoUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FsUpgradeService {
    private static ComputeNodeUpgradeResult computeNodeUpgradeResult = new ComputeNodeUpgradeResult();
    private static final Logger LOGGER = LoggerFactory.getLogger(FsUpgradeService.class);
    private static final String EQUALS = "=";
    private static final String PATTERN_PRODUCT_VERSION = "(?<=product_version =).*";
    private static final String PATTERN_PATCH_VERSION = "(?<=patch_version =).*";
    private static final String HOTPATCH_VERSION = "(?<=hotpatch_version =).*";
    private static FSClusterDevice UPGRADE_DEVICE = null;
    private static boolean releaseConn = false;
    private static ConcurrentHashMap<String, String> nodeStatusMap = new ConcurrentHashMap();
    private static boolean isInitDateFromJson = false;

    public static FSClusterDevice getCurUpgradeFsDev(boolean needUpdate) {
        if (UPGRADE_DEVICE == null || needUpdate) {
            JDialog dialog = UpgradeContext.getInstance().getDialog();
            AsyncExcutor.execute((Window)dialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> {
                List<FSClusterDevice> fsDevices = CommonUtils.transJson2FSCluster();
                if (fsDevices != null && !fsDevices.isEmpty()) {
                    UPGRADE_DEVICE = fsDevices.stream().filter(FSClusterDevice::isSelected).findFirst().orElse(fsDevices.get(0));
                    FsUpgradeService.updateProductInfo(UPGRADE_DEVICE);
                }
                return true;
            }});
        }
        return UPGRADE_DEVICE;
    }

    static void updateProductInfo(FSClusterDevice fsClusterDevice) {
        DevNode devNode = fsClusterDevice.createDevNodeByClusterDevice();
        try {
            RestConnection restConn = RestConnectionManager.getDstorageLoginRestConnection((DevNode)devNode);
            new DSstorageInfoQryServiceImpl().queryClusterProductInfo(devNode, restConn);
            fsClusterDevice.setProductVersion(devNode.getProductVersion());
            fsClusterDevice.setHotPatchVersion(devNode.getHotPatchVersion());
            fsClusterDevice.setDistributedHotPatchVersion(devNode.getProductVersionToShow());
        }
        catch (Exception e) {
            LOGGER.error("update cluster productInfo fail.");
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    public static synchronized boolean writeNodeStatusToFile(Map<String, String> nodeStatusMap, String batchId) {
        File batchIdFile = new File(Constants.FS_UPGRADE_BATCH_FILE_PATH + File.separator + batchId);
        if (!batchIdFile.exists()) {
            try {
                batchIdFile.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("write batch file failed.", (Throwable)e);
                return false;
            }
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(batchIdFile), StandardCharsets.UTF_8));){
            for (Map.Entry<String, String> nodeStatus : nodeStatusMap.entrySet()) {
                writer.write(String.format(Locale.ENGLISH, "%s%s%s\r\n", nodeStatus.getKey(), Constants.LOCAL_SEPARATOR, nodeStatus.getValue()));
            }
            writer.write(String.format(Locale.ENGLISH, "%s%s%s\r\n", Constants.UPDATE_TYPE, Constants.LOCAL_SEPARATOR, FsUpgradeFlowService.getUpdateType().toString()));
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error("create file " + batchIdFile.getName(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static String getLocalUpgradeBatchIdFile() {
        String floatIp2FileName = FsUpgradeService.getCurUpgradeFsDev(true).getFloatIp2FileName();
        File filePath = new File(Constants.FS_UPGRADE_BATCH_FILE_PATH);
        File[] upgradeBatchFiles = filePath.listFiles();
        if (upgradeBatchFiles == null) {
            return null;
        }
        for (File file : upgradeBatchFiles) {
            if (!file.isFile() || !file.getName().contains(floatIp2FileName)) continue;
            return file.getName();
        }
        return null;
    }

    public static ConcurrentHashMap<String, String> parseLocalUpgradeBatchIdFile(String fileName) throws IOException {
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        File batchIdFile = new File(Constants.FS_UPGRADE_BATCH_FILE_PATH + File.separator + fileName);
        if (batchIdFile.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(batchIdFile);
                 InputStreamReader reader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(reader);){
                String lineTxt;
                while ((lineTxt = bufferedReader.readLine()) != null) {
                    List<String> record = Arrays.asList(lineTxt.split(Constants.LOCAL_SEPARATOR));
                    if (record.size() == 2) {
                        result.put(record.get(0), record.get(1));
                        continue;
                    }
                    LOGGER.warn("invalid line: " + lineTxt);
                }
            }
        }
        return result;
    }

    public static String createLocalUpgradeBatchIdFile(Map<String, String> selectedNodeStatus) throws ToolException {
        String floatIp = FsUpgradeService.getCurUpgradeFsDev(false).getFloatIp();
        if (FsUpgradeService.getLocalUpgradeBatchIdFile() != null) {
            throw new ToolException(String.format(Locale.ENGLISH, "float ip:%s's file already exist", floatIp), false);
        }
        String batchId = UpgradeContext.getInstance().getBatchId();
        boolean writeSuccess = FsUpgradeService.writeNodeStatusToFile(selectedNodeStatus, batchId);
        if (!writeSuccess) {
            throw new ToolException("write file failed");
        }
        return batchId;
    }

    public static boolean updateLocalUpgradeBatchIdFile(String batchId, FSDevNode node, String status) {
        if (status.equals(nodeStatusMap.get(node.getManagementIP()))) {
            return true;
        }
        nodeStatusMap.put(node.getManagementIP(), status);
        return true;
    }

    public static synchronized boolean batchUpdateLocalUpgradeBatchIdFile(String batchId, List<FSDevNode> nodes, String status) {
        if (nodes.stream().allMatch(node -> status.equals(nodeStatusMap.get(node.getManagementIP())))) {
            return true;
        }
        nodes.forEach(node -> nodeStatusMap.put(node.getManagementIP(), status));
        return true;
    }

    private static void updateVbsNode(List<String> vbsIpList) {
        for (FSDevNode devNode : FsUpgradeService.getCurUpgradeFsDev(false).getFsDevNodeList()) {
            if (!vbsIpList.contains(devNode.getManagementIP()) && !vbsIpList.contains(devNode.getStorageFrontIp())) continue;
            LOGGER.info("Node {} is vbs node.", (Object)devNode.getManagementIP());
            devNode.setVbsNode(true);
        }
    }

    public static List<FSDevNode> getNodeForComputeOnly(List<String> vbsIpList) {
        FsUpgradeService.updateVbsNode(vbsIpList);
        LinkedList<FSDevNode> computeNodes = new LinkedList<FSDevNode>();
        FsUpgradeService.getCurUpgradeFsDev(false).getFsDevNodeList().stream().filter(node -> node.isPureComputeNode() && node.isSelected() && !node.isVbsNode()).forEach(computeNodes::add);
        computeNodes.sort((nodeOne, nodeTwo) -> {
            boolean containOne = vbsIpList.contains(nodeOne.getManagementIP());
            boolean containTwo = vbsIpList.contains(nodeTwo.getManagementIP());
            if (containOne && !containTwo) {
                return -1;
            }
            if (!containOne && containTwo) {
                return 1;
            }
            return nodeOne.getManagementIP().compareTo(nodeTwo.getManagementIP());
        });
        FsUpgradeService.getCurUpgradeFsDev(false).getFsDevNodeList().stream().filter(node -> node.isSelected() && node.isVbsNode()).forEach(computeNodes::add);
        return computeNodes;
    }

    public static boolean uploadUpgradeScriptToNode(FSDevNode node) {
        DevNode devNode = CommonUtils.transFsDevNode2DevNode(node);
        SftpConnector sftp = new SftpConnector(devNode);
        try {
            LOGGER.info("Start to upload the upgrade package to the Node: {}", (Object)node.getIp());
            UpgradeScriptConfig upgradeScriptConfig = UpgradeScriptConfigUtils.getUpgradeScriptConfig();
            String fileFullPath = upgradeScriptConfig.getScriptPath();
            if (!FsUpgradeService.verifySignatureZip(fileFullPath)) {
                LOGGER.error("verify upload zip failed");
                return false;
            }
            FsUpgradeService.removeOldActionPkg(node, fileFullPath);
            sftp.putFile(fileFullPath, Constants.SERVER_TMP_PATH, null);
            node.setUploadSuccess();
            String packageFilePath = Constants.SERVER_TMP_PATH + "/" + upgradeScriptConfig.getScriptName();
            String scriptPath = node.getScriptPath();
            String unzipPackageCmd = String.format(Locale.ENGLISH, "unzip -qo %s -d %s", packageFilePath, scriptPath);
            CommonUtils.executeFsDevNodeCmd(node, unzipPackageCmd, false);
            String chmodCmd = "chmod 500 -R " + scriptPath;
            CommonUtils.executeFsDevNodeCmd(node, chmodCmd, true);
            String dosCmd = String.format(Locale.ENGLISH, "dos2unix %s/*", scriptPath);
            try {
                CommonUtils.executeFsDevNodeCmd(node, dosCmd, false);
            }
            catch (Exception e) {
                LOGGER.error("execute upgrade cmd fail", (Throwable)e);
                return false;
            }
            LOGGER.info("Uploads and decompresses upgrade packages on Node: {}.", (Object)devNode.getIp());
        }
        catch (Exception e) {
            LOGGER.error("upload script file fail.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static void removeOldActionPkg(FSDevNode fsDevNode, String fileFullPath) throws ToolException {
        try {
            String fileName = new File(fileFullPath).getName();
            String removeCmd = String.format("rm -rf %s/%s", Constants.SERVER_TMP_PATH, fileName);
            CommonUtils.executeCmdWithLogAndGetRecord(fsDevNode, removeCmd, false);
            LOGGER.info("Delete the residual upgrade File: {} on Node: {}.", (Object)fileName, (Object)fsDevNode.getIp());
        }
        catch (ToolException e) {
            LOGGER.warn("Failed to delete the remote {} pkg.", (Object)new File(fileFullPath).getName());
        }
    }

    public static boolean startUpgradeForNode(FSDevNode node, String token, String batchId, String autoAnswer) {
        String scriptFile = node.getScriptPath() + "/" + Constants.UPGRADE_SCRIPT_FILE_NAME;
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        String ip = clusterDev.getFloatIp();
        if (!StringUtils.isNULLStr((String)clusterDev.getInnerFloatIp())) {
            ip = clusterDev.getInnerFloatIp();
        }
        try {
            UpgradeScriptConfig upgradeScriptConfig = UpgradeScriptConfigUtils.getUpgradeScriptConfig();
            if ("Direct".equals(upgradeScriptConfig.getScriptExecType())) {
                String cmd = String.format(Locale.ENGLISH, "bash %s %s %s", scriptFile, batchId, ip);
                CommonUtils.executeCmdWithLogAndGetRecord(node, cmd, false);
                CommonUtils.executeCmdWithLogAndGetRecord(node, token, false);
                LOGGER.info("Run Script: {} on Node: {}", (Object)Constants.UPGRADE_SCRIPT_FILE_NAME, (Object)node.getIp());
                return true;
            }
            String cmd = String.format(Locale.ENGLISH, "bash %s", scriptFile);
            CommonUtils.executeCmdWithLogAndGetRecord(node, cmd, false);
            LOGGER.info("Run Script: {} on Node: {}", (Object)Constants.UPGRADE_SCRIPT_FILE_NAME, (Object)node.getIp());
            String record = FsUpgradeService.doUpgrade(node, token, batchId, ip);
            if (FsUpgradeService.breakUpgrade(node, autoAnswer, record)) {
                LOGGER.info("Stop upgrade.");
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("execute upgrade cmd fail", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean pullDpcUpgrade(FSDevNode node, String token) {
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        if (Objects.isNull(clusterDev)) {
            return false;
        }
        String floatIp = StringUtils.isNULLStr((String)clusterDev.getInnerFloatIp()) ? clusterDev.getFloatIp() : clusterDev.getInnerFloatIp();
        try {
            String pullCmd = String.join((CharSequence)"/", node.getScriptPath(), "compute_download.sh");
            CommonUtils.executeCmdWithLogAndGetRecord(node, pullCmd, false);
            String arg = String.format(Locale.ENGLISH, " %s %s ", floatIp, token);
            CommonUtils.executeCmdWithLogAndGetRecord(node, arg, false);
            LOGGER.info("Run pull pkg Script: {} on Node: {}", (Object)"compute_download.sh", (Object)node.getIp());
        }
        catch (ToolException e) {
            LOGGER.error("Execute pull pkg cmd fail", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean isSupportPullPkgVersion() {
        String currentVersion = FsUpgradeService.getCurUpgradeFsDev(false).getProductVersion();
        String[] notSupportVersion = ApplicationContext.getInstance().getAppConfig("compute.node.not.support.pull.pkg.version").split(",");
        return Arrays.stream(notSupportVersion).noneMatch(currentVersion::contains);
    }

    private static String doUpgrade(FSDevNode node, String token, String batchId, String ip) throws ToolException {
        String arg = String.format(Locale.ENGLISH, " %s %s %s ", token, batchId, ip);
        UpdateType type = FsUpgradeFlowService.getUpdateType();
        if (UpdateType.isDpcUpgrade(type)) {
            arg = String.format(Locale.ENGLISH, " %s %s %s %s", token, batchId, ip, type.getTypeValue());
        }
        return CommonUtils.executeCmdWithLogAndGetRecord(node, arg, false);
    }

    private static boolean breakUpgrade(FSDevNode node, String autoAnswer, String record) throws ToolException {
        if (!record.contains("To continue the online upgrade, enter (yes/y). To stop the upgrade, enter (no/n):")) {
            return false;
        }
        if (record.contains("The current CPU usage is higher than")) {
            return FsUpgradeService.autoAnswerUpgrade(node, autoAnswer, Constants.AutoAnswerUpgrade.CPU_HIGHER);
        }
        if (record.contains("The remaining system memory percentage is less than ")) {
            return FsUpgradeService.autoAnswerUpgrade(node, autoAnswer, Constants.AutoAnswerUpgrade.MEMORY_HIGHER);
        }
        return false;
    }

    private static boolean autoAnswerUpgrade(FSDevNode node, String autoAnswer, Constants.AutoAnswerUpgrade autoAnswerUpgrade) throws ToolException {
        if (autoAnswer.equals("no")) {
            node.setErrorDescription(autoAnswerUpgrade.getWarning());
            node.setErrorSuggestion(autoAnswerUpgrade.getSuggestion());
            CommonUtils.executeFsDevNodeCmd(node, autoAnswer, true);
            return true;
        }
        CommonUtils.executeFsDevNodeCmd(node, autoAnswer, true);
        return false;
    }

    public static String getUpgradeStatusOfNode(FSDevNode node, String batchId) {
        return FsUpgradeService.getUpgradeStatusOfNode(node, batchId, 0);
    }

    public static String getUpgradeStatusOfNode(FSDevNode node, String batchId, int retryTimes) {
        String cmd = "head -5 " + node.getDpcNodeDeployPrefix() + "/opt/fusionstorage/deploymanager/compute_upgrade/compute_upgrade.ini";
        String statusResult = "";
        String processResult = "";
        List<Object> cmdResponse = new ArrayList();
        boolean isUpgrading = false;
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                isUpgrading = CommonUtils.queryIsUpgrading(node);
                cmdResponse = CommonUtils.executeFsDevNodeCmd(node, cmd, false);
                statusResult = (String)cmdResponse.get(3);
                processResult = (String)cmdResponse.get(4);
                if (!statusResult.contains("status=") || !processResult.contains("progress=")) {
                    LOGGER.error("Server node {} file format error", (Object)node.getManagementIP());
                    return Constants.NodeUpgradeState.FAILED.getDesc();
                }
                LOGGER.info("Query node {} status {},batchID {}.", new Object[]{node.getManagementIP(), statusResult.trim(), batchId});
                break;
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.error("Query node {} status index out of bounds, ret : {}", (Object)node.getManagementIP(), cmdResponse);
                if (i < retryTimes) {
                    CommonUtils.safeSleep(10000);
                    continue;
                }
                return Constants.NodeUpgradeState.FAILED.getDesc();
            }
            catch (Exception e) {
                LOGGER.error("Server node {} query status error", (Object)node.getManagementIP(), (Object)e);
                return Constants.NodeUpgradeState.FAILED.getDesc();
            }
        }
        return FsUpgradeService.getUpgradeStateDesc(node, statusResult, processResult, isUpgrading);
    }

    private static String getUpgradeStateDesc(FSDevNode node, String statusResult, String processResult, boolean isUpgrading) {
        int processValue = Integer.parseInt(processResult.split(EQUALS)[1].trim());
        String statusValue = statusResult.split(EQUALS)[1].trim();
        LOGGER.info("current node:{} upgrade status:{}, process:{}", new Object[]{node.getManagementIP(), statusValue, processValue});
        switch (statusValue) {
            case "initial": 
            case "running": {
                if (isUpgrading) {
                    LOGGER.info("current node:{} upgrade progress exist.", (Object)node.getManagementIP());
                    return Constants.NodeUpgradeState.UPGRADING.getDesc();
                }
                LOGGER.info("current node:{} upgrade progress not exist.", (Object)node.getManagementIP());
                return Constants.NodeUpgradeState.FAILED.getDesc();
            }
            case "success": {
                return Constants.NodeUpgradeState.SUCCEEDED.getDesc();
            }
            case "download_failed": {
                return Constants.NodeUpgradeState.PULL_UPGRADE_PKG_FAILED.getDesc();
            }
            case "download_running": {
                if (!FsUpgradeService.queryIsDownloading(node)) {
                    LOGGER.info("current node:{} download progress is not exist.", (Object)node.getManagementIP());
                    return Constants.NodeUpgradeState.PULL_UPGRADE_PKG_FAILED.getDesc();
                }
                return Constants.NodeUpgradeState.PULL_UPGRADE_PKG.getDesc();
            }
            case "download_success": {
                return Constants.NodeUpgradeState.PULL_UPGRADE_PKG_SUCCESS.getDesc();
            }
            case "failed": {
                return Constants.NodeUpgradeState.FAILED.getDesc();
            }
        }
        return Constants.NodeUpgradeState.FAILED.getDesc();
    }

    public static String getFailedDesc(FSDevNode node) {
        if (node.isDpcComputeNode()) {
            FsUpgradeService.refreshDpcVersions(Collections.singletonList(node));
            return node.isConsistent() ? Constants.NodeUpgradeState.SUCCEEDED.getDesc() : Constants.NodeUpgradeState.FAILED.getDesc();
        }
        return Constants.NodeUpgradeState.FAILED.getDesc();
    }

    public static boolean queryIsDownloading(FSDevNode fsNode) {
        String cmd = "ps -ef|grep compute_download|grep -v grep";
        try {
            List<String> ret = CommonUtils.executeFsDevNodeCmdWithTimeOut(fsNode, cmd, true, 30);
            return ret.stream().anyMatch(retLine -> retLine.contains("compute_download.sh") || retLine.contains("compute_download_inner.sh"));
        }
        catch (ToolException e) {
            LOGGER.error("Query download progress failed.", (Throwable)e);
            return false;
        }
    }

    public static boolean clearNode(List<FSDevNode> nodeList) {
        ExecutorService batchExecutor = Executors.newFixedThreadPool(10);
        nodeList.forEach(node -> batchExecutor.execute(() -> {
            try {
                String cmd = String.format(Locale.ENGLISH, "rm -f /tmp/%s && rm -rf %s", UpgradeScriptConfigUtils.getUpgradeScriptConfig().getScriptName(), node.getScriptPath());
                CommonUtils.executeFsDevNodeCmd(node, cmd, false);
                LOGGER.info("Clearing Environment After the Upgrade, on Node: {}", (Object)node.getIp());
            }
            catch (Exception e) {
                LOGGER.error("clear env fail", (Throwable)e);
            }
        }));
        batchExecutor.shutdown();
        try {
            batchExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            LOGGER.error("clear env fail", (Throwable)e);
        }
        return true;
    }

    public static void clearNode(FSDevNode node) {
        if (!node.getUpgradeStatus().isSuccessUpgradeOrRollback()) {
            return;
        }
        String cmd = String.format(Locale.ENGLISH, "rm -f /tmp/%s && rm -rf %s", UpgradeScriptConfigUtils.getUpgradeScriptConfig().getScriptName(), node.getScriptPath());
        try {
            CommonUtils.executeFsDevNodeCmd(node, cmd, false);
            LOGGER.info("Clearing Environment on Node: {} ", (Object)node.getIp());
        }
        catch (Exception e) {
            LOGGER.error("clear env fail", (Throwable)e);
        }
    }

    public static void clearNodeAndLocal(List<FSDevNode> nodeList) {
        FsUpgradeService.clearNode(nodeList);
        UpgradeContext.getInstance().setBatchId("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getVbsMasterNodeIp() {
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        HashSet vbsIpSet = new HashSet();
        List selectNodes = clusterDev.getFsDevNodeList().stream().filter(FSDevNode::isSelected).collect(Collectors.toList());
        if (selectNodes.stream().allMatch(FSDevNode::isPureDpcComputeNode)) {
            return Collections.emptyList();
        }
        for (FSDevNode fsDevNode : selectNodes) {
            if (!fsDevNode.isComputeNode()) continue;
            String cmd = "bash /opt/dsware/vbs/script/vbs/vbs_cmd.sh 8 109";
            try {
                CommonUtils.executeFsDevNodeCmd(fsDevNode, cmd, false).forEach(line -> vbsIpSet.addAll(CommonUtils.getIpFromText(line)));
                LOGGER.info("Obtain the VBS information on Node: {}", (Object)fsDevNode.getIp());
                if (vbsIpSet.isEmpty()) continue;
                ArrayList<String> arrayList = new ArrayList<String>(vbsIpSet);
                return arrayList;
            }
            catch (Exception e) {
                LOGGER.error("query vbs node fail", (Throwable)e);
            }
            finally {
                SshConnectionManager.releaseConnection((DevNode)CommonUtils.transFsDevNode2DevNode(fsDevNode));
            }
        }
        return Collections.emptyList();
    }

    public static String queryNodeVersionAndGetToken() {
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        DevNode devNode = CommonUtils.transFsClusterDev2DevNode(clusterDev);
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            String port = ApplicationContext.getInstance().getAppConfig("compute.node.upgrade.config.port");
            conn.checkAndReLogin(RestUtil.getDsUpgradeNodeVersionUri((DevNode)devNode, (String)port));
            return conn.getSession() == null ? "" : conn.getSession().getToken();
        }
        catch (Exception e) {
            LOGGER.error("query error:{}", (Object)e.getMessage());
            return null;
        }
    }

    public static String getUpgradeTargetVersion() {
        return DevInfoUtil.buildCompleteProductVersion((String)UPGRADE_DEVICE.getProductVersion(), (String)UPGRADE_DEVICE.getHotPatchVersion());
    }

    public static String getTargetVersion() {
        return DevInfoUtil.buildCompleteProductVersion((String)UPGRADE_DEVICE.getProductVersion(), (String)UPGRADE_DEVICE.getDistributedHotPatchVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryUpgradeCurrentVersion(FSDevNode node) {
        String cmd = "cat " + node.getDpcNodeDeployPrefix() + "/opt/dfv/oam/public/conf/product.ini";
        try {
            List<String> result = CommonUtils.executeFsDevNodeCmd(node, cmd, true);
            if (result == null || result.isEmpty()) {
                String string = "";
                return string;
            }
            String productVersion = FsUpgradeService.getVersionByPattern(result, PATTERN_PRODUCT_VERSION);
            String patchVersion = FsUpgradeService.getVersionByPattern(result, PATTERN_PATCH_VERSION);
            if (!node.isDpcComputeNode()) {
                String hotPatchVersion = FsUpgradeService.getVersionByPattern(result, HOTPATCH_VERSION);
                patchVersion = StringUtils.isNULLStr((String)hotPatchVersion) ? patchVersion : hotPatchVersion;
            }
            String string = DevInfoUtil.buildCompleteProductVersion((String)productVersion, (String)patchVersion);
            return string;
        }
        catch (ToolException e) {
            LOGGER.error("query upgrade current version failed.");
            String string = "";
            return string;
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)CommonUtils.transFsDevNode2DevNode(node));
        }
    }

    public static List<String> getComputeNodeCurrentVersion(List<FSDevNode> nodes) {
        return nodes.stream().map(FsUpgradeService::queryUpgradeCurrentVersion).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String queryDpcCurrentVersion(FSDevNode node) {
        String cmd = "ls " + node.getDeployPrefix() + "/opt/fusionstorage/repository/deploymanager_pkg/micro/";
        try {
            List<String> result = CommonUtils.executeFsDevNodeCmd(node, cmd, true);
            if (CollectionUtil.isEmpty(result)) {
                String string = "";
                return string;
            }
            String string = result.stream().map(line -> line.split("[ \t\r]")).flatMap(Arrays::stream).filter(micro -> micro.startsWith("dpc_")).findFirst().map(micro -> micro.replaceFirst("dpc_", "")).orElse("");
            return string;
        }
        catch (ToolException e) {
            LOGGER.error("query dpc upgrade current version failed.");
            String string = "";
            return string;
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)CommonUtils.transFsDevNode2DevNode(node));
        }
    }

    public static void refreshDpcVersions(List<FSDevNode> devNodes) {
        JSONArray nodesArray = FsUpgradeService.queryUpgradeVersionByUrl(devNodes);
        FsUpgradeService.setDpcVersion(devNodes, nodesArray);
    }

    private static void setDpcVersion(List<FSDevNode> devNodes, JSONArray nodesArray) {
        devNodes.stream().forEach(devNode -> devNode.setQueryDpcSuccess(nodesArray.length() > 0));
        for (int i = 0; i < nodesArray.length(); ++i) {
            JSONObject nodeObject = nodesArray.getJSONObject(i);
            String ip = nodeObject.getStringOrDefault("ip", "");
            devNodes.stream().filter(devNode -> devNode.getManagementIP().equals(ip)).findFirst().ifPresent(devNode -> FsUpgradeService.setDpcVersions(nodeObject, devNode));
        }
    }

    public static void updateDpcVersion(List<FSDevNode> fsDevNodes, DevNode devNode) {
        List<String> ipList = fsDevNodes.stream().map(FSDevNode::getManagementIP).collect(Collectors.toList());
        FsUpgradeService.setDpcVersion(fsDevNodes, FsUpgradeService.queryDpcVerison(devNode, ipList));
    }

    private static void setDpcVersions(JSONObject nodeObject, FSDevNode devNode) {
        String currentVersion = nodeObject.getStringOrDefault("currentVersion", "");
        String targetVersion = nodeObject.getStringOrDefault("targetVersion", "");
        boolean isConsistent = nodeObject.getBoolean("consistent");
        devNode.setCurrentVersion(currentVersion);
        devNode.setOldVersion(currentVersion);
        devNode.setTargetVersion(targetVersion);
        devNode.setConsistent(isConsistent);
    }

    public static JSONArray queryUpgradeVersionByUrl(List<FSDevNode> nodeList) {
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        DevNode devNode = clusterDev.createDevNodeByClusterDevice();
        List<String> ipList = nodeList.stream().map(FSDevNode::getManagementIP).collect(Collectors.toList());
        return FsUpgradeService.queryDpcVerison(devNode, ipList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONArray queryDpcVerison(DevNode devNode, List<String> ipList) {
        try {
            RestConnection restConn = RestConnectionManager.getDstorageLoginRestConnection((DevNode)devNode);
            String url = RestUtil.getDstorageBaseUrl((DevNode)devNode) + "/deploy_manager/compute_components_detail";
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("ipList", ipList);
            ResponseInfo responseInfo = restConn.execPost(url, params);
            Map contentMap = responseInfo.getContentMap();
            Object errorCodeObj = contentMap.get("errorCode");
            Long errorCode = (Long)Long.class.cast(errorCodeObj);
            if (errorCode != 0L) {
                String errorDes = contentMap.get("description").toString();
                String suggest = contentMap.get("suggestion").toString();
                LOGGER.error("Query dpc compute components details failed, error code:{}, error description:{}, suggestion:{}", new Object[]{errorCode, errorDes, suggest});
                JSONArray jSONArray = new JSONArray();
                return jSONArray;
            }
            Object dataObj = contentMap.get("data");
            JSONArray jSONArray = (JSONArray)JSONArray.class.cast(dataObj);
            return jSONArray;
        }
        catch (com.huawei.ism.tool.obase.exception.ToolException e) {
            LOGGER.error("Query dpc compute components details failed", (Throwable)e);
        }
        finally {
            if (FsUpgradeService.isReleaseConn()) {
                RestConnectionManager.releaseConn((DevNode)devNode);
            }
        }
        return new JSONArray();
    }

    private static String getVersionByPattern(List<String> result, String pattern) {
        Pattern r = Pattern.compile(pattern);
        for (String str : result) {
            Matcher matcher = r.matcher(str);
            if (!matcher.find()) continue;
            return matcher.group(0).trim();
        }
        return "";
    }

    public static boolean startRollbackForNode(FSDevNode node, String batchId, String token) {
        LOGGER.info("execute roll back shell");
        String scriptFile = node.getScriptPath() + "/" + Constants.ROLLBACK_SCRIPT_FILE_NAME;
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        String ip = clusterDev.getFloatIp();
        if (!StringUtils.isNULLStr((String)clusterDev.getInnerFloatIp())) {
            ip = clusterDev.getInnerFloatIp();
        }
        try {
            UpgradeScriptConfig upgradeScriptConfig = UpgradeScriptConfigUtils.getUpgradeScriptConfig();
            if ("Direct".equals(upgradeScriptConfig.getScriptExecType())) {
                String cmd = String.format(Locale.ENGLISH, "nohup %s %s %s >/dev/null 2>&1 &", scriptFile, batchId, ip);
                CommonUtils.executeFsDevNodeCmd(node, cmd, false);
                LOGGER.info("nohup Run Script:{} on Node:{}", (Object)Constants.ROLLBACK_SCRIPT_FILE_NAME, (Object)node.getIp());
                return true;
            }
            String cmd = String.format(Locale.ENGLISH, "bash %s", scriptFile);
            String arg = String.format(Locale.ENGLISH, " %s %s %s ", token, batchId, ip);
            CommonUtils.executeFsDevNodeCmd(node, cmd, false);
            CommonUtils.executeFsDevNodeCmd(node, arg, false);
            LOGGER.info("Run Script:{} on Node:{}", (Object)Constants.ROLLBACK_SCRIPT_FILE_NAME, (Object)node.getIp());
        }
        catch (Exception e) {
            LOGGER.error("execute upgrade cmd fail", (Throwable)e);
            return false;
        }
        return true;
    }

    public static Constants.NodeUpgradeState getRollbackFinishOfNode(FSDevNode node, String batchId, int retryTimes) {
        String cmd = "head -5 " + node.getDpcNodeDeployPrefix() + "/opt/fusionstorage/deploymanager/compute_upgrade/compute_rollback.ini";
        String statusResult = "";
        String processResult = "";
        List<Object> cmdResponse = new ArrayList();
        for (int i = 0; i <= retryTimes; ++i) {
            try {
                cmdResponse = CommonUtils.executeFsDevNodeCmdWithTimeOut(node, cmd, false, 30);
                statusResult = (String)cmdResponse.get(3);
                processResult = (String)cmdResponse.get(4);
                if (!statusResult.contains("status=") || !processResult.contains("progress=")) {
                    LOGGER.error("Server node {} file format error", (Object)node.getManagementIP());
                    return Constants.NodeUpgradeState.ROLLBACK_FAILED;
                }
                LOGGER.info("Query node {} status {},batchID {}.", new Object[]{node.getManagementIP(), statusResult.trim(), batchId});
                break;
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.error("Query node {} status index out of bounds, ret : {}", (Object)node.getManagementIP(), cmdResponse);
                if (i < retryTimes) {
                    CommonUtils.safeSleep(10000);
                    continue;
                }
                return Constants.NodeUpgradeState.ROLLBACK_FAILED;
            }
            catch (Exception e) {
                LOGGER.error("Server node {} query status error", (Object)node.getManagementIP(), (Object)e);
                return Constants.NodeUpgradeState.ROLLBACK_FAILED;
            }
        }
        String statusValue = statusResult.split(EQUALS)[1].trim();
        int processValue = Integer.parseInt(processResult.split(EQUALS)[1].trim());
        LOGGER.info(String.format(Locale.ENGLISH, "current node:%s rollback status:%s, process:%s", node.getIp(), statusValue, processValue));
        switch (statusValue) {
            case "initial": 
            case "running": {
                return FsUpgradeService.getNodeUpgradeState(node);
            }
            case "success": {
                return Constants.NodeUpgradeState.ROLLBACK_SUCCEEDED;
            }
        }
        return Constants.NodeUpgradeState.ROLLBACK_FAILED;
    }

    @NotNull
    private static Constants.NodeUpgradeState getNodeUpgradeState(FSDevNode node) {
        if (!CommonUtils.queryIsRollbackRunning(node)) {
            LOGGER.error("The rollback process of the current node {} is abnormal.", (Object)node.getManagementIP());
            return Constants.NodeUpgradeState.ROLLBACK_FAILED;
        }
        return Constants.NodeUpgradeState.ROLLBACKING;
    }

    private static boolean verifySignatureZip(String fileFullPath) {
        try {
            return SHAAndRSAVerifyUtils.getInstance().verify(new File(fileFullPath));
        }
        catch (Exception exception) {
            LOGGER.error("verify signature file exception", (Throwable)exception);
            return false;
        }
    }

    public static void initUpgradeResult(List<FSDevNode> fsDevNodes, String upgradeMode) {
        computeNodeUpgradeResult.setFsDevNodes(fsDevNodes);
        computeNodeUpgradeResult.setUpgradeMode(upgradeMode);
        computeNodeUpgradeResult.setComputeNodeType(UpgradeContext.getInstance().isDpcUpgrade() ? ComputeNodeTypeEnum.COMPUTE_DPC.getComputeType() : ComputeNodeTypeEnum.COMPUTE_VBS.getComputeType());
    }

    public static void setEndTime() {
        if (FsUpgradeService.isInitDateFromJson()) {
            return;
        }
        FsUpgradeService.getComputeNodeUpgradeResult().setEndTime(new Date());
        FsUpgradeService.setInitDateFromJson(false);
    }

    public static ComputeNodeUpgradeResult getComputeNodeUpgradeResult() {
        return computeNodeUpgradeResult;
    }

    public static void setComputeNodeUpgradeResult(ComputeNodeUpgradeResult computeNodeUpgradeResult) {
        FsUpgradeService.computeNodeUpgradeResult = computeNodeUpgradeResult;
    }

    public static void setUPGRADE_DEVICE(FSClusterDevice UPGRADE_DEVICE) {
        FsUpgradeService.UPGRADE_DEVICE = UPGRADE_DEVICE;
    }

    public static void setReleaseConn(boolean releaseConn) {
        FsUpgradeService.releaseConn = releaseConn;
    }

    public static boolean isReleaseConn() {
        return releaseConn;
    }

    public static void setNodeStatusMap(ConcurrentHashMap<String, String> nodeStatusMap) {
        FsUpgradeService.nodeStatusMap = nodeStatusMap;
    }

    public static ConcurrentHashMap<String, String> getNodeStatusMap() {
        return nodeStatusMap;
    }

    public static void setInitDateFromJson(boolean isInitDateFromJson) {
        FsUpgradeService.isInitDateFromJson = isInitDateFromJson;
    }

    public static boolean isInitDateFromJson() {
        return isInitDateFromJson;
    }
}

