/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.service;

import com.huawei.bundleupgrade.utils.NodeServiceUtils;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.INodeChecker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ManualConfigItemMgr;
import java.io.File;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IscsiServiceReset
implements INodeChecker {
    private static final Logger log = LoggerFactory.getLogger(IscsiServiceReset.class);

    @Override
    public TaskResult check(DevNode node, List<FSDevNode> fsDevNodeList) {
        TaskResult result = new TaskResult();
        result.setResult(TaskResult.Result.SUCCESS);
        if (!ManualConfigItemMgr.getInstance().expected(NodeServiceUtils.getPermanentIgnoreCheck(node) + "IscsiServiceCheck", "yes")) {
            return result;
        }
        fsDevNodeList.stream().filter(fsNode -> !Objects.isNull(fsNode.getNodeServiceInfo())).filter(fsNode -> fsNode.getNodeServiceInfo().getServiceInfo().contains("iscsi")).forEach(fsNode -> {
            log.info("Remove Iscsi service for {} and reset service type.", (Object)fsNode.getManagementIP());
            fsNode.getNodeServiceInfo().getServiceInfo().remove("iscsi");
            fsNode.getNodeServiceInfo().resetNodeUpgradePriorityByNodeServiceInfo();
        });
        return result;
    }

    static {
        File ignoreFile = new File(ApplicationContext.getInstance().getWorkPath(), "ignoreConfig.txt");
        ManualConfigItemMgr.getInstance().init(ignoreFile);
    }
}

