/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.service;

import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.INodeChecker;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnSupportHdfsServerChecker
implements INodeChecker {
    private static final Logger log = LoggerFactory.getLogger(UnSupportHdfsServerChecker.class);

    private List<ArrayList<Object>> getHdfsNodes(List<FSDevNode> fsDevNodeList) {
        ArrayList<ArrayList<Object>> hdfsNodesIps = new ArrayList<ArrayList<Object>>();
        for (FSDevNode node : fsDevNodeList) {
            List<String> nodeServices = node.getServices();
            if (!nodeServices.contains("pool_HDFS")) continue;
            ArrayList<String> hdfsNodesIp = new ArrayList<String>();
            hdfsNodesIp.add(node.getManagementIP());
            hdfsNodesIp.add(node.getBmcIP());
            hdfsNodesIps.add(hdfsNodesIp);
        }
        return hdfsNodesIps;
    }

    @Override
    public TaskResult check(DevNode node, List<FSDevNode> fsDevNodeList) {
        TaskResult result = new TaskResult();
        List<ArrayList<Object>> hdfsNodes = this.getHdfsNodes(fsDevNodeList);
        if (hdfsNodes.isEmpty() || FSClusterDevice.isTwoOcean(node)) {
            result.setResult(TaskResult.Result.SUCCESS);
            return result;
        }
        log.info("Exist hdfs server node,unSupport upgrade.");
        String[] tableHeaders = new String[]{ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.manageip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.bmcip")};
        String hdfsMsg = ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice.hdfs");
        DialogUtils.showMultiErrorDialog((Window)UpgradeContext.getInstance().getMainDialog(), (String)hdfsMsg, (String[])tableHeaders, hdfsNodes);
        result.setResult(TaskResult.Result.FAILED);
        return result;
    }
}

