/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.card;

import com.huawei.bundleupgrade.entity.NodeServiceInfo;
import com.huawei.bundleupgrade.utils.NodeServiceUtils;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.distributedfwupg.action.QueryDeviceAction;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.EmptyNodeDetermination;
import com.huawei.ism.tool.distributedfwupg.service.INodeChecker;
import com.huawei.ism.tool.distributedfwupg.service.UnSupportHdfsServerChecker;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectDeviceCardLayout;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCard;
import com.huawei.ism.tool.distributedfwupg.utils.FSClusterDevManager;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import com.huawei.json.JSONUtils;
import java.awt.BorderLayout;
import java.awt.Window;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class SelectDeviceCard
extends ToolWizardDialog.Card {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SelectDeviceCard.class);
    private SelectDeviceCardLayout cardLayout = new SelectDeviceCardLayout();
    private static List<INodeChecker> checkers = new ArrayList<INodeChecker>();
    private static final boolean IS_COMPUTER_NODE_UPGRADE = UpgradeContext.getInstance().isComputeUpgradeScene();

    public SelectDeviceCard(ToolWizardDialog.Navigation ... navs) {
        super(null, navs);
        this.setLayout(new BorderLayout());
        this.add(this.cardLayout, "Center");
        this.initDefaultTableData();
        this.initListener();
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"dsfwupgrade.wizard.step1.title");
    }

    public int getStep() {
        return 0;
    }

    protected ToolWizardDialog.Card getNextCard() {
        List<FSDevNode> fsDevNodeList;
        JDialog parent = UpgradeContext.getInstance().getDialog();
        if (this.getSelectedDev().isEmpty()) {
            DialogUtils.showInfoDialog((JDialog)parent, (String)ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice"));
            return this;
        }
        DevNode selectedDev = this.getSelectedDev().get(0);
        if (UpgradeCustomizationUtil.isSupportBatchDpcUpgradeDevice(selectedDev, fsDevNodeList = SelectDeviceCard.queryFsDevNodeInfo(parent, selectedDev))) {
            LOGGER.info("Scale-Out Storage Batch Upgrade is recommended for the current device {}.", (Object)selectedDev.getIp());
            DialogUtils.showInfoDialog((JDialog)parent, (String)UpgradeCustomizationUtil.getDpcTipToShow(selectedDev));
            return this;
        }
        if (!SelectDeviceCard.checkNodeServer(selectedDev, fsDevNodeList)) {
            return this;
        }
        return new SelectNodeCard(this, this.createFSClusterDev(selectedDev, fsDevNodeList), ToolWizardDialog.Navigation.Previous, ToolWizardDialog.Navigation.Complete, ToolWizardDialog.Navigation.Cancel);
    }

    public static List<FSDevNode> queryFsDevNodeInfo(Window parent, DevNode selectedDev) {
        List fsList = AsyncExcutor.execute((Window)parent, (Callable[])new Callable[]{() -> SelectDeviceCard.queryFSDevNodes(selectedDev)});
        Object obj = fsList.get(0);
        if (!(obj instanceof List)) {
            LOGGER.info("Query result {} is not node list. ", obj);
            return Collections.emptyList();
        }
        return (List)obj;
    }

    public static boolean checkNodeServer(DevNode selectedDev, List<FSDevNode> fsDevNodeList) {
        if (checkers.stream().anyMatch(checker -> TaskResult.Result.FAILED == checker.check(selectedDev, fsDevNodeList).getResult())) {
            LOGGER.warn("Node check not pass.");
            return false;
        }
        return true;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    private void initListener() {
        this.cardLayout.getAddDeviceLink().addClickListener((ToolHyperLinkLabel.ClickListener)new QueryDeviceAction(this.cardLayout));
    }

    private void initDefaultTableData() {
        List devNodes = DefaultNodeProviderImpl.getInstance().getNodeList();
        try {
            DefaultNodeProviderImpl.getInstance().removeNodes(devNodes);
        }
        catch (ToolException e) {
            LOGGER.error("remove DefaultNodeProviderImpl nodes error.");
        }
        List<DevNode> mainTableDevs = FSClusterDevManager.getInstance().getTableDevs();
        try {
            DefaultNodeProviderImpl.getInstance().addNodes(mainTableDevs);
        }
        catch (ToolException e) {
            LOGGER.error("add DefaultNodeProviderImpl nodes error.");
        }
    }

    private List<DevNode> getSelectedDev() {
        List allSelectRows = this.cardLayout.getDeviceTable().getMarkedRows();
        ArrayList<DevNode> devNodes = new ArrayList<DevNode>();
        for (TableRow row : allSelectRows) {
            Object rowObj = row.getIdentifier();
            if (!(rowObj instanceof DevNode)) continue;
            devNodes.add((DevNode)rowObj);
        }
        return devNodes;
    }

    private static List<FSDevNode> queryFSDevNodes(DevNode dev) {
        ArrayList<FSDevNode> queryFSNodeList = new ArrayList();
        Future future = ThreadPoolManager.getInstance().submit((Callable)new QueryFSDevNodes(dev));
        try {
            queryFSNodeList = (List)future.get();
            if (queryFSNodeList != null) {
                return queryFSNodeList;
            }
        }
        catch (InterruptedException | ExecutionException ee) {
            LOGGER.error("wait query fusionstorage node error!!!", (Throwable)ee);
        }
        return queryFSNodeList;
    }

    private FSClusterDevice createFSClusterDev(DevNode devNode, List<FSDevNode> fsDevNodes) {
        FSClusterDevice fsClusterDevice = new FSClusterDevice(devNode, true);
        fsClusterDevice.setFsDevNodeList(fsDevNodes);
        fsDevNodes.stream().filter(FSDevNode::isFsmNode).forEach(node -> fsClusterDevice.setInnerFloatIp(node.getManagementInnerFloatIp()));
        return fsClusterDevice;
    }

    private List<ArrayList<Object>> getHdfsNodes(List<FSDevNode> fsDevNodeList) {
        ArrayList<ArrayList<Object>> hdfsNodesIps = new ArrayList<ArrayList<Object>>();
        for (FSDevNode node : fsDevNodeList) {
            List<String> nodeServices = node.getServices();
            if (!nodeServices.contains("pool_HDFS")) continue;
            ArrayList<String> hdfsNodesIp = new ArrayList<String>();
            hdfsNodesIp.add(node.getManagementIP());
            hdfsNodesIp.add(node.getBmcIP());
            hdfsNodesIps.add(hdfsNodesIp);
        }
        return hdfsNodesIps;
    }

    static {
        checkers.add(new EmptyNodeDetermination());
        checkers.add(new UnSupportHdfsServerChecker());
    }

    public static class QueryFSDevNodes
    implements Callable<List<FSDevNode>> {
        private DevNode devNode;

        public QueryFSDevNodes(DevNode devNode) {
            this.devNode = devNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<FSDevNode> call() {
            try {
                JSONArray nodeBasicInfo = this.queryNodeBasicInfo();
                JSONArray nodeServiceInfo = this.queryNodeServiceInfo();
                JSONArray nodeIpInfo = this.queryNodeManageIpInfo();
                JSONObject nodeProductInfo = this.queryNodeProductInfo();
                List<FSDevNode> nodeList = this.parseNodeInfo(nodeBasicInfo, nodeServiceInfo, nodeIpInfo, nodeProductInfo);
                this.initVolumeNum(nodeList);
                this.initNodeService(nodeList);
                this.initDirectPlanesInfo(nodeList);
                this.setDpcUpgradeScripPathPrefix(nodeList);
                List<FSDevNode> list = nodeList;
                return list;
            }
            catch (Exception e) {
                LOGGER.error("Query node info error ", (Throwable)e);
                List<FSDevNode> list = Collections.emptyList();
                return list;
            }
            finally {
                RestConnectionManager.releaseConn((DevNode)this.devNode);
            }
        }

        private void setDpcUpgradeScripPathPrefix(List<FSDevNode> lists) {
            if (!this.devNode.getProductVersion().contains("8.1.6")) {
                return;
            }
            String url = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + "/api/v2/deploy_manager/servers";
            JSONArray prefixInfo = this.execGet(url);
            HashMap<String, String> nodeDeployPrefix = new HashMap<String, String>();
            for (int index = 0; index < prefixInfo.length(); ++index) {
                JSONObject detail = prefixInfo.getJSONObject(index);
                String managementIp = detail.getStringOrDefault("management_internal_ip", "");
                String deployPrefix = detail.getStringOrDefault("deploy_prefix", "");
                nodeDeployPrefix.put(managementIp, deployPrefix);
            }
            lists.forEach(node -> node.setDeployPrefix(nodeDeployPrefix.getOrDefault(node.getManagementIP(), "")));
        }

        private void initDirectPlanesInfo(List<FSDevNode> nodeList) {
            if (!IS_COMPUTER_NODE_UPGRADE && UpgradeCustomizationUtil.hasDictPlane(this.devNode)) {
                JSONArray directPlanes = this.queryDirectPlanes();
                JSONObject nodeProductInfo = this.queryNodeProductInfo();
                nodeList.addAll(this.parseDirectPlaneNodes(directPlanes, nodeProductInfo));
            }
        }

        private void initVolumeNum(List<FSDevNode> nodeList) {
            if (IS_COMPUTER_NODE_UPGRADE) {
                return;
            }
            List vbsNodes = nodeList.stream().filter(node -> node.getServices().contains("vbs")).collect(Collectors.toList());
            int maxBlockSize = 20;
            int limit = (vbsNodes.size() + 20 - 1) / 20;
            ArrayList taskList = new ArrayList();
            Stream.iterate(0, blockNum -> blockNum + 1).limit(limit).forEach(offsetIndex -> taskList.add(vbsNodes.stream().skip(offsetIndex * 20).limit(20L).collect(Collectors.toList())));
            taskList.forEach(task -> this.parseAndInitVolumeNumInfo(nodeList, this.queryVolumeNum((List<FSDevNode>)task)));
        }

        private JSONArray queryVolumeNum(List<FSDevNode> task) {
            try {
                String url = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + "/api/v2/block_service/vbs_client_statistics";
                HashMap<String, String> param = new HashMap<String, String>();
                JSONArray data = new JSONArray();
                task.stream().map(FSDevNode::getStorageFrontIp).forEach(arg_0 -> ((JSONArray)data).put(arg_0));
                param.put("names", URLEncoder.encode(data.toString(), "UTF-8"));
                return this.execGet(url, param);
            }
            catch (Exception e) {
                LOGGER.error("Query volume number error.", (Throwable)e);
                return null;
            }
        }

        private void parseAndInitVolumeNumInfo(List<FSDevNode> nodeList, JSONArray vbsVolumeInfos) {
            if (Objects.isNull(vbsVolumeInfos)) {
                return;
            }
            for (int i = 0; i < vbsVolumeInfos.length(); ++i) {
                JSONObject objData = vbsVolumeInfos.getJSONObject(i);
                String ip = objData.getString("manage_id");
                String volumeNum = objData.getString("mapped_volume_number");
                nodeList.stream().filter(fsDevNode -> ip.equals(fsDevNode.getStorageFrontIp())).findFirst().ifPresent(fsDevNode -> fsDevNode.setVolumeNum(Integer.parseInt(volumeNum)));
            }
        }

        private List<FSDevNode> parseDirectPlaneNodes(JSONArray directPlanes, JSONObject nodeProductInfo) {
            ArrayList<FSDevNode> nodes = new ArrayList<FSDevNode>();
            boolean isOemSetting = this.parseNodeOemInfo(nodeProductInfo);
            for (int i = 0; i < directPlanes.length(); ++i) {
                JSONObject object = directPlanes.getJSONObject(i);
                FSDevNode node = new FSDevNode();
                node.setBmcIP(object.getString("ip"));
                if (object.has("chassisId")) {
                    node.setChassisId(object.getString("chassisId"));
                }
                node.setBorderType("DirectPlane");
                node.setRoles(Collections.singletonList("DirectPlane"));
                NodeServiceInfo serviceInfo = new NodeServiceInfo("");
                serviceInfo.setServiceInfo(Collections.singleton("DirectPlane"));
                serviceInfo.setStoragePoolId("DirectPlane" + node.getChassisId());
                serviceInfo.resetNodeUpgradePriorityByNodeServiceInfo();
                node.setNodeServiceInfo(serviceInfo);
                node.setOemSetting(isOemSetting);
                nodes.add(node);
            }
            return nodes;
        }

        private void initNodeService(List<FSDevNode> fSDevNodeList) {
            String scene = UpgradeContext.getInstance().getUpgradeScene();
            if (!Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(scene)) {
                return;
            }
            Set<String> nodeMgrIpSet = fSDevNodeList.stream().map(FSDevNode::getManagementIP).collect(Collectors.toSet());
            Map<String, NodeServiceInfo> nodeServiceInfoMap = NodeServiceUtils.queryNodeService(this.devNode, nodeMgrIpSet);
            fSDevNodeList.forEach(fSDevNode -> {
                NodeServiceInfo info = (NodeServiceInfo)nodeServiceInfoMap.get(fSDevNode.getManagementIP());
                info.setVolumeNum(fSDevNode.getVolumeNum());
                info.resetNodeUpgradePriorityByNodeServiceInfo();
                fSDevNode.setNodeServiceInfo(info);
            });
        }

        private JSONArray queryNodeServiceInfo() {
            String url = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + "/api/v2/cluster/servers";
            return this.execGet(url);
        }

        private JSONObject queryNodeProductInfo() {
            String url = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + "/api/v2/cluster/product";
            return this.execGetObj(url);
        }

        private JSONArray queryNodeBasicInfo() {
            if (IS_COMPUTER_NODE_UPGRADE) {
                return new JSONArray();
            }
            String url = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + "/api/v2/cluster/servers/bmc_info";
            return this.execGet(url);
        }

        private JSONArray queryNodeManageIpInfo() {
            String url = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + "/api/v2/network_service/servers";
            HashMap param = new HashMap();
            return this.execPost(url, param);
        }

        private JSONArray queryDirectPlanes() {
            String url = RestUtil.getDstorageUrlHead((DevNode)this.devNode) + "/api/v2/hwm/direct_planes";
            return this.execGet(url);
        }

        private JSONArray execGet(String url) {
            JSONArray data = new JSONArray();
            try {
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
                ResponseInfo resp = Objects.requireNonNull(conn).execGet(url);
                String content = resp.getContent();
                JSONObject jsonObj = new JSONObject(content);
                if (content.contains("data")) {
                    data = jsonObj.getJSONArray("data");
                }
            }
            catch (Exception e) {
                LOGGER.error("Query fusionstorage nodes error:", (Throwable)e);
            }
            return data;
        }

        private JSONObject execGetObj(String url) {
            try {
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
                ResponseInfo resp = Objects.requireNonNull(conn).execGet(url);
                String content = resp.getContent();
                JSONObject jsonObj = new JSONObject(content);
                if (content.contains("data")) {
                    return jsonObj.getJSONObject("data");
                }
            }
            catch (ToolException | NullPointerException e) {
                LOGGER.error("Query fusionstorage nodes error:", e);
            }
            return new JSONObject();
        }

        private JSONArray execGet(String url, Map param) {
            JSONArray data = new JSONArray();
            try {
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
                ResponseInfo resp = Objects.requireNonNull(conn).execGet(url, param);
                String content = resp.getContent();
                JSONObject jsonObj = new JSONObject(content);
                if (content.contains("data")) {
                    data = jsonObj.getJSONArray("data");
                }
            }
            catch (Exception e) {
                LOGGER.error("Query fusionstorage nodes error:", (Throwable)e);
            }
            return data;
        }

        private JSONArray execPost(String url, Map param) {
            JSONArray data = new JSONArray();
            try {
                RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
                ResponseInfo resp = Objects.requireNonNull(conn).execPost(url, param);
                String content = resp.getContent();
                JSONObject jsonObj = new JSONObject(content);
                if (content.contains("data")) {
                    data = jsonObj.getJSONArray("data");
                }
            }
            catch (Exception e) {
                LOGGER.error("Query fusionstorage nodes error:", (Throwable)e);
            }
            return data;
        }

        private List<FSDevNode> parseNodeInfo(JSONArray nodeBasicInfo, JSONArray nodeServiceInfo, JSONArray nodeIpInfo, JSONObject nodeProductInfo) {
            Map<String, FSDevNode> nodeServiceInfoMap = this.parseNodeServiceInfo(nodeServiceInfo);
            Map<String, FSDevNode> nodeInfoMapDPC = IS_COMPUTER_NODE_UPGRADE ? nodeServiceInfoMap : this.parseNodeBasicInfo(nodeBasicInfo);
            this.parseNodeIpInfo2GetInnerFloatIp(nodeIpInfo, nodeInfoMapDPC);
            boolean isOemSetting = this.parseNodeOemInfo(nodeProductInfo);
            ArrayList<FSDevNode> nodes = new ArrayList<FSDevNode>();
            for (String key : nodeInfoMapDPC.keySet()) {
                FSDevNode node = nodeInfoMapDPC.get(key);
                node.setServices(nodeServiceInfoMap.get(key).getServices());
                node.setChassisId(nodeServiceInfoMap.get(key).getChassisId());
                node.setBmcAuthState(nodeServiceInfoMap.get(key).getBmcAuthState());
                node.setBorderType(nodeServiceInfoMap.get(key).getBorderType());
                node.setSerialNumber(nodeServiceInfoMap.get(key).getSerialNumber());
                node.setOemSetting(isOemSetting);
                nodes.add(node);
            }
            if (!IS_COMPUTER_NODE_UPGRADE) {
                this.setManagementIps(nodes);
            }
            return nodes;
        }

        private void setManagementIps(List<FSDevNode> nodes) {
            List managementIps = nodes.stream().filter(FSDevNode::isManagementNode).map(FSDevNode::getBmcIP).collect(Collectors.toList());
            nodes.forEach(node -> node.setManagementIps(managementIps));
        }

        private void parseNodeIpInfo2GetInnerFloatIp(JSONArray responseData, Map<String, FSDevNode> nodeBasicInfoMap) {
            int dataLen = responseData.length();
            for (int i = 0; i < dataLen; ++i) {
                JSONObject obj = responseData.getJSONObject(i);
                String managementIp = obj.getString("management_internal_ip");
                JSONArray ipAddressList = obj.getJSONArray("ip_address_list");
                Optional<FSDevNode> nodeOpt = this.getExternalFloatIpNode(ipAddressList);
                this.initNetInfo(nodeBasicInfoMap.get(managementIp), ipAddressList);
                this.initNetList(obj, nodeBasicInfoMap.get(managementIp));
                if (!nodeOpt.isPresent()) continue;
                FSDevNode fsmNode = nodeOpt.get();
                FSDevNode basicNode = nodeBasicInfoMap.get(managementIp);
                basicNode.setManagementExternalFloatIp(fsmNode.getManagementExternalFloatIp());
                basicNode.setManagementInnerFloatIp(fsmNode.getManagementInnerFloatIp());
            }
        }

        private void initNetList(JSONObject obj, FSDevNode fsDevNode) {
            try {
                Map<String, List<String>> bondMap = this.initBondListNameMap(obj);
                Map<String, List<String>> vlanMap = this.initVlanList(obj);
                List<String> physicalPortInfoList = this.initPhysicalPorts(obj);
                if (physicalPortInfoList.isEmpty()) {
                    LOGGER.info("Do not exist port use direct bord port.");
                    fsDevNode.getStorageBackEndPortList().clear();
                    fsDevNode.getStorageFrontendEndPortList().clear();
                    return;
                }
                fsDevNode.setStorageBackEndPortList(this.resetPortName(bondMap, vlanMap, physicalPortInfoList, fsDevNode.getStorageBackEndPortList()));
                fsDevNode.setStorageFrontendEndPortList(this.resetPortName(bondMap, vlanMap, physicalPortInfoList, fsDevNode.getStorageFrontendEndPortList()));
                List<String> frontEndList = fsDevNode.getStorageFrontendEndPortList();
                frontEndList = frontEndList.stream().filter(physicalPortInfoList::contains).collect(Collectors.toList());
                fsDevNode.setStorageFrontendEndPortList(frontEndList);
                List<String> backEndList = fsDevNode.getStorageBackEndPortList();
                backEndList = backEndList.stream().filter(physicalPortInfoList::contains).collect(Collectors.toList());
                fsDevNode.setStorageBackEndPortList(backEndList);
            }
            catch (Exception e) {
                LOGGER.error("Init net info failed.", (Throwable)e);
            }
        }

        private List<String> initPhysicalPorts(JSONObject obj) {
            JSONArray ports = obj.getJSONArray("physical_ports");
            ArrayList<PhysicalPortInfo> physicalPortList = new ArrayList<PhysicalPortInfo>();
            for (int i = 0; i < ports.length(); ++i) {
                JSONObject info = ports.getJSONObject(i);
                PhysicalPortInfo physicalPort = new PhysicalPortInfo();
                physicalPort.portName = info.getStringOrDefault("port_name", "");
                physicalPort.portSn = info.getStringOrDefault("port_sn", "");
                if (!info.has("port_sn")) {
                    physicalPort.portSn = info.getStringOrDefault("nic_sn", "");
                }
                physicalPortList.add(physicalPort);
            }
            return physicalPortList.stream().filter(physicalPortInfo -> physicalPortInfo.portSn.contains("0000:7d:00.")).map(physicalPortInfo -> physicalPortInfo.portName).collect(Collectors.toList());
        }

        private List<String> resetPortName(Map<String, List<String>> bondMap, Map<String, List<String>> vlanMap, List<String> physicalPortInfoList, List<String> portList) {
            HashSet portNameSet = new HashSet();
            portList.stream().forEach(port -> portNameSet.addAll(bondMap.getOrDefault(port, Collections.emptyList())));
            portList.stream().forEach(port -> portNameSet.addAll(vlanMap.getOrDefault(port, Collections.emptyList())));
            portNameSet.addAll(physicalPortInfoList.stream().filter(portName -> portList.contains(portName)).collect(Collectors.toList()));
            return portNameSet.stream().collect(Collectors.toList());
        }

        private Map<String, List<String>> initVlanList(JSONObject obj) {
            JSONArray vlanList = obj.getJSONArray("vlan_list");
            HashMap<String, List<String>> name2PhysicalName = new HashMap<String, List<String>>();
            for (int i = 0; i < vlanList.length(); ++i) {
                JSONObject info = vlanList.getJSONObject(i);
                String vlanName = info.getString("vlan_name");
                String portName = info.getString("port_name");
                name2PhysicalName.put(vlanName, Arrays.asList(portName));
            }
            return name2PhysicalName;
        }

        private Map<String, List<String>> initBondListNameMap(JSONObject obj) {
            JSONArray bondList = obj.getJSONArray("bond_list");
            HashMap<String, List<String>> name2PhysicalName = new HashMap<String, List<String>>();
            for (int i = 0; i < bondList.length(); ++i) {
                JSONObject bondInfo = bondList.getJSONObject(i);
                ArrayList<String> physicalPorts = new ArrayList<String>();
                JSONArray ports = bondInfo.getJSONArray("physical_ports");
                for (int j = 0; j < ports.length(); ++j) {
                    JSONObject port = ports.getJSONObject(j);
                    physicalPorts.add(port.getString("port_name"));
                }
                name2PhysicalName.put(bondInfo.getString("bond_name"), physicalPorts);
            }
            return name2PhysicalName;
        }

        private void initNetInfo(FSDevNode fsDevNode, JSONArray ipAddressList) {
            for (int i = 0; i < ipAddressList.length(); ++i) {
                JSONObject obj = ipAddressList.getJSONObject(i);
                JSONArray ipUsages = obj.getJSONArray("ip_usage");
                List usages = JSONUtils.jsonToList((String)ipUsages.toString(), String.class);
                String ipAddress = obj.getString("ip_address");
                if (usages.contains("storage_frontend")) {
                    fsDevNode.setStorageFrontIp(ipAddress);
                    if (!obj.isNull("port_name")) {
                        fsDevNode.addStorageFrontEndPortName(obj.getString("port_name"));
                    }
                }
                if (!usages.contains("storage_backend") || obj.isNull("port_name")) continue;
                fsDevNode.addStorageBackEndPortName(obj.getString("port_name"));
            }
        }

        private Optional<FSDevNode> getExternalFloatIpNode(JSONArray ipAddressList) {
            FSDevNode fsDevNode = new FSDevNode();
            for (int i = 0; i < ipAddressList.length(); ++i) {
                JSONObject obj = ipAddressList.getJSONObject(i);
                JSONArray ipUsages = obj.getJSONArray("ip_usage");
                List usages = JSONUtils.jsonToList((String)ipUsages.toString(), String.class);
                String ipAddress = obj.getString("ip_address");
                if (usages.contains("management_external_float")) {
                    fsDevNode.setManagementExternalFloatIp(ipAddress);
                }
                if (!usages.contains("management_internal_float")) continue;
                fsDevNode.setManagementInnerFloatIp(ipAddress);
            }
            if (fsDevNode.isFsmNode()) {
                return Optional.of(fsDevNode);
            }
            return Optional.empty();
        }

        private Map<String, FSDevNode> parseNodeServiceInfo(JSONArray responseData) {
            HashMap<String, FSDevNode> fsDevNodes = new HashMap<String, FSDevNode>();
            int dataLen = responseData.length();
            for (int i = 0; i < dataLen; ++i) {
                JSONObject obj = responseData.getJSONObject(i);
                String managementIp = obj.getString("management_ip");
                JSONArray roleArr = obj.getJSONArray("usage");
                List services = JSONUtils.jsonToList((String)roleArr.toString(), String.class);
                FSDevNode fsDevNode = new FSDevNode();
                fsDevNode.setManagementIP(managementIp);
                fsDevNode.setServices(services);
                fsDevNode.setSerialNumber(obj.getStringOrDefault("serial_number", managementIp));
                fsDevNodes.put(managementIp, fsDevNode);
                if (obj.has("subrack")) {
                    String subRack = obj.getString("subrack");
                    fsDevNode.setChassisId(subRack);
                }
                fsDevNode.setBorderType(obj.getStringOrDefault("base_board", "None"));
                if (obj.has("base_board") && ClusterNode.BaseBoardType.HG_SERVER.getProductName().equals(obj.get("base_board"))) {
                    fsDevNode.setBmcAuthState(Constants.NodeAuthState.NOT_REQUIRED);
                }
                if (!IS_COMPUTER_NODE_UPGRADE) continue;
                fsDevNode.setRoles(JSONUtils.jsonToList((String)obj.getJSONArray("role").toString(), String.class));
                fsDevNode.setProductName(obj.getString("model"));
            }
            return fsDevNodes;
        }

        private Map<String, FSDevNode> parseNodeBasicInfo(JSONArray responseData) {
            HashMap<String, FSDevNode> fsDevNodes = new HashMap<String, FSDevNode>();
            int dataLen = responseData.length();
            for (int i = 0; i < dataLen; ++i) {
                JSONObject obj = responseData.getJSONObject(i);
                JSONArray roleArr = obj.getJSONArray("role");
                List roles = JSONUtils.jsonToList((String)roleArr.toString(), String.class);
                FSDevNode fsDevNode = new FSDevNode();
                String bmcIp = obj.getString("bmc_ip");
                String managementIp = obj.getString("management_ip");
                String model = obj.getString("model");
                fsDevNode.setBmcIP(bmcIp);
                fsDevNode.setManagementIP(managementIp);
                fsDevNode.setRoles(roles);
                fsDevNode.setProductName(model);
                fsDevNodes.put(managementIp, fsDevNode);
            }
            return fsDevNodes;
        }

        private boolean parseNodeOemInfo(JSONObject responseData) {
            String productModel = responseData.getStringOrDefault("product_model", "");
            String oemProductModel = responseData.getStringOrDefault("oem_product_model", "");
            return !oemProductModel.isEmpty() && !Objects.equals(oemProductModel, productModel);
        }

        class PhysicalPortInfo {
            String portName;
            String portSn;

            PhysicalPortInfo() {
            }
        }
    }
}

