/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.card;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.distributedfwupg.action.SelectNodesConfirm;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCardLayout;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.awt.BorderLayout;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class SelectNodeCard
extends ToolWizardDialog.Card {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SelectNodeCard.class);
    private static final String COMPUTE = "compute";
    private static final String MANAGEMENT = "management";
    private static final String STORAGE = "storage";
    private SelectNodeCardLayout cardLayout;
    private FSClusterDevice fsClusterDevice;
    private List<FSDevNode> queryFsDevNodes;
    private List<IImportListener> importListener = new ArrayList<IImportListener>();

    public SelectNodeCard(ToolWizardDialog.Card previousCard, FSClusterDevice fsClusterDevice, ToolWizardDialog.Navigation ... supportedNavigation) {
        super(previousCard, supportedNavigation);
        this.fsClusterDevice = fsClusterDevice;
        this.queryFsDevNodes = fsClusterDevice.getFsDevNodeList();
        this.cardLayout = new SelectNodeCardLayout(false, fsClusterDevice.needOSAuth(), fsClusterDevice.needBMCAuth(), CommonUtils.isDpcPrepare(fsClusterDevice.getFsDevNodeList()));
        this.setLayout(new BorderLayout());
        this.add(this.cardLayout, "Center");
        this.importListener.clear();
        this.importListener.add(this.cardLayout);
        DeviceCenterContext.getInstance().getDeviceTables().put("deviceTables", this.importListener);
        this.initTableData();
        this.cardLayout.bindListener(UpgradeContext.getInstance().getMainDialog(), fsClusterDevice.needOSAuth(), this.fsClusterDevice);
    }

    public String getTitle() {
        return ResourceUtil.getString((String)"dsfwupgrade.wizard.step2.title");
    }

    public int getStep() {
        return 1;
    }

    protected ToolWizardDialog.Card getNextCard() {
        return null;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Previous == navigation || ToolWizardDialog.Navigation.Cancel == navigation) {
            return true;
        }
        return new SelectNodesConfirm(this.cardLayout, this.fsClusterDevice).doConfirm();
    }

    private void initTableData() {
        String scene = UpgradeContext.getInstance().getUpgradeScene();
        if (Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(scene)) {
            this.initTableData4Firmware();
        } else if (Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(scene)) {
            this.initTableData4ComputeNode();
        }
    }

    private void initTableData4Firmware() {
        this.queryFsDevNodes.stream().filter(node -> !node.isPureComputeNode()).forEach(this.cardLayout::createRow);
    }

    private void initTableData4ComputeNode() {
        JDialog dialog = UpgradeContext.getInstance().getDialog();
        AsyncExcutor.execute((Window)dialog, (boolean)true, (long)0L, (Callable[])new Callable[]{new Callable<Boolean>(){

            @Override
            public Boolean call() {
                SelectNodeCard.this.cardLayout.createRowForBatch(SelectNodeCard.this.queryFsDevNodes.stream().filter(FSDevNode::isPureComputeNode).collect(Collectors.toList()), SelectNodeCard.this.fsClusterDevice);
                return true;
            }
        }});
    }
}

