/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.card;

import com.huawei.bundleupgrade.entity.NodeServiceInfo;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.driver.model.TotalDriverResult;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.entity.OsDevice;
import com.huawei.ism.tool.devicecenter.service.IImportListener;
import com.huawei.ism.tool.distributedfwupg.action.BatchExportTemplateAction;
import com.huawei.ism.tool.distributedfwupg.action.BatchImportDeviceAction;
import com.huawei.ism.tool.distributedfwupg.action.UpdateFSNodeBmcAuthAction;
import com.huawei.ism.tool.distributedfwupg.action.UpdateFSNodeOsAuthAction;
import com.huawei.ism.tool.distributedfwupg.action.UpdateFSNodeSandboxAction;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SelectNodeCardLayout
extends JPanel
implements IImportListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SelectNodeCardLayout.class);
    public static ITDeviceType serverType;
    private DefaultTableModel tableModel;
    private IsmTable deviceTable;
    private JButton authBmcBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.bmc"), (char)'B');
    private JButton authOsBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.os"), (char)'O');
    private JButton sandboxBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.shutdown.sandbox"), (char)'S');
    private JButton batchImportDeviceBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.batch.import"), (char)'I');
    private JButton batchExportDeviceTemplateBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.batch.export"), (char)'E');
    private JButton cancleBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.scene.button.cancel"), (char)'C');
    private JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.scene.button.ok"), (char)'L');
    private boolean modify;
    private boolean needOsAuth;
    private boolean needBmcAuth;
    private boolean isDpcPrepare;

    public SelectNodeCardLayout() {
        this(false);
    }

    public SelectNodeCardLayout(boolean modify) {
        this(modify, false, true, false);
    }

    public SelectNodeCardLayout(boolean modify, boolean needOSAuth, boolean needBMCAuth, boolean isDpcPrepare) {
        this.modify = modify;
        this.needOsAuth = needOSAuth;
        this.needBmcAuth = needBMCAuth;
        this.isDpcPrepare = isDpcPrepare;
        this.initAddUI();
    }

    public void bindListener(JDialog parent, boolean needOsAuth, FSClusterDevice fsClusterDevice) {
        this.getAuthBmcBtn().addActionListener(actionEvent -> new UpdateFSNodeBmcAuthAction(this, this.getSelectedFsNode()).actionPerformed(actionEvent));
        this.getAuthOsBtn().addActionListener(actionEvent -> new UpdateFSNodeOsAuthAction(this.getSelectedFsNode()).actionPerformed(actionEvent));
        this.getSandboxBtn().addActionListener(actionEvent -> new UpdateFSNodeSandboxAction(this, this.getSelectedFsNode(), fsClusterDevice).actionPerformed(actionEvent));
        this.getBatchImportDeviceBtn().addActionListener(event -> new BatchImportDeviceAction(parent, this).actionPerformed(event));
        this.getBatchExportDeviceTemplateBtn().addActionListener(event -> new BatchExportTemplateAction(parent, this).actionPerformed(event));
        String scene = UpgradeContext.getInstance().getUpgradeScene();
        if (Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(scene) && needOsAuth) {
            this.getDeviceTable().addListSelectionListener(event -> {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                this.getAuthOsBtn().setEnabled(!this.getSelectedFsNode().stream().allMatch(FSDevNode::isDirectPlane));
            });
        }
        if (Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(scene)) {
            this.getDeviceTable().addListSelectionListener(event -> {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                this.getAuthBmcBtn().setEnabled(this.getSelectedFsNode().stream().allMatch(FSDevNode::isBmcAuthRequired));
            });
        }
    }

    private void initAddUI() {
        if (!this.needOsAuth) {
            this.authOsBtn.setVisible(false);
            this.sandboxBtn.setVisible(false);
        }
        String scene = UpgradeContext.getInstance().getUpgradeScene();
        if (!Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(scene)) {
            this.sandboxBtn.setVisible(false);
        }
        if (Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(scene)) {
            this.batchImportDeviceBtn.setVisible(false);
            this.batchExportDeviceTemplateBtn.setVisible(false);
        }
        if (!this.needBmcAuth) {
            this.authBmcBtn.setVisible(false);
        }
        JLabel desc = new JLabel(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.desc"));
        JComponent addDeviceSuggestion = UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{desc});
        JComponent deviceTableScroll = this.layoutTableScroll();
        JComponent viewJc = UCD.buildVerticalBox(null, (Component[])new Component[]{addDeviceSuggestion, UiMethod.buildCompsLeft((int)12, (Component[])new Component[]{this.authBmcBtn, this.authOsBtn, this.sandboxBtn, this.batchImportDeviceBtn, this.batchExportDeviceTemplateBtn}), deviceTableScroll});
        if (this.modify) {
            this.initModifyUI(viewJc);
        } else {
            this.setLayout(new BorderLayout());
            this.add((Component)viewJc, "Center");
        }
    }

    private void initModifyUI(JComponent top) {
        JComponent buttonArea = this.layoutButtonArea();
        JComponent contentArea = UCD.buildVerticalBox(null, (Component[])new Component[]{top, buttonArea, Box.createHorizontalStrut(12), Box.createHorizontalStrut(12)});
        JComponent contentCom = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(12), contentArea, Box.createHorizontalStrut(12)});
        this.setLayout(new BorderLayout());
        this.add(contentCom);
    }

    private JComponent layoutTableScroll() {
        String[] headers = null;
        if (this.needOsAuth && this.needBmcAuth) {
            headers = new String[]{ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.manageip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.bmcip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.role"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.productname"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.state"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.sandbox.state"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.bmcOperation"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.osOperation")};
        } else if (this.needBmcAuth) {
            headers = new String[]{ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.manageip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.bmcip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.role"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.productname"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.state"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.bmcOperation")};
        } else if (this.needOsAuth) {
            headers = this.isDpcPrepare ? new String[]{ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.manageip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.role"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.productname"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.state"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.osOperation"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.compare")} : new String[]{ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.manageip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.role"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.productname"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.state"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.osOperation")};
        }
        this.tableModel = new DefaultTableModel(headers, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.tableModel);
        return new TableScrollPane(this.deviceTable, false, false, true);
    }

    private JComponent layoutButtonArea() {
        return UiMethod.buildCompsRight((Component[])new Component[]{this.okBtn, this.cancleBtn});
    }

    private void tableRowRender(TableRow row, FSDevNode fsDevNode) {
        int rowIndex = 0;
        row.setValueAt(rowIndex++, (Object)fsDevNode.getManagementIP());
        if (this.needBmcAuth) {
            row.setValueAt(rowIndex++, (Object)fsDevNode.getBmcIP());
        }
        row.setValueAt(rowIndex++, (Object)StringUtils.join(fsDevNode.getRoles(), (String)","));
        row.setValueAt(rowIndex++, (Object)fsDevNode.getProductName());
        if (fsDevNode.isDirectPlane()) {
            row.setValueAt(rowIndex++, (Object)fsDevNode.getAuthStateDesc(this.needBmcAuth, false));
        } else {
            row.setValueAt(rowIndex++, (Object)fsDevNode.getAuthStateDesc(this.needBmcAuth, this.needOsAuth));
        }
        String scene = UpgradeContext.getInstance().getUpgradeScene();
        rowIndex = this.setSandboxStatus(row, fsDevNode, rowIndex, scene);
        if (this.needBmcAuth) {
            if (Constants.NodeAuthState.NOT_REQUIRED.equals((Object)fsDevNode.getBmcAuthState())) {
                row.setValueAt(rowIndex++, (Object)ResourceUtil.getString((String)"dsfwupgrade.wizard.selectdevice.notrequired"));
            } else {
                IsmTableCell.HyperlinkCell bmcOperateCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectdevice.modify"), (ActionListener)new UpdateFSNodeBmcAuthAction(this, fsDevNode));
                row.setValueAt(rowIndex++, (Object)bmcOperateCell);
            }
        }
        if (!fsDevNode.isDirectPlane() && this.needOsAuth) {
            IsmTableCell.HyperlinkCell osOperateCell = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectdevice.modify"), (ActionListener)new UpdateFSNodeOsAuthAction(fsDevNode));
            row.setValueAt(rowIndex++, (Object)osOperateCell);
        }
        if (fsDevNode.isDpcComputeNode()) {
            if (!fsDevNode.isQueryDpcSuccess()) {
                row.setValueAt(rowIndex++, (Object)ResourceUtil.getString((String)"upgrade.compute.node.query.dpc.error"));
            } else {
                row.setValueAt(rowIndex++, (Object)(fsDevNode.isConsistent() ? ResourceUtil.getString((String)"upgrade.compute.node.dpc.version.consistent") : ResourceUtil.getString((String)"upgrade.compute.node.dpc.version.inconsistent")));
            }
        }
    }

    private int setSandboxStatus(TableRow row, FSDevNode fsDevNode, int rowIndex, String scene) {
        int tempIndex = rowIndex;
        if (Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(scene)) {
            if (fsDevNode.isDirectPlane()) {
                row.setValueAt(tempIndex++, (Object)new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"dsfwupgrade.wizard.status.sandbox.notconfigured")));
                return tempIndex;
            }
            NodeServiceInfo nodeService = fsDevNode.getNodeServiceInfo();
            row.setValueAt(tempIndex++, (Object)new IsmTableCell.HyperlinkCell(fsDevNode.getsandboxStateDesc(Objects.nonNull(nodeService) ? nodeService.getSandboxStatus() : null)));
        }
        return tempIndex;
    }

    public void createRow(FSDevNode fsDevNode) {
        DefaultTableRow row = new DefaultTableRow(this.tableModel.getAllColumnCount(), (Object)fsDevNode);
        this.tableRowRender((TableRow)row, fsDevNode);
        this.tableModel.addRow(new TableRow[]{row});
        if (fsDevNode.isSelected()) {
            this.deviceTable.markTableRow(new TableRow[]{row});
        }
    }

    public void createRowForBatch(List<FSDevNode> fsDevNodeList, FSClusterDevice fsClusterDevice) {
        if (CommonUtils.isDpcPrepare(fsDevNodeList)) {
            FsUpgradeService.updateDpcVersion(fsDevNodeList, fsClusterDevice.createDevNodeByClusterDevice());
        }
        try {
            int nodeSize = fsDevNodeList.size();
            TableRow[] rows = new TableRow[nodeSize];
            TableRow[] markedRows = new TableRow[nodeSize];
            int markedIndex = 0;
            for (int index = 0; index < nodeSize; ++index) {
                FSDevNode fsDevNode = fsDevNodeList.get(index);
                DefaultTableRow row = new DefaultTableRow(this.tableModel.getAllColumnCount(), (Object)fsDevNode);
                this.tableRowRender((TableRow)row, fsDevNode);
                rows[index] = row;
                if (!fsDevNode.isSelected()) continue;
                markedRows[markedIndex++] = row;
            }
            this.tableModel.addRow(rows);
            if (markedIndex > 0) {
                TableRow[] tableRows = Arrays.copyOfRange(markedRows, 0, markedIndex);
                this.deviceTable.markTableRow(tableRows);
            }
        }
        catch (Exception e) {
            LOGGER.error("add batch tableModel rows error.");
        }
    }

    public void updateTableRowData(FSDevNode fsDevNode) {
        TableRow row = this.tableModel.getTableRowBy((Object)fsDevNode);
        this.tableRowRender(row, fsDevNode);
    }

    public List<FSDevNode> getSelectedFsNode() {
        List allSelectRows = this.deviceTable.getMarkedRows();
        ArrayList<FSDevNode> fsDevNodes = new ArrayList<FSDevNode>();
        for (TableRow row : allSelectRows) {
            Object rowObj = row.getIdentifier();
            if (!(rowObj instanceof FSDevNode)) continue;
            fsDevNodes.add((FSDevNode)((Object)rowObj));
        }
        return fsDevNodes;
    }

    public void setFsNode2Selected(List<AbstractDevice> fsDevNodeList) {
        List allNodes = this.deviceTable.getAllRows();
        List nodeIpList = fsDevNodeList.stream().map(node -> ((FSDevNode)((Object)node)).getManagementIP()).collect(Collectors.toList());
        List<TableRow> needSelectRows = allNodes.stream().filter(row -> nodeIpList.contains(row.getValueAt(0))).collect(Collectors.toList());
        this.deviceTable.markTableRow(needSelectRows.toArray(new TableRow[0]));
    }

    public List<FSDevNode> getAllFsNode() {
        ArrayList<FSDevNode> devs = new ArrayList<FSDevNode>();
        List rows = this.deviceTable.getAllRows();
        for (TableRow row : rows) {
            Object obj = row.getIdentifier();
            if (!(obj instanceof FSDevNode)) continue;
            devs.add((FSDevNode)((Object)obj));
        }
        return devs;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public void setDeviceTable(IsmTable deviceTable) {
        this.deviceTable = deviceTable;
    }

    public JButton getAuthBmcBtn() {
        return this.authBmcBtn;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancleBtn() {
        return this.cancleBtn;
    }

    public boolean isModify() {
        return this.modify;
    }

    public JButton getAuthOsBtn() {
        return this.authOsBtn;
    }

    public JButton getSandboxBtn() {
        return this.sandboxBtn;
    }

    public JButton getBatchImportDeviceBtn() {
        return this.batchImportDeviceBtn;
    }

    public void setBatchImportDeviceBtn(JButton batchImportDeviceBtn) {
        this.batchImportDeviceBtn = batchImportDeviceBtn;
    }

    public JButton getBatchExportDeviceTemplateBtn() {
        return this.batchExportDeviceTemplateBtn;
    }

    public void setBatchExportDeviceTemplateBtn(JButton batchExportDeviceTemplateBtn) {
        this.batchExportDeviceTemplateBtn = batchExportDeviceTemplateBtn;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public void finishedImport(TotalDriverResult totalDriverResult) {
    }

    public void startCheckImportDevice(List<String> serverIpList) {
    }

    public void refreshProcess(TotalDriverResult totalDriverResult) {
    }

    public void dealWithException(String mesage) {
    }

    public void refreshTable(List<AbstractDevice> abstractDevices) {
        JDialog dialog = UpgradeContext.getInstance().getDialog();
        AsyncExcutor.execute((Window)dialog, (boolean)true, (long)0L, (Callable[])new Callable[]{() -> {
            this.waitRefreshFinish(abstractDevices);
            return true;
        }});
    }

    private void waitRefreshFinish(List<AbstractDevice> abstractDevices) {
        List<FSDevNode> selectedNodes = this.getSelectedFsNode();
        ArrayList<FSDevNode> remainNodes = new ArrayList<FSDevNode>(selectedNodes);
        for (AbstractDevice device : abstractDevices) {
            if (ITDeviceType.SERVER_IBMC.equals((Object)device.getItDeviceType())) {
                if (!(device instanceof IBMCDevice)) continue;
                this.updateBmcStatus(selectedNodes, (IBMCDevice)device, remainNodes);
            }
            if (!ITDeviceType.SERVER_OS.equals((Object)device.getItDeviceType()) || !(device instanceof OsDevice)) continue;
            this.updateOsStatus(selectedNodes, (OsDevice)device, remainNodes);
        }
        if (serverType == ITDeviceType.SERVER_OS) {
            remainNodes.stream().forEach(node -> {
                node.setOsAuthState(Constants.NodeAuthState.UNAUTH);
                this.updateTableRowData((FSDevNode)((Object)node));
            });
        } else if (serverType == ITDeviceType.SERVER_IBMC) {
            remainNodes.stream().forEach(node -> {
                node.setBmcAuthState(Constants.NodeAuthState.UNAUTH);
                this.updateTableRowData((FSDevNode)((Object)node));
            });
        }
        this.deviceTable.repaint();
    }

    private void updateOsStatus(List<FSDevNode> selectedNodes, OsDevice device, List<FSDevNode> remainNodes) {
        OsDevice osDevice = device;
        String deviceIp = osDevice.getIp();
        selectedNodes.stream().filter(node -> node.getManagementIP().equals(deviceIp)).findFirst().ifPresent(node -> {
            CommonUtils.serverDevToFsNode(device, node);
            node.setOsAuthState(Constants.NodeAuthState.SUCCESS);
            this.updateTableRowData((FSDevNode)((Object)node));
            remainNodes.remove(node);
        });
    }

    private void updateBmcStatus(List<FSDevNode> selectedNodes, IBMCDevice device, List<FSDevNode> remainNodes) {
        IBMCDevice ibmcDevice = device;
        String deviceIp = ibmcDevice.getIp();
        selectedNodes.stream().filter(node -> node.getBmcIP().equals(deviceIp)).findFirst().ifPresent(node -> {
            CommonUtils.serverDevToFsNode(device, node);
            node.setBmcAuthState(Constants.NodeAuthState.SUCCESS);
            this.updateTableRowData((FSDevNode)((Object)node));
            remainNodes.remove(node);
        });
    }

    public static void setServerType(ITDeviceType serverType) {
        SelectNodeCardLayout.serverType = serverType;
    }

    public void setDpcPrepare(boolean isDpcPrepare) {
        this.isDpcPrepare = isDpcPrepare;
    }

    public boolean isDpcPrepare() {
        return this.isDpcPrepare;
    }
}

