/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.dialog;

import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceAddDialog;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.AddFSDeviceDialogLayout;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import org.slf4j.Logger;

public class AddFSDeviceDialog
extends DeviceAddDialog {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(AddFSDeviceDialog.class);
    private AddFSDeviceDialogLayout layout;
    private Window parent;

    public AddFSDeviceDialog(Window parent, INodeTypeQuery nodeTypeQueryIntf, DeviceAddDialog.InfoTips tips) {
        super(parent, nodeTypeQueryIntf, tips);
        this.parent = parent;
        this.init();
        this.iniListener();
    }

    private void init() {
        Dimension dialogSize = new Dimension(350, 320);
        UiMethod.setComponentSize((Dimension)dialogSize, (Component[])new Component[]{this});
        this.layout = new AddFSDeviceDialogLayout();
        this.setTitle(ResourceUtil.getString((String)"dsfwupgrade.device.adddialog.title"));
        this.add(this.layout);
        super.getMainLayout().setKeyInfoVisible();
        super.getMainLayout().getRootPwCheck().setSelected(false);
        super.getMainLayout().setVisible(false);
        this.getRootPane().setDefaultButton(this.layout.getOkBtn());
        this.pack();
        this.setResizable(false);
        SwingUtil.putScreenCenter((Window)((Object)this));
    }

    private void iniListener() {
        JButton okBtn = this.layout.getOkBtn();
        okBtn.addActionListener(new OkAction());
        this.layout.getCancelBtn().addActionListener(event -> {
            this.setVisible(false);
            this.dispose();
        });
    }

    private void addDevice() {
        if (!this.checkInputField()) {
            return;
        }
        super.getMainLayout().getIpAddress().setText(this.layout.getFloatIpAddrField().getText());
        String username = this.layout.getFloatUserNameField().getText();
        String password = String.valueOf(this.layout.getFloatPwdField().getPassword());
        super.getMainLayout().getUsername().setText(username);
        super.getMainLayout().getPassword().setText(password);
        super.getMainLayout().getYesAndNoButtonPanel().setSelectedYes(this.layout.getYesAndNoButtonPanel().isSelectedYes());
        this.processAdd();
    }

    private boolean checkInputField() {
        String ipAddress = this.layout.getFloatIpAddrField().getText();
        if (StringUtils.hasNULLStr((String[])new String[]{ipAddress})) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"dsfwupgrade.device.adddialog.deviceinfoipblank"));
            return false;
        }
        if (!NetUtil.isValidIP((String)ipAddress)) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"dsfwupgrade.device.adddialog.ipaddresserror"));
            return false;
        }
        String username = this.layout.getFloatUserNameField().getText();
        String password = String.valueOf(this.layout.getFloatPwdField().getPassword());
        boolean hasNull = StringUtils.hasNULLStr((String[])new String[]{username, password});
        if (hasNull) {
            DialogUtils.showInfoDialog((JDialog)((Object)this), (String)ResourceUtil.getString((String)"dsfwupgrade.device.adddialog.deviceinfoblank"));
            return false;
        }
        return true;
    }

    private class OkAction
    implements ActionListener {
        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AddFSDeviceDialog.this.addDevice();
        }
    }
}

