/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.dialog;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicecenter.context.DeviceCenterContext;
import com.huawei.ism.tool.distributedfwupg.action.SelectNodesConfirm;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectNodeCardLayout;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.SwingUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyUpgradeConfigDialog
extends JDialog {
    private static final Logger log = LoggerFactory.getLogger(ModifyUpgradeConfigDialog.class);
    private static final Dimension DIALOG_SIZE = new Dimension(800, 550);
    private final FSClusterDevice fsClusterDevice;
    private SelectNodeCardLayout cardLayout = null;

    public ModifyUpgradeConfigDialog(JDialog mainDialog, FSClusterDevice fsClusterDevice) {
        super((Dialog)mainDialog, true);
        this.fsClusterDevice = fsClusterDevice;
        this.init();
        this.initListener();
        ArrayList<SelectNodeCardLayout> importListener = new ArrayList<SelectNodeCardLayout>();
        importListener.add(this.cardLayout);
        DeviceCenterContext.getInstance().getDeviceTables().put("deviceTables", importListener);
    }

    private void init() {
        UiMethod.setComponentSize((Dimension)DIALOG_SIZE, (Component[])new Component[]{this});
        this.cardLayout = new SelectNodeCardLayout(true, this.fsClusterDevice.needOSAuth(), this.fsClusterDevice.needBMCAuth(), CommonUtils.isDpcPrepare(this.fsClusterDevice.getFsDevNodeList()));
        this.setTitle(ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.modify"));
        this.add(UiMethod.buildFrameSpace((JComponent)this.cardLayout, (int)12));
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        if (Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(UpgradeContext.getInstance().getUpgradeScene())) {
            this.initTableData4ComputeNode();
        } else {
            this.initTableData();
        }
    }

    private void initTableData4ComputeNode() {
        final List fsDevNodeList = this.fsClusterDevice.getFsDevNodeList().stream().filter(FSDevNode::isPureComputeNode).collect(Collectors.toList());
        AsyncExcutor.execute((Window)this, (boolean)true, (long)0L, (Callable[])new Callable[]{new Callable<Boolean>(){

            @Override
            public Boolean call() {
                ModifyUpgradeConfigDialog.this.cardLayout.createRowForBatch(fsDevNodeList, ModifyUpgradeConfigDialog.this.fsClusterDevice);
                return true;
            }
        }});
    }

    private void initTableData() {
        List<FSDevNode> fsDevNodeList = this.fsClusterDevice.getFsDevNodeList();
        fsDevNodeList.stream().filter(node -> !node.isPureComputeNode()).forEach(this.cardLayout::createRow);
    }

    private void initListener() {
        this.cardLayout.bindListener(this, this.fsClusterDevice.needOSAuth(), this.fsClusterDevice);
        this.cardLayout.getOkBtn().addActionListener(event -> {
            SelectNodesConfirm confirmAction = new SelectNodesConfirm(this.cardLayout, this.fsClusterDevice);
            if (confirmAction.doConfirm()) {
                this.dispose();
            }
        });
        this.cardLayout.getCancleBtn().addActionListener(event -> this.dispose());
    }
}

