/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.dialog;

import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.devicemanager.ui.former.XmlFormer;
import com.huawei.ism.tool.devicemanager.ui.listener.DirSetupButtonListener;
import com.huawei.ism.tool.devicemanager.ui.listener.ScenePreparedMainJDialogListener;
import com.huawei.ism.tool.distributedfwupg.action.AddDeviceAction;
import com.huawei.ism.tool.distributedfwupg.action.QueryDeviceAction;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.observer.IUpdateUIObserver;
import com.huawei.ism.tool.distributedfwupg.service.IscsiServiceReset;
import com.huawei.ism.tool.distributedfwupg.ui.card.SelectDeviceCard;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.ModifyUpgradeConfigDialog;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.SceneSettingDialogLayout;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.SupportProductDialog;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.FSClusterDevManager;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SwingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.plaf.RootPaneUI;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class SceneSettingDialog
extends JDialog
implements IHelpActionCallBack {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneSettingDialog.class);
    private static final Dimension WIZARD_SIZE_1100X685 = new Dimension(1100, 585);
    private SceneSettingDialogLayout dialogLayout;
    private transient DeviceTableAction deviceTableAction;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();

    public SceneSettingDialog(Window parentFrame) {
        super(parentFrame);
        this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
        this.initUI();
        this.initData();
        UpgradeContext.getInstance().setUiObserver(new UpdateUIObserver());
        this.addListener();
    }

    private void initUI() {
        UiMethod.setComponentSize((Dimension)WIZARD_SIZE_1100X685, (Component[])new Component[]{this});
        this.dialogLayout = new SceneSettingDialogLayout();
        this.deviceTableAction = new DeviceTableAction();
        this.add(this.dialogLayout);
        this.setTitle(ResourceUtil.getString((String)"dsfwupgrade.scene.title"));
        this.setModal(true);
        this.validate();
        this.pack();
        this.setDefaultCloseOperation(0);
        SwingUtil.putScreenCenter((Window)this);
        this.setIconImage(ResourceUtil.getImage((String)"DistributedFWUpgItem.png").getImage());
    }

    private void initData() {
        FSClusterDevManager.getInstance().clearData();
        List<FSClusterDevice> fsClusterDevices = CommonUtils.transJson2FSCluster();
        if (fsClusterDevices == null) {
            LOGGER.error("json file to fsCluster is null");
            return;
        }
        this.removeUnSupportDevFromToolbox();
        this.appendDevFromToolbox(fsClusterDevices);
        for (FSClusterDevice fsClusterDevice : fsClusterDevices) {
            this.deviceTableAction.addDevNodeToTable(fsClusterDevice);
        }
        FSClusterDevManager.getInstance().setTableFsClusterDevs(fsClusterDevices);
    }

    private void appendDevFromToolbox(List<FSClusterDevice> devs) {
        List devsInDeviceManager = DefaultNodeProviderImpl.getInstance().getNodeList();
        List ips = devs.stream().map(FSClusterDevice::getFloatIp).collect(Collectors.toList());
        QueryDeviceAction support = new QueryDeviceAction(null);
        List supportDevFromToolbox = devsInDeviceManager.stream().filter(dev -> support.isNodeSupport(EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)dev))).filter(dev -> !ips.contains(dev.getIp())).map(FSClusterDevice::new).collect(Collectors.toList());
        LOGGER.info("Load dev from toolbox : {}", supportDevFromToolbox);
        devs.addAll(supportDevFromToolbox);
    }

    private void removeUnSupportDevFromToolbox() {
        DefaultNodeProviderImpl devProvider = DefaultNodeProviderImpl.getInstance();
        List devsInDeviceManager = devProvider.getNodeList();
        QueryDeviceAction support = new QueryDeviceAction(null);
        devsInDeviceManager.stream().filter(dev -> !support.isNodeSupport(EntityUtils.toNewDev((com.huawei.ism.tool.obase.entity.DevNode)dev))).forEach(dev -> {
            try {
                devProvider.removeNode(dev);
            }
            catch (com.huawei.ism.tool.obase.exception.ToolException e) {
                LOGGER.error("Remove dev from pool error.", (Throwable)e);
            }
        });
    }

    private void addListener() {
        this.addWindowListener((WindowListener)new ScenePreparedMainJDialogListener(this){

            public void okCallback() {
                UpgradeContext.getInstance().fireToolStopped();
            }

            public void cancelCallback() {
                SceneSettingDialog.this.setDefaultCloseOperation(0);
            }
        });
        this.dialogLayout.getSupportProductLink().addClickListener((ToolHyperLinkLabel.ClickListener)new QuerySupportProductAction());
        this.dialogLayout.getAddDeviceBtn().addActionListener(new AddDeviceAction());
        this.dialogLayout.getOkBtn().addActionListener(new SaveDevice2JsonListener());
        this.dialogLayout.getCancleBtn().addActionListener(event -> {
            UpgradeContext.getInstance().fireToolStopped();
            this.dispose();
            LOGGER.info("Scene Setting exit.");
        });
        this.dialogLayout.getSetPathButton().addActionListener((ActionListener)new DirSetupButtonListener(this, this.dialogLayout.getSavePathText().getText()){

            public void callback(String path) {
                SceneSettingDialog.this.dialogLayout.getSavePathText().setText(path);
                SceneSettingDialog.this.dialogLayout.getSavePathText().setToolTipText(path);
                ApplicationContext.getInstance().setFilePath(path);
            }
        });
        this.rootPaneUI.setHelpActionCallBack((IHelpActionCallBack)this);
    }

    public void doHelpActionWork() {
        String name = "BundleUpgrade";
        if (UpgradeContext.getInstance().isComputeUpgradeScene()) {
            name = "ComputeUpgrade";
        }
        FileUtils.openHelpFile((String)name, (Window)this, (String)".chm");
    }

    public String getListenerName() {
        return "HelpTitleDialog:" + this.getClass().getSimpleName();
    }

    private void writeDev2SceneDeviceList(List<DevNode> newDevs) {
        XmlFormer xmlFormer = new XmlFormer();
        List listMap = xmlFormer.injectDeviceData(newDevs);
        SceneXmlData.getInstance().writeDevData2File(newDevs, listMap);
    }

    public class UpdateUIObserver
    implements IUpdateUIObserver {
        @Override
        public List<FSClusterDevice> getAllDev() {
            return SceneSettingDialog.this.deviceTableAction.getAllDev();
        }

        @Override
        public void addUpgradeDev2Table(FSClusterDevice dev) {
            SceneSettingDialog.this.deviceTableAction.addDevNodeToTable(dev);
        }

        @Override
        public List<FSClusterDevice> getSelectedDev() {
            return SceneSettingDialog.this.dialogLayout.getSelectDevs();
        }

        @Override
        public void updateDev2Table(FSClusterDevice dev) {
            SceneSettingDialog.this.deviceTableAction.updateTableRow(dev);
        }
    }

    public class DeviceTableAction {
        private IsmTable deviceTable;
        private TableModel modelObj;
        private DefaultTableModel tableModel;

        public DeviceTableAction() {
            this.deviceTable = SceneSettingDialog.this.dialogLayout.getDeviceTable();
            this.modelObj = this.deviceTable.getModel();
            if (this.modelObj instanceof DefaultTableModel) {
                this.tableModel = (DefaultTableModel)this.modelObj;
            }
        }

        private void tableRowRender(TableRow row, FSClusterDevice upgradeDev) {
            int colNum = 0;
            row.setValueAt(colNum++, (Object)upgradeDev.getProductName());
            row.setValueAt(colNum++, (Object)upgradeDev.getProductModel());
            row.setValueAt(colNum++, (Object)upgradeDev.getFloatIp());
            row.setValueAt(colNum++, (Object)upgradeDev.getSn());
            row.setValueAt(colNum++, (Object)upgradeDev.getProductVersion());
            row.setValueAt(colNum++, (Object)upgradeDev.getLoginUser().getUserName());
            row.setValueAt(colNum, (Object)this.upgradeSetColumnRender(upgradeDev));
        }

        private IsmTableCell.HyperlinkCell upgradeSetColumnRender(FSClusterDevice upgradeDevNode) {
            return new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.modify"), (ActionListener)new ModifyConfigActionListener(upgradeDevNode));
        }

        public void createTableRow(FSClusterDevice fsClusterDevice) {
            DefaultTableRow row = new DefaultTableRow(this.tableModel.getAllColumnCount(), (Object)fsClusterDevice, (Object)fsClusterDevice);
            this.tableRowRender((TableRow)row, fsClusterDevice);
            this.tableModel.addRow(new TableRow[]{row});
        }

        public void updateTableRow(FSClusterDevice fsClusterDevice) {
            TableRow row = this.tableModel.getTableRowBy((Object)fsClusterDevice);
            this.tableRowRender(row, fsClusterDevice);
            this.deviceTable.repaint();
        }

        public void addDevNodeToTable(FSClusterDevice devNodeInfo) {
            this.createTableRow(devNodeInfo);
            if (devNodeInfo.isSelected()) {
                int rowNum = this.deviceTable.getRowCount() - 1;
                this.deviceTable.addRowSelectionInterval(rowNum, rowNum);
            }
        }

        public List<FSClusterDevice> getAllDev() {
            ArrayList<FSClusterDevice> devs = new ArrayList<FSClusterDevice>();
            List rows = this.deviceTable.getAllRows();
            for (TableRow row : rows) {
                Object obj = row.getUserObject();
                if (!(obj instanceof FSClusterDevice)) continue;
                devs.add((FSClusterDevice)obj);
            }
            return devs;
        }

        private class ModifyConfigActionListener
        implements ActionListener {
            private FSClusterDevice upgradeDevNode;

            public ModifyConfigActionListener(FSClusterDevice upgradeDevNode) {
                this.upgradeDevNode = upgradeDevNode;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog mainDialog = UpgradeContext.getInstance().getMainDialog();
                if (!this.initClusterNode()) {
                    return;
                }
                ModifyUpgradeConfigDialog modifyDialog = new ModifyUpgradeConfigDialog(mainDialog, this.upgradeDevNode);
                UpgradeContext.getInstance().setDialog(modifyDialog);
                modifyDialog.setVisible(true);
            }

            private boolean initClusterNode() {
                List<FSDevNode> fsdNodeList;
                if (this.upgradeDevNode.isInitialized()) {
                    return true;
                }
                com.huawei.ism.tool.obase.entity.DevNode node = this.upgradeDevNode.createDevNodeByClusterDevice();
                if (UpgradeCustomizationUtil.isSupportBatchDpcUpgradeDevice(node, fsdNodeList = SelectDeviceCard.queryFsDevNodeInfo(SceneSettingDialog.this, node))) {
                    LOGGER.info("Scale-Out Storage Batch Upgrade is recommended for the current device {}.", (Object)node.getIp());
                    DialogUtils.showInfoDialog((JDialog)SceneSettingDialog.this, (String)UpgradeCustomizationUtil.getDpcTipToShow(node));
                    return false;
                }
                if (!SelectDeviceCard.checkNodeServer(node, fsdNodeList)) {
                    return false;
                }
                this.setInnerFloatIp(fsdNodeList);
                this.upgradeDevNode.setInitialized(true);
                this.upgradeDevNode.setFsDevNodeList(fsdNodeList);
                return true;
            }

            private void setInnerFloatIp(List<FSDevNode> fsDevNodes) {
                fsDevNodes.stream().filter(FSDevNode::isFsmNode).findFirst().ifPresent(node -> this.upgradeDevNode.setInnerFloatIp(node.getManagementInnerFloatIp()));
            }
        }
    }

    private class SaveDevice2JsonListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog dialog = UpgradeContext.getInstance().getMainDialog();
            AsyncExcutor.execute((Window)dialog, (boolean)true, (long)0L, (Callable[])new Callable[]{new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    SaveDevice2JsonListener.this.saveAndExit();
                    return true;
                }
            }});
        }

        private void saveAndExit() {
            LOGGER.info("start save device to json action.");
            if (!this.saveClusterInfo()) {
                return;
            }
            try {
                if (Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(UpgradeContext.getInstance().getUpgradeScene())) {
                    this.callComputeNodeSceneInfo();
                } else {
                    CommonUtils.finishedSceneTask();
                }
            }
            catch (Exception ex) {
                LOGGER.info("Exit error.", (Throwable)ex);
            }
            finally {
                SceneSettingDialog.this.dispose();
                UpgradeContext.getInstance().fireToolStopped();
            }
        }

        private void callComputeNodeSceneInfo() throws ToolException {
            ArrayList resultList = new ArrayList();
            SceneSettingDialog.this.dialogLayout.getSelectDevs().get(0).getFsDevNodeList().stream().filter(FSDevNode::isSelected).forEach(node -> {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("SN", node.getSerialNumber());
                data.put("IP", node.getIp());
                data.put("status", TaskResult.Result.SUCCESS.toString());
                data.put("toolId", "SceneSetting");
                resultList.add(data);
            });
            TaskResult result = SceneEnvironmentImpl.getInstance().finishedSceneTask(resultList);
            LOGGER.info("Call back scene info result {}.", (Object)result.isTaskSuccess());
        }

        private boolean saveClusterInfo() {
            List allDevice = SceneSettingDialog.this.dialogLayout.getDeviceTable().getAllRows();
            List selectDevice = SceneSettingDialog.this.dialogLayout.getDeviceTable().getMarkedRows();
            if (selectDevice.isEmpty()) {
                LOGGER.info("Select dev is empty.");
                DialogUtils.showInfoDialog((JDialog)SceneSettingDialog.this, (String)ResourceUtil.getString((String)"dsfwupgrade.scene.selectnodevice"));
                return false;
            }
            List<FSClusterDevice> devices = allDevice.stream().map(row -> (FSClusterDevice)row.getIdentifier()).collect(Collectors.toList());
            List selectDeviceFloatIpList = selectDevice.stream().map(row -> ((FSClusterDevice)row.getIdentifier()).getFloatIp()).collect(Collectors.toList());
            devices.forEach(device -> device.setSelected(selectDeviceFloatIpList.contains(device.getFloatIp())));
            if (devices.stream().filter(FSClusterDevice::isSelected).anyMatch(dev -> !dev.isInitialized() || dev.getFsDevNodeList().stream().noneMatch(FSDevNode::isSelected))) {
                LOGGER.info("Select node is empty.");
                DialogUtils.showInfoDialog((JDialog)SceneSettingDialog.this, (String)ResourceUtil.getString((String)"dsfwupgrade.wizard.select.no.node.tip"));
                return false;
            }
            if (Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(UpgradeContext.getInstance().getUpgradeScene())) {
                IscsiServiceReset checker = new IscsiServiceReset();
                devices.stream().filter(FSClusterDevice::isSelected).forEach(cluster -> {
                    List<FSDevNode> nodeList = cluster.getFsDevNodeList().stream().filter(FSDevNode::isSelected).collect(Collectors.toList());
                    checker.check(cluster.createDevNodeByClusterDevice(), nodeList);
                });
            }
            this.saveDistributedFirmwareUpgradeDevNode(selectDevice);
            CommonUtils.saveDevice2File(devices);
            return true;
        }

        private void saveDistributedFirmwareUpgradeDevNode(List<TableRow> tableRows) {
            List newDevs = tableRows.stream().map(TableRow::getUserObject).filter(object -> object instanceof FSClusterDevice).map(FSClusterDevice.class::cast).map(FSClusterDevice::createDevNodeByClusterDevice).map(EntityUtils::toNewDev).collect(Collectors.toList());
            SceneSettingDialog.this.writeDev2SceneDeviceList(newDevs);
        }
    }

    private class QuerySupportProductAction
    extends ToolHyperLinkLabel.ClickAdapter {
        private QuerySupportProductAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JDialog mainDialog = UpgradeContext.getInstance().getMainDialog();
            SupportProductDialog supportDialog = new SupportProductDialog(mainDialog);
            supportDialog.setVisible(true);
        }
    }
}

