/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.dialog;

import com.huawei.ism.tool.devicemanager.utils.UIUtils;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneSettingDialogLayout
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(SceneSettingDialogLayout.class);
    public static final int MAX_CONTENT_LENGTH = 90;
    public static final int TEXT_BOX_LENGTH = 25;
    private static final Dimension DEFAULT_SIZE = new Dimension(950, 350);
    private JButton addDeviceBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.scene.btnbox.adddevice"), (char)'A');
    private JComponent suggesstion = new JLabel(ResourceUtil.getString((String)"dsfwupgrade.scene.suggesstion"));
    private ToolHyperLinkLabel supportProductLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"dsfwupgrade.scene.supportProduct"));
    private IsmTable deviceTable = null;
    private DefaultTableModel deviceTableModel = null;
    private String[] tableHeaders = new String[]{ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.devname"), ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.productmodel"), ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.ipaddress"), ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.devicesn"), ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.devversion"), ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.username"), ResourceUtil.getString((String)"dsfwupgrade.scene.devicetable.upgradeset")};
    private IsmTextField savePathText = null;
    private JComponent savePathLabel = UIUtils.createRequiredLabel((String)ResourceUtil.getString((String)"scene.collectpath"), (boolean)true);
    private JButton setPathButton = UiMethod.createButton((String)ResourceUtil.getString((String)"scene.button.setup"), (char)'A');
    private JButton cancleBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.scene.button.cancel"), (char)'C');
    private JButton okBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"dsfwupgrade.scene.button.ok"), (char)'L');

    public SceneSettingDialogLayout() {
        this.initComponent();
        this.layoutComponents();
    }

    private void initComponent() {
        this.createDeviceTable();
        this.creatSavePathField();
    }

    private void createDeviceTable() {
        this.setDeviceTableModel(new DefaultTableModel(this.tableHeaders, new int[0]));
        this.setDeviceTable(new IsmTable((TableModel)this.getDeviceTableModel(), false));
    }

    private void creatSavePathField() {
        String userPath = new File(UpgradeContext.getInstance().getSceneCollectDir()).getParent();
        if (StringUtils.isNULLStr((String)userPath)) {
            userPath = FileUtils.getDefaultDirectory().getAbsolutePath();
        }
        this.savePathText = IsmTextField.getNameTextField((String)".*", (String)userPath, (int)90, (int)25, (boolean)true);
        this.savePathText.setToolTipText(userPath);
        this.savePathText.setEditable(false);
    }

    private void layoutComponents() {
        JComponent descriptionArea = this.layoutDescriptionArea();
        JComponent tableArea = this.layoutTableArea();
        JComponent collectPathArea = this.layoutCollectArea();
        JComponent buttonArea = this.layoutButtonArea();
        JComponent contentArea = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionArea}), UCD.buildHorizotalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalGlue()}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{tableArea})}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{collectPathArea}), buttonArea});
        this.setLayout(new BorderLayout());
        this.add(this.buildFrameSpace(contentArea, 20, 30, 15, 35));
    }

    private JComponent layoutDescriptionArea() {
        JLabel sugg1 = new JLabel(ResourceUtil.getString((String)"dsfwupgrade.scene.suggesstion1"));
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.suggesstion, this.supportProductLink, sugg1}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.addDeviceBtn})});
        return view;
    }

    private JComponent layoutTableArea() {
        TableScrollPane pane = TableScrollPane.createTablePaneWithOutFilter((IsmTable)this.getDeviceTable(), (boolean)false);
        pane.setPreferredSize(DEFAULT_SIZE);
        return pane;
    }

    private JComponent layoutCollectArea() {
        JPanel collectPathArea = new JPanel();
        collectPathArea.setLayout(new GridBagLayout());
        GridBagConstraints constraints = this.buildConstraints();
        this.initPathAreaLayout(collectPathArea, constraints);
        return collectPathArea;
    }

    private void initPathAreaLayout(JPanel collectPathArea, GridBagConstraints constraints) {
        collectPathArea.add((Component)this.savePathLabel, constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 10, 0, 0);
        collectPathArea.add((Component)this.getSavePathText(), constraints);
        ++constraints.gridx;
        constraints.insets = new Insets(0, 5, 0, 0);
        collectPathArea.add((Component)this.getSetPathButton(), constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        collectPathArea.add((Component)new JLabel(), constraints);
    }

    @NotNull
    private GridBagConstraints buildConstraints() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        return constraints;
    }

    private JComponent buildFrameSpace(JComponent contentArea, int left, int right, int up, int down) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(left));
        hBox.add(contentArea);
        hBox.add(Box.createHorizontalStrut(right));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(up));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(down));
        return vBox;
    }

    private JComponent layoutButtonArea() {
        JComponent bottomBtnArea = UiMethod.buildCompsRight((Component[])new Component[]{this.okBtn, this.cancleBtn});
        return bottomBtnArea;
    }

    public List<FSClusterDevice> getSelectDevs() {
        int[] selectRows;
        ArrayList<FSClusterDevice> devs = new ArrayList<FSClusterDevice>();
        for (int selectRow : selectRows = this.deviceTable.getSelectedRows()) {
            if (-1 == selectRow) {
                return devs;
            }
            TableRow row = this.deviceTableModel.getRow(selectRow = this.deviceTable.convertRowIndexToModel(selectRow));
            Object rowData = row.getIdentifier();
            if (!(rowData instanceof FSClusterDevice)) continue;
            devs.add((FSClusterDevice)rowData);
        }
        return devs;
    }

    public JButton getCancleBtn() {
        return this.cancleBtn;
    }

    public void setCancleBtn(JButton cancleBtn) {
        this.cancleBtn = cancleBtn;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public void setOkBtn(JButton okBtn) {
        this.okBtn = okBtn;
    }

    public void setAddDeviceLabel(ToolHyperLinkLabel addDeviceLabel) {
        this.addDeviceBtn = this.addDeviceBtn;
    }

    public void setDeviceTable(IsmTable deviceTable) {
        this.deviceTable = deviceTable;
    }

    public void setDeviceTableModel(DefaultTableModel deviceTableModel) {
        this.deviceTableModel = deviceTableModel;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public JButton getAddDeviceBtn() {
        return this.addDeviceBtn;
    }

    public IsmTable getDeviceTable() {
        return this.deviceTable;
    }

    public ToolHyperLinkLabel getSupportProductLink() {
        return this.supportProductLink;
    }

    public void setSupportProductLink(ToolHyperLinkLabel supportProductLink) {
        this.supportProductLink = supportProductLink;
    }

    public void setSavePathText(IsmTextField savePathText) {
        this.savePathText = savePathText;
    }

    public IsmTextField getSavePathText() {
        return this.savePathText;
    }

    public void setSavePathLabel(JComponent savePathLabel) {
        this.savePathLabel = savePathLabel;
    }

    public JComponent getSavePathLabel() {
        return this.savePathLabel;
    }

    public void setSetPathButton(JButton setPathButton) {
        this.setPathButton = setPathButton;
    }

    public JButton getSetPathButton() {
        return this.setPathButton;
    }
}

