/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.dialog;

import com.huawei.bundleupgrade.actions.ReportComputeNodeAction;
import com.huawei.bundleupgrade.entity.ComputeNodeUpgradeResult;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.distributedfwupg.action.ComputeNodeOfflineUpgradeAction;
import com.huawei.ism.tool.distributedfwupg.action.ComputeNodeRetryAllAction;
import com.huawei.ism.tool.distributedfwupg.action.ComputeNodeRollbackAllAction;
import com.huawei.ism.tool.distributedfwupg.action.ComputeNodeUpgradeAction;
import com.huawei.ism.tool.distributedfwupg.action.ComputeNodeUpgradePrepareAction;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.entity.UpdateType;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeFlowService;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.ui.dialog.UpgradeComputeNodeLayout;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.plaf.RootPaneUI;
import org.slf4j.Logger;

public class UpgradeComputeNodeDialog
extends JDialog
implements IHelpActionCallBack {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UpgradeComputeNodeDialog.class);
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private static final Dimension WIZARD_SIZE_1100X685 = new Dimension(1100, 585);
    private UpgradeComputeNodeLayout dialogLayout;
    private ComputeNodeUpgradeAction upgradeAction;
    private Window dialogHandler;
    private boolean supportOffline = true;

    public UpgradeComputeNodeDialog(Window parentFrame) {
        super(parentFrame);
        try {
            this.dialogHandler = this;
            this.setDefaultCloseOperation(0);
            this.getRootPane().setUI((RootPaneUI)this.rootPaneUI);
            this.initUI();
            this.addListener();
        }
        catch (Exception e) {
            LOGGER.error("init UpgradeComputeNodeDialog error: ", (Throwable)e);
        }
    }

    private void initUI() {
        UiMethod.setComponentSize((Dimension)WIZARD_SIZE_1100X685, (Component[])new Component[]{this});
        this.dialogLayout = new UpgradeComputeNodeLayout();
        this.add(this.dialogLayout);
        this.setTitle(ResourceUtil.getString((String)"upgrade.compute.node.dialog.title"));
        this.setModal(true);
        this.validate();
        this.pack();
        SwingUtil.putScreenCenter((Window)this);
        this.setIconImage(ResourceUtil.getImage((String)"DistributedFWUpgItem.png").getImage());
        Constants.RUNNING_IMG.setImageObserver(this);
    }

    public Boolean initData() {
        try {
            String fileName = FsUpgradeService.getLocalUpgradeBatchIdFile();
            List<String> vbsIpList = FsUpgradeService.getVbsMasterNodeIp();
            List<FSDevNode> devNodes = FsUpgradeService.getNodeForComputeOnly(vbsIpList);
            this.refreshAllVersionData(devNodes);
            this.dialogLayout.resetTotalNum(devNodes.size());
            if (StringUtils.isNULLStr((String)fileName)) {
                LOGGER.info("ComputeNode new upgrade progress.");
                devNodes.forEach(this.dialogLayout::addDeviceTableRow);
            } else {
                LOGGER.info("ComputeNode recover upgrade progress, batchId: {}", (Object)fileName);
                UpgradeContext.getInstance().setBatchId(fileName);
                FsUpgradeService.setNodeStatusMap(FsUpgradeService.parseLocalUpgradeBatchIdFile(fileName));
                FsUpgradeService.setInitDateFromJson(true);
                this.updateFsNodeInfoAndComputeResult(devNodes, CommonUtils.transJson2ComputeNodeUpgradeResult());
                FsUpgradeFlowService.setUpdateType(UpdateType.of(FsUpgradeService.getNodeStatusMap().get(Constants.UPDATE_TYPE), UpdateType.DEFAULT));
                this.dialogLayout.setCurrentUpgradeType(FsUpgradeFlowService.getUpdateType().getTypeDesc());
                this.recoverLayout(devNodes);
                this.upgradeAction.recoverProgress();
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("Init data error.", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    private void updateFsNodeInfoAndComputeResult(List<FSDevNode> devNodes, ComputeNodeUpgradeResult computeNodeUpgradeResult) {
        for (FSDevNode node : devNodes) {
            node.setUpgradeStatus(FsUpgradeService.getNodeStatusMap().get(node.getManagementIP()));
            node.setComputeNodeUpgradeResult(computeNodeUpgradeResult.getFsDevNodes().stream().filter(fsNode -> Objects.equals(fsNode.getManagementIP(), node.getManagementIP())).findFirst().orElse(new FSDevNode()).getComputeNodeUpgradeResult());
            this.dialogLayout.addDeviceTableRow(node);
        }
        computeNodeUpgradeResult.setFsDevNodes(devNodes);
        FsUpgradeService.setComputeNodeUpgradeResult(computeNodeUpgradeResult);
    }

    private void recoverLayout(List<FSDevNode> devNodes) {
        this.dialogLayout.coverRetryBtn();
        this.dialogLayout.coverRollbackBtn();
        this.dialogLayout.coverUpgradeBth();
        this.dialogLayout.coverOfflineUpgradeBth();
        this.dialogLayout.resetSuccessNum((int)devNodes.stream().filter(node -> node.getUpgradeStatus().isSuccessStatus()).count());
        this.dialogLayout.resetFailedNum((int)devNodes.stream().filter(node -> node.isUpgradeFailed() || node.isRollbackStatus()).count());
        this.dialogLayout.resetRollbackSuccessNum((int)devNodes.stream().filter(FSDevNode::isRollbackSucceeded).count());
        this.dialogLayout.resetRollbackFailedNum((int)devNodes.stream().filter(FSDevNode::isRollbackFailed).count());
        this.dialogLayout.resetPullPkgFailedNum((int)devNodes.stream().filter(fsDevNode -> fsDevNode.getUpgradeStatus().isUpgradePrepareFailedStatus()).count());
        this.dialogLayout.resetPullPkgSuccessNum(CommonUtils.countPullPkgSuccess(devNodes));
        this.dialogLayout.enableUpgrade(false);
    }

    public void allButtonDimmed() {
        this.dialogLayout.allButtonDimmed();
    }

    private void refreshAllVersionData(List<FSDevNode> devNodes) {
        FSDevNode node;
        String targetVersion = FsUpgradeService.getTargetVersion();
        String currentVersion = "";
        Iterator<FSDevNode> iterator = devNodes.iterator();
        while (iterator.hasNext() && StringUtils.isNULLStr((String)(currentVersion = FsUpgradeService.queryUpgradeCurrentVersion(node = iterator.next())))) {
        }
        if (StringUtils.isNULLStr((String)currentVersion)) {
            LOGGER.error("can not get all node current version");
            return;
        }
        if (UpgradeContext.getInstance().isDpcUpgrade()) {
            FsUpgradeService.refreshDpcVersions(devNodes);
            return;
        }
        for (FSDevNode devNode : devNodes) {
            devNode.setOldVersion(currentVersion);
            devNode.setCurrentVersion(currentVersion);
            devNode.setTargetVersion(targetVersion);
        }
    }

    private boolean isSupportOffline(String finalCurrentVersion, String targetVersion) {
        String offlineNotSupport = ResourceUtil.getString((String)"upgrade.compute.node.dpc.offline.notsupport");
        return Arrays.stream(offlineNotSupport.split(";")).noneMatch(notSupportOfflineVersion -> finalCurrentVersion.contains((CharSequence)notSupportOfflineVersion) && targetVersion.contains((CharSequence)notSupportOfflineVersion));
    }

    private void addListener() {
        this.upgradeAction = new ComputeNodeUpgradeAction(this);
        this.dialogLayout.getUpgradeBtn().addActionListener(this.upgradeAction);
        this.dialogLayout.getOfflineUpgradeBtn().addActionListener(new ComputeNodeOfflineUpgradeAction(this));
        this.dialogLayout.getUpgradePrepare().addActionListener(new ComputeNodeUpgradePrepareAction(this));
        this.dialogLayout.getExportReport().addActionListener(new ReportComputeNodeAction(this));
        this.dialogLayout.getRetryAllBtn().addActionListener(new ComputeNodeRetryAllAction(this.dialogLayout));
        this.dialogLayout.getRollbackAllBtn().addActionListener(new ComputeNodeRollbackAllAction(this.dialogLayout));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                UpgradeComputeNodeDialog.this.exitTool();
            }
        });
        this.rootPaneUI.setHelpActionCallBack((IHelpActionCallBack)this);
    }

    private void exitTool() {
        LOGGER.info("Try to exit tool.");
        if (!this.dialogLayout.isAllRowsSucceeded() && DialogUtils.showYesNoDialog((Window)this.dialogHandler, (String)ResourceUtil.getString((String)"upgrade.compute.node.dialog.pop.exit")).getValue() != 0) {
            LOGGER.info("Cancels exit tool");
            return;
        }
        CommonUtils.computeNodeUpgradeResult2Json(FsUpgradeService.getComputeNodeUpgradeResult());
        try {
            String batchId = UpgradeContext.getInstance().getBatchId();
            FsUpgradeService.writeNodeStatusToFile(FsUpgradeService.getNodeStatusMap(), batchId);
            this.dialogHandler.dispose();
            this.callBackSceneInfo();
        }
        catch (Exception e) {
            LOGGER.error("Some error happend.", (Throwable)e);
        }
        finally {
            LOGGER.info("Close tool!");
            Runtime.getRuntime().halt(0);
        }
    }

    private void callBackSceneInfo() throws ToolException {
        List finishedNodes = this.dialogLayout.getAllNodes().stream().filter(FSDevNode::isFinished).collect(Collectors.toList());
        if (finishedNodes.isEmpty()) {
            return;
        }
        ArrayList resultList = new ArrayList();
        finishedNodes.stream().forEach(node -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("SN", node.getSerialNumber());
            data.put("IP", node.getManagementIP());
            data.put("status", node.isFailed() || node.isRollbackStatus() ? TaskResult.Result.FAILED.toString() : TaskResult.Result.SUCCESS.toString());
            data.put("toolId", "DistributedFWUpgrade");
            resultList.add(data);
        });
        TaskResult result = SceneEnvironmentImpl.getInstance().finishedSceneTask(resultList);
        LOGGER.info("Call back scene info result {}.", (Object)result.isTaskSuccess());
    }

    private void clearEnv() {
        AsyncExcutor.execute((Window)this, (String)ResourceUtil.getString((String)"upgrade.compute.node.dialog.clear"), (int)220, (Callable[])new Callable[]{() -> {
            FsUpgradeService.clearNodeAndLocal(this.getSuccessNodes());
            return true;
        }});
    }

    private List<FSDevNode> getSuccessNodes() {
        return this.dialogLayout.getAllNodes().stream().filter(dev -> dev.hasUpload() && dev.getUpgradeStatus() == Constants.NodeUpgradeState.SUCCEEDED).collect(Collectors.toList());
    }

    public void doHelpActionWork() {
        FileUtils.openHelpFile((String)"ComputeUpgrade", (Window)this, (String)".chm");
    }

    public String getListenerName() {
        return "HelpTitleDialog:" + this.getClass().getSimpleName();
    }

    public void setUpgradeEnableSpecialScene(List<String> currentVersions) {
        String targetVersion = FsUpgradeService.getUpgradeTargetVersion();
        String[] onlineNotSupport = ResourceUtil.getString((String)"upgrade.compute.node.dpc.online.notsupport").split(";");
        for (String currentVersion : currentVersions) {
            boolean isSupport = Arrays.stream(onlineNotSupport).noneMatch(currentVersion::contains);
            if (this.dialogLayout.getUpgradeBtn().isEnabled()) {
                this.dialogLayout.getUpgradeBtn().setEnabled(isSupport);
            }
            this.supportOffline = this.isSupportOffline(currentVersion, targetVersion);
        }
    }

    public UpgradeComputeNodeLayout getDialogLayout() {
        return this.dialogLayout;
    }

    public boolean isSupportOffline() {
        return this.supportOffline;
    }
}

