/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.ui.dialog;

import com.huawei.ism.tool.base.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.distributedfwupg.action.ComputeNodeRetryAction;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.RolloverButton;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import org.slf4j.Logger;

public class UpgradeComputeNodeLayout
extends JPanel {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UpgradeComputeNodeLayout.class);
    private static final Dimension DEFAULT_SIZE = new Dimension(950, 350);
    private static final int CURRENT_VERSION_INDEX = 1;
    private static final int TARGET_VERSION_INDEX = 2;
    private static final int VERSION_COMPARE_INDEX = 3;
    private static int statusIndex = 3;
    private static int descriptionIndex = 4;
    private static int retryButtonIndex = 5;
    private int seccessNum = 0;
    private int failedNum = 0;
    private boolean isBatchExecute = false;
    private JButton upgradeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.upgrade"), (char)'U');
    private JButton offlineUpgradeBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.offlineUpgrade"), (char)'O');
    private JButton upgradePrepare = UiMethod.createButton((String)ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.upgrade.prepare"), (char)'P');
    private JButton exportReport = new RolloverButton(ResourceUtil.getString((String)"bundle.upgrade.main.btn.export.result"));
    private JButton retryAllBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.retry.all"), (char)'R');
    private JButton rollbackAllBtn = UiMethod.createButton((String)ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.rollback.all"), (char)'B');
    private IsmTable deviceTable = null;
    private DefaultTableModel deviceTableModel = null;
    private JLabel failedNodeNumDesc = new JLabel(ResourceUtil.getString((String)"upgrade.compute.failedNode.desc"));
    private JLabel totalNodeNumDesc = new JLabel(ResourceUtil.getString((String)"upgrade.compute.allNode.desc"));
    private JLabel successNodeNumDesc = new JLabel(ResourceUtil.getString((String)"upgrade.compute.successNode.desc"));
    private JLabel pullPkgFailedNodeNumDesc = new JLabel(ResourceUtil.getString((String)"upgrade.compute.pull_pkg_failed_node.desc"));
    private JLabel pullPkgSuccessNodeNumDesc = new JLabel(ResourceUtil.getString((String)"upgrade.compute.pull_pkg_success_node.desc"));
    private ToolHyperLinkLabel pullPkgFailedNodeNum = new ToolHyperLinkLabel("0");
    private ToolHyperLinkLabel pullPkgSuccessNodeNum = new ToolHyperLinkLabel("0");
    private JLabel upgradeTypeDesc = new JLabel(ResourceUtil.getString((String)"upgrade.compute.upgrade.type"));
    private JLabel upgradeTips = new JLabel(ResourceUtil.getString((String)"upgrade.compute.upgrade.tip"));
    private ToolHyperLinkLabel failedNodeNum = new ToolHyperLinkLabel("0");
    private ToolHyperLinkLabel successNodeNum = new ToolHyperLinkLabel("0");
    private ToolHyperLinkLabel totalNodeNum = new ToolHyperLinkLabel("0");
    private ToolHyperLinkLabel currentUpgradeType = new ToolHyperLinkLabel("");
    private JComponent failedNodeCom;
    private JLabel rollbackSuccessNumDesc = new JLabel(ResourceUtil.getString((String)"upgrade.compute.rollback.success.desc"));
    private JLabel rollbackFailedNumDesc = new JLabel(ResourceUtil.getString((String)"upgrade.compute.rollback.failed.desc"));
    private ToolHyperLinkLabel rollbackSuccessNum = new ToolHyperLinkLabel("0");
    private ToolHyperLinkLabel rollbackFailedNum = new ToolHyperLinkLabel("0");
    private JComponent rollbackCom;
    private String[] tableHeaders = new String[]{ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.os.ip"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.current.version"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.target.version"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.status"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.description"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.operation")};

    public UpgradeComputeNodeLayout() {
        this.rollbackCom = UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalStrut(10), this.rollbackSuccessNumDesc, this.rollbackSuccessNum, this.rollbackFailedNumDesc, this.rollbackFailedNum});
        this.rollbackCom.setVisible(false);
        this.failedNodeCom = UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.totalNodeNumDesc, this.totalNodeNum, this.pullPkgSuccessNodeNumDesc, this.pullPkgSuccessNodeNum, this.pullPkgFailedNodeNumDesc, this.pullPkgFailedNodeNum, this.successNodeNumDesc, this.successNodeNum, this.failedNodeNumDesc, this.failedNodeNum, this.rollbackCom});
        this.failedNodeNum.setToolTipText(ResourceUtil.getString((String)"upgrade.compute.failedNode.tips"));
        this.failedNodeNum.setFont(new Font("\u5b8b\u4f53", 1, 20));
        this.successNodeNum.setFont(new Font("\u5b8b\u4f53", 1, 20));
        this.successNodeNum.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        this.totalNodeNum.setFont(new Font("\u5b8b\u4f53", 1, 20));
        this.totalNodeNum.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        this.rollbackSuccessNum.setFont(new Font("\u5b8b\u4f53", 1, 20));
        this.rollbackSuccessNum.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        this.rollbackFailedNum.setFont(new Font("\u5b8b\u4f53", 1, 20));
        this.rollbackFailedNum.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        this.pullPkgSuccessNodeNum.setFont(new Font("\u5b8b\u4f53", 1, 20));
        this.pullPkgSuccessNodeNum.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        this.pullPkgFailedNodeNum.setFont(new Font("\u5b8b\u4f53", 1, 20));
        this.pullPkgFailedNodeNum.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        this.initComponents();
        this.layoutComponents();
    }

    private void initComponents() {
        this.resetHeaderAndIndex();
        this.deviceTableModel = new DefaultTableModel(this.tableHeaders, new int[0]);
        this.deviceTable = new IsmTable((TableModel)this.deviceTableModel);
    }

    private void resetHeaderAndIndex() {
        if (!UpgradeContext.getInstance().isDpcUpgrade()) {
            return;
        }
        this.tableHeaders = new String[]{ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.os.ip"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.current.version"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.target.version"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.compare"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.status"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.description"), ResourceUtil.getString((String)"upgrade.compute.node.dialog.table.operation")};
        statusIndex = 4;
        descriptionIndex = 5;
        retryButtonIndex = 6;
    }

    private void layoutComponents() {
        this.retryAllBtn.setToolTipText(ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.retry.all.tips"));
        this.retryAllBtn.setEnabled(false);
        this.rollbackAllBtn.setToolTipText(ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.rollback.all.tips"));
        this.rollbackAllBtn.setEnabled(false);
        this.offlineUpgradeBtn.setEnabled(false);
        this.upgradeBtn.setEnabled(false);
        JComponent tableArea = this.layoutTableArea();
        JComponent descriptionArea = this.layoutDescriptionArea();
        JComponent upgradeTypeArea = this.layoutUpgradeTypeArea();
        this.upgradeTips.setVisible(!UpgradeContext.getInstance().isDpcUpgrade());
        JComponent contentArea = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{descriptionArea}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.upgradeTips}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{upgradeTypeArea}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.failedNodeCom}), UCD.buildHorizotalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{Box.createHorizontalGlue()}), UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{tableArea})})});
        this.setLayout(new BorderLayout());
        this.add(this.buildFrameSpace(contentArea, 20, 30, 15, 35));
    }

    private JComponent layoutDescriptionArea() {
        JLabel sugg1 = new JLabel(ResourceUtil.getString((String)"upgrade.compute.node.dialog.desc"));
        JComponent view = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{sugg1})});
        return view;
    }

    private JComponent layoutUpgradeTypeArea() {
        this.currentUpgradeType.setFont(new Font("\u5b8b\u4f53", 1, 20));
        this.currentUpgradeType.setBorder((Border)new EmptyBorder(0, 0, 0, 10));
        return UiMethod.buildCompsLeft((int)0, (Component[])new Component[]{this.upgradeTypeDesc, this.currentUpgradeType});
    }

    private JComponent layoutTableArea() {
        TableScrollPane pane = TableScrollPane.createTablePane((IsmTable)this.deviceTable, (boolean)false, (TableScrollPane.CountArea)TableScrollPane.CountArea.TABLE_LEFT_DOWN, (TableScrollPane.FilterArea)TableScrollPane.FilterArea.TABLE_RIGHT_UP, (TableScrollPane.ButtonArea)TableScrollPane.ButtonArea.TABLE_LEFT_UP);
        pane.setPreferredSize(DEFAULT_SIZE);
        if (UpgradeContext.getInstance().isDpcUpgrade()) {
            pane.addComponent2ButtonArea(new JComponent[]{this.upgradePrepare, this.offlineUpgradeBtn, this.upgradeBtn, this.retryAllBtn, this.rollbackAllBtn});
        } else {
            pane.addComponent2ButtonArea(new JComponent[]{this.upgradePrepare, this.upgradeBtn, this.retryAllBtn, this.rollbackAllBtn});
        }
        pane.add((Component)this.getBottomPane(), (Object)"South");
        return pane;
    }

    private JComponent getBottomPane() {
        this.exportReport.setForeground(new Color(66, 124, 211));
        return UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{new JSeparator(), Box.createVerticalStrut(5), UCD.buildHBoxRight((Component[])new Component[]{this.exportReport, Box.createHorizontalStrut(3)}), Box.createVerticalStrut(5)});
    }

    public void allButtonDimmed() {
        this.upgradePrepare.setEnabled(false);
        this.offlineUpgradeBtn.setEnabled(false);
        this.upgradeBtn.setEnabled(false);
        this.retryAllBtn.setEnabled(false);
        this.rollbackAllBtn.setEnabled(false);
    }

    private JComponent buildFrameSpace(JComponent contentArea, int left, int right, int up, int down) {
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(left));
        hBox.add(contentArea);
        hBox.add(Box.createHorizontalStrut(right));
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createVerticalStrut(up));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(down));
        return vBox;
    }

    public void addDeviceTableRow(FSDevNode node) {
        this.deviceTableModel.addRow(new TableRow[]{this.createRow(node)});
    }

    public void updateDeviceTableRow(FSDevNode node) {
        TableRow row = this.deviceTableModel.getTableRowBy((Object)node);
        Constants.NodeUpgradeState status = node.getUpgradeStatus();
        IsmTableCell.IconCell statusLabel = (IsmTableCell.IconCell)IsmTableCell.IconCell.class.cast(row.getValueAt(statusIndex));
        if (status.getDesc().equals(statusLabel.toString())) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.updateRow(node, row, status, statusLabel);
            this.deviceTable.repaint();
        });
    }

    private void updateRow(FSDevNode node, TableRow row, Constants.NodeUpgradeState status, IsmTableCell.IconCell statusLabel) {
        this.initRetryButton(node, (TableRow<FSDevNode, FSDevNode>)row);
        this.updateStatusLabel(status, statusLabel);
        row.setValueAt(descriptionIndex, (Object)(node.getErrorDescription() + node.getErrorSuggestion()));
    }

    public void updateDeviceTableRowWithoutRepaint(FSDevNode node) {
        TableRow row = this.deviceTableModel.getTableRowBy((Object)node);
        Constants.NodeUpgradeState status = node.getUpgradeStatus();
        IsmTableCell.IconCell statusLabel = (IsmTableCell.IconCell)IsmTableCell.IconCell.class.cast(row.getValueAt(statusIndex));
        if (status.getDesc().equals(statusLabel.toString())) {
            return;
        }
        this.updateRow(node, row, status, statusLabel);
    }

    private void updateStatusLabel(Constants.NodeUpgradeState status, IsmTableCell.IconCell statusLabel) {
        statusLabel.setDescription(status.getDesc());
        statusLabel.setIcon((Icon)status.getImageIcon());
    }

    public void updateDeviceTableRow(List<FSDevNode> nodes, Constants.NodeUpgradeState status) {
        SwingUtilities.invokeLater(() -> {
            nodes.stream().peek(node -> node.setUpgradeStatus(status)).forEach(this::updateDeviceTableRowWithoutRepaint);
            this.deviceTable.repaint();
        });
    }

    private TableRow createRow(FSDevNode node) {
        DefaultTableRow row = new DefaultTableRow(this.deviceTableModel.getAllColumnCount(), (Object)node, (Object)node);
        row.setValueAt(0, (Object)node.getManagementIP());
        Constants.NodeUpgradeState status = node.getUpgradeStatus();
        row.setValueAt(1, (Object)node.getCurrentVersion());
        row.setValueAt(2, (Object)node.getTargetVersion());
        this.setConsistentDesc(node, (TableRow<FSDevNode, FSDevNode>)row);
        row.setValueAt(statusIndex, (Object)new IsmTableCell.IconCell((Icon)status.getImageIcon(), status.getDesc()));
        row.setValueAt(descriptionIndex, (Object)node.getErrorDescription());
        this.initRetryButton(node, (TableRow<FSDevNode, FSDevNode>)row);
        return row;
    }

    private void setConsistentDesc(FSDevNode node, TableRow<FSDevNode, FSDevNode> row) {
        if (!node.isDpcComputeNode()) {
            return;
        }
        String key = "upgrade.compute.node.dpc.version.inconsistent";
        if (node.isConsistent()) {
            key = "upgrade.compute.node.dpc.version.consistent";
        }
        row.setValueAt(3, (Object)ResourceUtil.getString((String)key));
    }

    private void initRetryButton(FSDevNode node, TableRow<FSDevNode, FSDevNode> row) {
        if (node.isFailed()) {
            IsmTableCell.HyperlinkCell retryButton = new IsmTableCell.HyperlinkCell(ResourceUtil.getString((String)"upgrade.compute.node.dialog.button.retry"), (ActionListener)new ComputeNodeRetryAction(this, node));
            row.setValueAt(retryButtonIndex, (Object)retryButton);
        } else {
            row.setValueAt(retryButtonIndex, (Object)"");
        }
    }

    public JButton getUpgradeBtn() {
        return this.upgradeBtn;
    }

    public JButton getRollbackAllBtn() {
        return this.rollbackAllBtn;
    }

    public void refreshSingleNodeVersion(FSDevNode node) {
        LOGGER.info("refresh node:{} version", (Object)node.getManagementIP());
        if (UpgradeContext.getInstance().isDpcUpgrade()) {
            this.refreshDpcSingleNodeVersion(node);
            return;
        }
        TableRow row = this.deviceTableModel.getTableRowBy((Object)node);
        String newVersion = FsUpgradeService.queryUpgradeCurrentVersion(node);
        node.setCurrentVersion(newVersion);
        row.setValueAt(1, (Object)newVersion);
        SwingUtilities.invokeLater(() -> this.deviceTable.repaint());
    }

    private void refreshDpcSingleNodeVersion(FSDevNode node) {
        String newVersion = FsUpgradeService.queryDpcCurrentVersion(node);
        boolean isConsistent = node.getTargetVersion().equals(newVersion);
        node.setCurrentVersion(newVersion);
        node.setConsistent(isConsistent);
        TableRow row = this.deviceTableModel.getTableRowBy((Object)node);
        row.setValueAt(1, (Object)node.getCurrentVersion());
        this.setConsistentDesc(node, (TableRow<FSDevNode, FSDevNode>)row);
        SwingUtilities.invokeLater(() -> this.deviceTable.repaint());
    }

    public List<FSDevNode> getAllNodes() {
        ArrayList<FSDevNode> allNodes = new ArrayList<FSDevNode>();
        List selectedRows = this.deviceTable.getAllRows();
        for (TableRow row : selectedRows) {
            allNodes.add((FSDevNode)((Object)row.getUserObject()));
        }
        return allNodes;
    }

    public List<FSDevNode> getAllNodesExceptVbsMaster() {
        return this.getAllNodes().stream().filter(node -> !node.isVbsNode()).collect(Collectors.toList());
    }

    public void enableUpgrade(boolean flag) {
        this.deviceTable.setEnabled(flag);
        this.upgradePrepare.setEnabled(flag);
    }

    public boolean isAllRowsSucceeded() {
        return this.getAllNodes().stream().map(FSDevNode::getUpgradeStatus).allMatch(Constants.NodeUpgradeState::isSuccessUpgradeOrRollback);
    }

    public JButton getRetryAllBtn() {
        return this.retryAllBtn;
    }

    public synchronized void resetFailedNum(int num) {
        this.failedNum = num;
        this.failedNodeNum.setText(String.valueOf(num));
    }

    public synchronized void resetTotalNum(int num) {
        this.totalNodeNum.setText(String.valueOf(num));
    }

    public synchronized void resetSuccessNum(int num) {
        this.seccessNum = num;
        this.successNodeNum.setText(String.valueOf(num));
    }

    public synchronized void resetRollbackSuccessNum(int num) {
        this.rollbackSuccessNum.setText(String.valueOf(num));
    }

    public synchronized void resetPullPkgFailedNum(int num) {
        this.pullPkgFailedNodeNum.setText(String.valueOf(num));
    }

    public synchronized void resetPullPkgSuccessNum(int num) {
        this.pullPkgSuccessNodeNum.setText(String.valueOf(num));
    }

    public synchronized void resetRollbackFailedNum(int num) {
        this.rollbackFailedNum.setText(String.valueOf(num));
    }

    public synchronized void setCurrentUpgradeType(String type) {
        this.currentUpgradeType.setText(type);
    }

    public synchronized void coverRetryBtn() {
        List<FSDevNode> allNodes = this.getAllNodes();
        this.retryAllBtn.setEnabled(allNodes.stream().allMatch(FSDevNode::isFinished) && allNodes.stream().anyMatch(FSDevNode::isFailed));
    }

    public synchronized void coverRollbackBtn() {
        List<FSDevNode> allNodes = this.getAllNodes();
        this.rollbackAllBtn.setEnabled(allNodes.stream().allMatch(FSDevNode::isFinished) && allNodes.stream().anyMatch(FSDevNode::isFailed) && allNodes.stream().noneMatch(FSDevNode::isRollbackStatus) && allNodes.stream().anyMatch(fsDevNode -> !fsDevNode.getUpgradeStatus().isUpgradePrepareStatus()));
    }

    public synchronized void coverUpgradeBth() {
        List<FSDevNode> allNodes = this.getAllNodes();
        this.upgradeBtn.setEnabled(allNodes.stream().allMatch(FSDevNode::isFinished) && allNodes.stream().anyMatch(fsDevNode -> fsDevNode.getUpgradeStatus().isPullPkgSuccessStatus()));
    }

    public synchronized void coverOfflineUpgradeBth() {
        List<FSDevNode> allNodes = this.getAllNodes();
        this.offlineUpgradeBtn.setEnabled(allNodes.stream().allMatch(FSDevNode::isFinished) && allNodes.stream().anyMatch(fsDevNode -> fsDevNode.getUpgradeStatus().isPullPkgSuccessStatus()));
    }

    public boolean isBatchExecute() {
        return this.isBatchExecute;
    }

    public void setBatchExecute(boolean batchExecute) {
        this.isBatchExecute = batchExecute;
    }

    public JButton getOfflineUpgradeBtn() {
        return this.offlineUpgradeBtn;
    }

    public JButton getUpgradePrepare() {
        return this.upgradePrepare;
    }

    public JButton getExportReport() {
        return this.exportReport;
    }

    public ToolHyperLinkLabel getPullPkgSuccessNodeNum() {
        return this.pullPkgSuccessNodeNum;
    }

    public JComponent getRollbackCom() {
        return this.rollbackCom;
    }
}

