/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.utils;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.huawei.bundleupgrade.entity.AccountEntity;
import com.huawei.bundleupgrade.entity.ComputeNodeUpgradeResult;
import com.huawei.bundleupgrade.entity.NodeServiceInfo;
import com.huawei.bundleupgrade.entity.fusionstrg.UpgDeviceExtendFSDataEntity;
import com.huawei.bundleupgrade.utils.UpgradeCustomizationUtil;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.ContextUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.devicecenter.context.SshForwardContext;
import com.huawei.ism.tool.devicecenter.entity.IBMCDevice;
import com.huawei.ism.tool.devicecenter.entity.OsDevice;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevice2Json;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeFlowService;
import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneEnvironment;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.connection.CustomDefaultSshJudge;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Dialog;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.JButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    public static final String UPGRADE_SETTING_TOOL_ID = "SceneSetting";
    public static final String INTERACTIVE_KEY = "To continue the online upgrade, enter (yes/y). To stop the upgrade, enter (no/n):";
    public static final String CPU_HIGHER_KEY = "The current CPU usage is higher than";
    public static final String MEMORY_HIGHER_KEY = "The remaining system memory percentage is less than ";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(CommonUtils.class);
    private static final String NODE_DISABLE_STEP_LIST = "disabledStepList";
    private static final String DEVICELIST_PATH = ContextUtil.getToolBoxPath() + File.separator + "temp" + File.separator + "sceneTemplates" + File.separator + "server";
    private static final String DEVICELIST_FILE_NAME = "sceneDevice.json";
    private static final String CLUSTER_FILE_NAME = "clusterDevice.json";
    private static final String COMPUTE_RESULT_FILE_NAME = "computeResult.json";
    public static final String TOOL_ID = "DistributedFWUpgrade";
    private static final String SCENE_DEV_STATUS = "status";
    private static final String SCENE_TOOL_ID = "toolId";
    private static final String SYSTEM_CONFIG_PATH = ApplicationContext.getInstance().getConfigPath() + "SystemConfig.ini";
    private static final String SCENE_SN = "SN";
    private static final String SCENE_IP = "IP";
    private static final String EMPTY_VALUE = "";
    private static final String LEFT_BRACKET = "(";
    private static final String USER_ROOT = "root";
    private static String[] tableHeaders = new String[]{ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.manageip"), ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.bmcip")};
    private static final Pattern IPV4_PATTERN = Pattern.compile("(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])(%.+)?\\|", 2);
    private static final Pattern IPV6_PATTERN = Pattern.compile("((([0-9A-Fa-f]{1,4}:){7}(([0-9A-Fa-f]{1,4})|:))|(([0-9A-Fa-f]{1,4}:){6}(:|((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})|(:[0-9A-Fa-f]{1,4})))|(([0-9A-Fa-f]{1,4}:){5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){4}(:[0-9A-Fa-f]{1,4}){0,1}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){3}(:[0-9A-Fa-f]{1,4}){0,2}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:){2}(:[0-9A-Fa-f]{1,4}){0,3}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(([0-9A-Fa-f]{1,4}:)(:[0-9A-Fa-f]{1,4}){0,4}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(:(:[0-9A-Fa-f]{1,4}){0,5}((:((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})?)|((:[0-9A-Fa-f]{1,4}){1,2})))|(((25[0-5]|2[0-4]\\d|[01]?\\d{1,2})(\\.(25[0-5]|2[0-4]\\d|[01]?\\d{1,2})){3})))(%.+)?\\|", 2);
    private static final Map<FSDevNode, DevNode> CACHE = new ConcurrentHashMap<FSDevNode, DevNode>();
    private static final Map<UpgDeviceExtendFSDataEntity, DevNode> UP_CAHCE = new ConcurrentHashMap<UpgDeviceExtendFSDataEntity, DevNode>();
    private static final CustomDefaultSshJudge DEFAULT_SSH_JUDGE = new CustomDefaultSshJudge();

    public static void serverDevToFsNode(IBMCDevice ibmcDevice, FSDevNode fsDevNode) {
        fsDevNode.setBmcUserName(ibmcDevice.getHwServerDev().getUserName());
        fsDevNode.setBmcPassword(ibmcDevice.getHwServerDev().getUserPwd());
        fsDevNode.setBmcIP(ibmcDevice.getIp());
        fsDevNode.setProductName(ibmcDevice.getProductName());
        fsDevNode.setSerialNumber(ibmcDevice.getDeviceSerialNumber());
    }

    public static void serverDevToFsNode(OsDevice osDevice, FSDevNode fsDevNode) {
        fsDevNode.setOsUserName(osDevice.getHwServerDev().getUserName());
        fsDevNode.setOsPassword(osDevice.getHwServerDev().getUserPwd());
        fsDevNode.setOsRootPassword(osDevice.getHwServerDev().getRootPwd());
        fsDevNode.setSshForwardList(SshForwardContext.getInstance().getSshListByIp(osDevice.getIp()));
        if (!StringUtils.isNULLStr((String)osDevice.getSn())) {
            fsDevNode.setSerialNumber(osDevice.getSn());
        }
    }

    public static void saveDevice2File(List<FSClusterDevice> fsClusterDeviceList) {
        CommonUtils.transSelectDevice2Json(fsClusterDeviceList);
        CommonUtils.transFSCluster2Json(fsClusterDeviceList);
    }

    public static void transSelectDevice2Json(List<FSClusterDevice> fsClusterDeviceList) {
        CommonUtils.transFSCluster2Json(fsClusterDeviceList);
        FSDevice2Json fsDevice2Json = new FSDevice2Json();
        for (FSClusterDevice fsClusterDev : fsClusterDeviceList) {
            if (!fsClusterDev.isSelected()) continue;
            ArrayList businessIpMapList = new ArrayList();
            List<FSDevNode> fsDevNodes = fsClusterDev.getFsDevNodeList();
            for (FSDevNode fsDevNode : fsDevNodes) {
                Map<String, Object> fsNodeMap = CommonUtils.transFSNode2Map(fsDevNode);
                fsDevice2Json.getDeviceList().add(fsNodeMap);
                HashMap<String, String> businessIpMap = new HashMap<String, String>();
                businessIpMap.put("bmcIP", fsDevNode.getBmcIP());
                businessIpMap.put("storageIp", fsDevNode.getManagementIP());
                businessIpMap.put("username", fsDevNode.getOsUserName());
                businessIpMap.put("password", fsDevNode.getOsPasswordWithoutDecrypt());
                businessIpMap.put("rootpassword", fsDevNode.getOsRootPasswordWithoutEncrypt());
                businessIpMapList.add(businessIpMap);
            }
            HashMap<String, Object> associatedFStorageInfoMap = new HashMap<String, Object>();
            associatedFStorageInfoMap.put("floatIp", fsClusterDev.getFloatIp());
            associatedFStorageInfoMap.put("innerFloatIp", fsClusterDev.getInnerFloatIp());
            associatedFStorageInfoMap.put("username", fsClusterDev.getLoginUser().getUserName());
            associatedFStorageInfoMap.put("password", AESEncrypt.encrypt((String)fsClusterDev.getLoginUser().getPassword()));
            associatedFStorageInfoMap.put("httpport", "8088");
            associatedFStorageInfoMap.put("serialNumber", fsClusterDev.getSn());
            associatedFStorageInfoMap.put("businessIpMapping", businessIpMapList);
            associatedFStorageInfoMap.put("productVersion", fsClusterDev.getProductVersion());
            associatedFStorageInfoMap.put("hotPatchVersion", fsClusterDev.getHotPatchVersion());
            associatedFStorageInfoMap.put("sandboxClosedList", fsClusterDev.getSandboxClosedList());
            associatedFStorageInfoMap.put("productModel", fsClusterDev.getProductModel());
            fsDevice2Json.getAssociatedFStorageInfo().add(associatedFStorageInfoMap);
        }
        Gson gson = new Gson();
        String jsonArrayStr = gson.toJson((Object)fsDevice2Json);
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(jsonArrayStr);
        StreamUtils.writeStringFormFile(strs, (String)DEVICELIST_PATH, (String)DEVICELIST_FILE_NAME);
    }

    private static Map<String, Object> transFSNode2Map(FSDevNode fsDevNode) {
        HashMap<String, Object> fsNodeMap = new HashMap<String, Object>();
        fsNodeMap.put("biosVersion", EMPTY_VALUE);
        fsNodeMap.put("cpldVersion", EMPTY_VALUE);
        fsNodeMap.put("masterBMC", EMPTY_VALUE);
        fsNodeMap.put("slaveBMC", EMPTY_VALUE);
        fsNodeMap.put("productType", fsDevNode.getProductName());
        fsNodeMap.put("serialNumber", fsDevNode.getSerialNumber());
        fsNodeMap.put("ip", fsDevNode.getBmcIP());
        fsNodeMap.put("username", fsDevNode.getBmcUserName());
        fsNodeMap.put("password", fsDevNode.getBmcPasswordWithoutDecrypt());
        fsNodeMap.put("ipmiPort", String.valueOf(fsDevNode.getIpmiPort()));
        fsNodeMap.put("httpsPort", fsDevNode.getRedFishPort());
        fsNodeMap.put("snmpPort", String.valueOf(fsDevNode.getSnmpPort()));
        fsNodeMap.put("snmpV2Community", fsDevNode.getCommunity());
        fsNodeMap.put("sshPort", String.valueOf(fsDevNode.getSshPort()));
        fsNodeMap.put("type", "ibmc");
        fsNodeMap.put("select", String.valueOf(fsDevNode.isSelected()));
        fsNodeMap.put("chassisId", fsDevNode.getChassisId());
        fsNodeMap.put("storageBackEndPortList", fsDevNode.getStorageBackEndPortList());
        fsNodeMap.put("storageFrontendEndPortList", fsDevNode.getStorageFrontendEndPortList());
        fsNodeMap.put("vmmPort", String.valueOf(fsDevNode.getVmmPort()));
        fsNodeMap.put("supportRedfish", String.valueOf(fsDevNode.getBmcAuthState() != Constants.NodeAuthState.NOT_REQUIRED));
        fsNodeMap.put("baseBoardType", fsDevNode.getBorderType());
        fsNodeMap.put("sshForwardList", CommonUtils.getSshRouteList(fsDevNode));
        fsNodeMap.put("managementIps", fsDevNode.getManagementIps());
        CommonUtils.initServiceInfo(fsDevNode, fsNodeMap);
        return fsNodeMap;
    }

    private static List<MultiRouteNode> getSshRouteList(FSDevNode fsDevNode) {
        if (!CollectionUtil.isEmpty((Collection)fsDevNode.getSshForwardList())) {
            return fsDevNode.getSshForwardList();
        }
        return SshForwardContext.getInstance().getSshListByIp(fsDevNode.getManagementIP());
    }

    private static void initServiceInfo(FSDevNode fsDevNode, Map<String, Object> fsNodeMap) {
        NodeServiceInfo nodeServiceInfo = fsDevNode.getNodeServiceInfo();
        HashMap<String, Object> nodeServiceInfoMap = new HashMap<String, Object>();
        if (nodeServiceInfo == null) {
            return;
        }
        nodeServiceInfoMap.put("mgrIP", nodeServiceInfo.getMgrIP());
        nodeServiceInfoMap.put("serviceInfo", nodeServiceInfo.getServiceInfo());
        nodeServiceInfoMap.put("queryServiceError", nodeServiceInfo.isQueryServiceError());
        nodeServiceInfoMap.put("storagePoolId", nodeServiceInfo.getStoragePoolId());
        nodeServiceInfoMap.put("diskPoolId", nodeServiceInfo.getDiskPoolId());
        nodeServiceInfoMap.put("productVersion", nodeServiceInfo.getProductVersion());
        nodeServiceInfoMap.put("isSupportDiskPool", nodeServiceInfo.isSupportDiskPool());
        nodeServiceInfoMap.put("queryStoragePoolError", nodeServiceInfo.isQueryStoragePoolError());
        nodeServiceInfoMap.put("volumeNum", nodeServiceInfo.getVolumeNum());
        fsNodeMap.put("nodeServiceInfo", nodeServiceInfoMap);
    }

    private static void transFSCluster2Json(List<FSClusterDevice> fsClusterDeviceList) {
        ArrayList<String> strs = new ArrayList<String>();
        Gson gson = new Gson();
        String jsonArrayStr = gson.toJson(fsClusterDeviceList);
        strs.add(jsonArrayStr);
        StreamUtils.writeStringFormFile(strs, (String)DEVICELIST_PATH, (String)CLUSTER_FILE_NAME);
    }

    public static List<FSClusterDevice> transJson2FSCluster() {
        String dataFilePath = Paths.get(DEVICELIST_PATH, CLUSTER_FILE_NAME).toString();
        File filePath = new File(dataFilePath);
        if (!filePath.exists()) {
            return new ArrayList<FSClusterDevice>();
        }
        String jsonStr = CommonUtils.readFile(filePath);
        Gson gson = new Gson();
        return (List)gson.fromJson(jsonStr, new TypeToken<List<FSClusterDevice>>(){}.getType());
    }

    private static String readFile(File filePath) {
        return StreamUtils.readStringFormFile((File)filePath);
    }

    public static void finishedSceneTask() {
        LOGGER.info("Scenc FS FW Upgrade: call finishedSceneTask begin");
        TaskResult result = null;
        try {
            List<Map<String, String>> callBackMap = CommonUtils.createSettingDataMap();
            if (callBackMap.isEmpty()) {
                callBackMap.add(CommonUtils.createEmptyDeviceMap());
            }
            LOGGER.info("Scene fusionstorage firmware upgrade call finishedSceneTask :{}", callBackMap);
            ISceneEnvironment environmentImpl = SceneEnvironmentImpl.getInstance();
            result = environmentImpl.finishedSceneTask(callBackMap);
        }
        catch (ToolException e) {
            LOGGER.error("Scene fusionstorage firmware upgrade: call back failed", (Throwable)e);
        }
        if (result != null && !result.getResult().equals((Object)TaskResult.Result.SUCCESS)) {
            LOGGER.info("Scene fusionstorage firmware upgrade call back faild:{}", (Object)result.toString());
        }
    }

    private static Map<String, String> createEmptyDeviceMap() {
        HashMap<String, String> sceneDeviceMap = new HashMap<String, String>();
        sceneDeviceMap.put(SCENE_TOOL_ID, TOOL_ID);
        sceneDeviceMap.put(SCENE_SN, EMPTY_VALUE);
        sceneDeviceMap.put(SCENE_IP, EMPTY_VALUE);
        sceneDeviceMap.put(SCENE_DEV_STATUS, EMPTY_VALUE);
        return sceneDeviceMap;
    }

    private static List<Map<String, String>> createSettingDataMap() {
        List<FSClusterDevice> upgradeDevNodes = UpgradeContext.getInstance().getUiObserver().getSelectedDev();
        ArrayList<Map<String, String>> callBackMap = new ArrayList<Map<String, String>>();
        if (null == upgradeDevNodes) {
            return callBackMap;
        }
        for (FSClusterDevice upgradeDevNode : upgradeDevNodes) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(SCENE_DEV_STATUS, TaskResult.Result.SUCCESS.toString());
            map.put(SCENE_TOOL_ID, UPGRADE_SETTING_TOOL_ID);
            map.put(SCENE_SN, upgradeDevNode.getSn());
            map.put(SCENE_IP, upgradeDevNode.getFloatIp());
            CommonUtils.ashingNotProprietaryHardware(upgradeDevNode, map);
            map.put("resultFileSavePath", com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getFilePath());
            callBackMap.add(map);
        }
        return callBackMap;
    }

    private static void ashingNotProprietaryHardware(FSClusterDevice upgradeDevNode, Map<String, String> map) {
        if (upgradeDevNode.getFsDevNodeList().stream().filter(FSDevNode::isSelected).noneMatch(FSDevNode::isProprietaryHardware) && !UpgradeCustomizationUtil.isSupportExtendInspect(upgradeDevNode.getProductModel(), upgradeDevNode.getProductVersion())) {
            map.put(NODE_DISABLE_STEP_LIST, "Inspector");
        }
    }

    public static Map<String, List<String>> getDuplicateOrNullBMCIpInfo(List<FSDevNode> selectedNodes) {
        HashMap bmc2ManageIP = new HashMap();
        for (FSDevNode fsDevNode : selectedNodes) {
            String bmcIP = fsDevNode.getBmcIP();
            if (bmc2ManageIP.containsKey(bmcIP)) {
                ((List)bmc2ManageIP.get(bmcIP)).add(fsDevNode.getManagementIP());
                continue;
            }
            ArrayList<String> ipList = new ArrayList<String>();
            ipList.add(fsDevNode.getManagementIP());
            bmc2ManageIP.put(bmcIP, ipList);
        }
        HashMap<String, List<String>> bmc2ManageIPResult = new HashMap<String, List<String>>();
        for (Map.Entry entry : bmc2ManageIP.entrySet()) {
            if (((List)entry.getValue()).size() <= 1 && !((String)entry.getKey()).equalsIgnoreCase(EMPTY_VALUE)) continue;
            bmc2ManageIPResult.put((String)entry.getKey(), (List<String>)entry.getValue());
        }
        return bmc2ManageIPResult;
    }

    public static boolean checkBmcIp(Dialog parentDialog, List<FSDevNode> selectedNodes) {
        Map<String, List<String>> bmc2ManagerIp = CommonUtils.getDuplicateOrNullBMCIpInfo(selectedNodes);
        if (bmc2ManagerIp.containsKey(EMPTY_VALUE)) {
            CommonUtils.showNullIpFailedTips(parentDialog, bmc2ManagerIp);
            return false;
        }
        for (List<String> values : bmc2ManagerIp.values()) {
            if (values.size() <= 1) continue;
            CommonUtils.showduplicateIpFailedTips(parentDialog, bmc2ManagerIp);
            return false;
        }
        return true;
    }

    private static void showNullIpFailedTips(Dialog parentDialog, Map<String, List<String>> bmcAndmanageIPMap) {
        ArrayList<List<String>> failedIpList = new ArrayList<List<String>>();
        for (Map.Entry<String, List<String>> entry : bmcAndmanageIPMap.entrySet()) {
            String bmcIp = entry.getKey();
            if (!StringUtils.isNULLStr((String)bmcIp)) continue;
            List<String> manageIpList = entry.getValue();
            failedIpList.addAll(CommonUtils.parseFailedIpInfo(manageIpList, bmcIp));
        }
        String nullIPErrMsg = ResourceUtil.getString((String)"dsfwupgrade.wizard.select.bmcip.null.node");
        DialogUtils.showMultiErrorDialogNoIgnoreButton((Window)parentDialog, (String)nullIPErrMsg, (String[])tableHeaders, failedIpList);
    }

    private static void showduplicateIpFailedTips(Dialog parentDialog, Map<String, List<String>> bmcAndmanageIPMap) {
        ArrayList<List<String>> failedIpList = new ArrayList<List<String>>();
        for (Map.Entry<String, List<String>> entry : bmcAndmanageIPMap.entrySet()) {
            String bmcIp = entry.getKey();
            List<String> manageIpList = entry.getValue();
            failedIpList.addAll(CommonUtils.parseFailedIpInfo(manageIpList, bmcIp));
        }
        String duplicateErrMsg = ResourceUtil.getString((String)"dsfwupgrade.wizard.select.duplicate.node");
        DialogUtils.showMultiErrorDialogNoIgnoreButton((Window)parentDialog, (String)duplicateErrMsg, (String[])tableHeaders, failedIpList);
    }

    private static List<List<String>> parseFailedIpInfo(List<String> manageIpList, String bmcIp) {
        ArrayList<List<String>> failedIpList = new ArrayList<List<String>>();
        for (String manageIp : manageIpList) {
            ArrayList<String> ipList = new ArrayList<String>();
            ipList.add(manageIp);
            ipList.add(bmcIp);
            failedIpList.add(ipList);
        }
        return failedIpList;
    }

    public static boolean checkAuthNodeIPHasDuplicate(Dialog parentDialog, List<FSDevNode> selectedNodes, List<FSDevNode> allNodes) {
        Map<String, List<String>> bmcAndmanageIPMap = CommonUtils.getDuplicateOrNullBMCIpInfo(allNodes);
        HashMap<String, List<String>> showBMCAndManaIPMap = new HashMap<String, List<String>>();
        HashSet<String> selectedBmcIPSet = new HashSet<String>();
        for (FSDevNode fSDevNode : selectedNodes) {
            selectedBmcIPSet.add(fSDevNode.getBmcIP());
        }
        for (Map.Entry entry : bmcAndmanageIPMap.entrySet()) {
            if (((List)entry.getValue()).size() <= 1 || !selectedBmcIPSet.contains(entry.getKey())) continue;
            showBMCAndManaIPMap.put((String)entry.getKey(), (List<String>)entry.getValue());
        }
        if (!showBMCAndManaIPMap.isEmpty()) {
            CommonUtils.showduplicateIpFailedTips(parentDialog, showBMCAndManaIPMap);
            return false;
        }
        return true;
    }

    public static boolean checkAuthNodeBmcIpEmpty(Dialog parentDialog, List<FSDevNode> selectedNodes) {
        Map<String, List<String>> bmcAndmanageIPMap = CommonUtils.getDuplicateOrNullBMCIpInfo(selectedNodes);
        if (bmcAndmanageIPMap.containsKey(EMPTY_VALUE)) {
            CommonUtils.showNullIpFailedTips(parentDialog, bmcAndmanageIPMap);
            return false;
        }
        return true;
    }

    public static boolean checkNodeType(Dialog parentDialog, List<FSDevNode> selectedNodes) {
        ArrayList failedIpList = new ArrayList();
        String upgradeScene = UpgradeContext.getInstance().getUpgradeScene();
        if (Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(upgradeScene)) {
            LOGGER.info("Current scene  is compute node select,do not check dev type.");
            return true;
        }
        for (FSDevNode fsDevNode : selectedNodes) {
            String productName = fsDevNode.getProductName();
            if (fsDevNode.isOemSetting() || CommonUtils.productSupport(productName)) continue;
            ArrayList<String> ipList = new ArrayList<String>();
            ipList.add(fsDevNode.getManagementIP());
            ipList.add(fsDevNode.getBmcIP());
            failedIpList.add(ipList);
        }
        if (failedIpList.isEmpty()) {
            return true;
        }
        String duplicateErrMsg = ResourceUtil.getString((String)"dsfwupgrade.wizard.select.not.support.type");
        DialogUtils.showMultiErrorDialogNoIgnoreButton((Window)parentDialog, (String)duplicateErrMsg, (String[])tableHeaders, failedIpList);
        return false;
    }

    private static boolean productSupport(String productName) {
        List<DeviceType> serverTypeList = UpgradeContext.getInstance().getSupportServerTypeList();
        for (DeviceType deviceType : serverTypeList) {
            if (!productName.equals(deviceType.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean checkNodeAuth(Dialog parentDialog, List<FSDevNode> selectedNodes, boolean needOsAuth, boolean needBmcAuth) {
        ArrayList failedIpList = new ArrayList();
        for (FSDevNode fsDevNode : selectedNodes) {
            if (CommonUtils.isAuthSuccess(needOsAuth, needBmcAuth, fsDevNode)) continue;
            ArrayList<String> ipList = new ArrayList<String>();
            ipList.add(fsDevNode.getManagementIP());
            ipList.add(fsDevNode.getBmcIP());
            failedIpList.add(ipList);
        }
        if (failedIpList.isEmpty()) {
            return true;
        }
        String duplicateErrMsg = ResourceUtil.getString((String)"dsfwupgrade.wizard.select.not.auth");
        DialogUtils.showMultiErrorDialogNoIgnoreButton((Window)parentDialog, (String)duplicateErrMsg, (String[])tableHeaders, failedIpList);
        return false;
    }

    private static boolean isAuthSuccess(boolean needOsAuth, boolean needBmcAuth, FSDevNode fsDevNode) {
        boolean success = true;
        if (needOsAuth && !fsDevNode.isDirectPlane()) {
            success = Constants.NodeAuthState.SUCCESS.equals((Object)fsDevNode.getOsAuthState());
        }
        if (needBmcAuth) {
            success = success && (Constants.NodeAuthState.SUCCESS.equals((Object)fsDevNode.getBmcAuthState()) || Constants.NodeAuthState.NOT_REQUIRED.equals((Object)fsDevNode.getBmcAuthState()));
        }
        return success;
    }

    public static boolean checkSelectedNode(Dialog parentDialog, List<FSDevNode> selectedNodes, boolean needOsAuth, boolean needBmcAuth) {
        if (null == selectedNodes || selectedNodes.isEmpty()) {
            LOGGER.error("Select nodes is null.");
            DialogUtils.showInfoDialog((Window)parentDialog, (String)ResourceUtil.getString((String)"dsfwupgrade.wizard.select.no.node"));
            return false;
        }
        List<FSDevNode> bmcNodes = selectedNodes.stream().filter(node -> !Constants.NodeAuthState.NOT_REQUIRED.equals((Object)node.getBmcAuthState())).collect(Collectors.toList());
        if (needBmcAuth && !CommonUtils.checkBmcIp(parentDialog, bmcNodes)) {
            LOGGER.error("Select nodes check Bmc IP failed.");
            return false;
        }
        if (!CommonUtils.checkNodeType(parentDialog, selectedNodes)) {
            LOGGER.error("Select nodes check server type not support.");
            return false;
        }
        if (!CommonUtils.checkNodeAuth(parentDialog, selectedNodes, needOsAuth, needBmcAuth)) {
            LOGGER.error("Select nodes has not auth node.");
            return false;
        }
        return true;
    }

    public static DevNode transFsDevNode2DevNode(FSDevNode fsDevNode) {
        if (CACHE.containsKey((Object)fsDevNode)) {
            return CACHE.get((Object)fsDevNode);
        }
        DevNode devNode = new DevNode();
        devNode.setDeviceSerialNumber(fsDevNode.getSerialNumber());
        devNode.setIp(fsDevNode.getManagementIP());
        devNode.setPort(fsDevNode.getSshPort());
        devNode.setDeviceType(DeviceType.ALL);
        devNode.setItDeviceType(ItDeviceType.Server);
        User user = new User(fsDevNode.getOsUserName(), fsDevNode.getOsPassword());
        devNode.setLoginUser(user);
        if (!StringUtils.isNULLStr((String)fsDevNode.getOsRootPassword())) {
            LOGGER.info("ComputeNode set rootUser");
            User rootUser = new User(USER_ROOT, Base64EncodeUtils.encode((String)fsDevNode.getOsRootPassword()));
            devNode.setRootUser(rootUser);
        } else if (USER_ROOT.equals(fsDevNode.getOsUserName())) {
            LOGGER.info("ComputeNode set rootUser");
            User rootUser = new User(USER_ROOT, Base64EncodeUtils.encode((String)fsDevNode.getOsPassword()));
            devNode.setRootUser(rootUser);
        }
        devNode.setSshForwardList(fsDevNode.getSshForwardList());
        CACHE.putIfAbsent(fsDevNode, devNode);
        return devNode;
    }

    public static DevNode transUpgDeviceExtendFSDataEntity2DevNode(UpgDeviceExtendFSDataEntity upgDeviceEntity) {
        if (UP_CAHCE.containsKey(upgDeviceEntity)) {
            return UP_CAHCE.get(upgDeviceEntity);
        }
        DevNode devNode = new DevNode();
        devNode.setDeviceSerialNumber(upgDeviceEntity.getDeviceEntity().getDeviceEntity().getSerialNumber());
        devNode.setIp(upgDeviceEntity.getManagementIp());
        devNode.setPort(upgDeviceEntity.getDeviceEntity().getDeviceEntity().getSshPortInt());
        devNode.setDeviceType(DeviceType.ALL);
        devNode.setItDeviceType(ItDeviceType.Server);
        AccountEntity sshAccount = upgDeviceEntity.getSshAccount();
        User user = new User(sshAccount.getUserName(), sshAccount.getPassword());
        devNode.setLoginUser(user);
        String osRootPassword = sshAccount.getOsRootPassword();
        if (!StringUtils.isNULLStr((String)osRootPassword)) {
            LOGGER.info("reset node {} rootUser ", (Object)devNode.getIp());
            User rootUser = new User(USER_ROOT, Base64EncodeUtils.encode((String)osRootPassword));
            devNode.setRootUser(rootUser);
        } else if (USER_ROOT.equals(sshAccount.getUserName())) {
            LOGGER.info("reset node {} rootUser ", (Object)devNode.getIp());
            User rootUser = new User(USER_ROOT, Base64EncodeUtils.encode((String)sshAccount.getPassword()));
            devNode.setRootUser(rootUser);
        } else {
            devNode.setRootUser(null);
        }
        devNode.setSshForwardList(upgDeviceEntity.getDeviceEntity().getDeviceEntity().getSshForwardList());
        UP_CAHCE.putIfAbsent(upgDeviceEntity, devNode);
        return devNode;
    }

    public static DevNode transFsClusterDev2DevNode(FSClusterDevice fsDevNode) {
        DevNode devNode = new DevNode();
        devNode.setIp(fsDevNode.getFloatIp());
        devNode.setItDeviceType(ItDeviceType.DStorage);
        devNode.setLoginUser(fsDevNode.getLoginUser());
        return devNode;
    }

    public static List<String> executeFsDevNodeCmd(FSDevNode fsDevNode, String cmd, boolean needLog) throws ToolException {
        DevNode devNode = CommonUtils.transFsDevNode2DevNode(fsDevNode);
        ICliConnection ssh = null;
        try {
            ssh = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
            return CommonUtils.execAndGetReturn(cmd, needLog, ssh);
        }
        catch (com.huawei.ism.tool.obase.exception.ToolException e) {
            if (null != ssh && !ssh.isConnected()) {
                LOGGER.info("Connection for {} is close, retry 1 time.", (Object)fsDevNode.getManagementIP());
                SshConnectionManager.releaseConnection((ICliConnection)ssh);
                CommonUtils.safeSleep(3000);
                try {
                    ssh = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
                    return CommonUtils.execAndGetReturn(cmd, needLog, ssh);
                }
                catch (Exception ex) {
                    LOGGER.error("Node {} exec cmd error.", (Object)fsDevNode.getManagementIP(), (Object)ex);
                    throw new ToolException("execute cmd error", false);
                }
            }
            LOGGER.error("Node {} ssh connection is null or unconnected", (Object)fsDevNode.getManagementIP());
            throw new ToolException("execute cmd error", false);
        }
        catch (Exception e) {
            LOGGER.error("Node {} exec cmd error.", (Object)fsDevNode.getManagementIP(), (Object)e);
            throw new ToolException("execute cmd error", false);
        }
    }

    public static List<String> executeFsDevNodeCmdWithTimeOut(FSDevNode fsDevNode, String cmd, boolean isLog, int timeOut) throws ToolException {
        DevNode devNode = CommonUtils.transFsDevNode2DevNode(fsDevNode);
        ICliConnection ssh = null;
        try {
            ssh = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
            return CommonUtils.execAndGetReturnWithTimeOut(cmd, isLog, ssh, timeOut);
        }
        catch (com.huawei.ism.tool.obase.exception.ToolException e) {
            if (ssh != null && !ssh.isConnected()) {
                LOGGER.info("Connection for {} is close, retry 1 time.", (Object)fsDevNode.getManagementIP());
                SshConnectionManager.releaseConnection((ICliConnection)ssh);
                CommonUtils.safeSleep(3000);
                return CommonUtils.executeAgain(fsDevNode, cmd, isLog, timeOut, devNode);
            }
            LOGGER.error("Node {} ssh connection is null or unconnected", (Object)fsDevNode.getManagementIP());
            throw new ToolException("execute cmd error", false);
        }
        catch (Exception e) {
            LOGGER.error("Node {} exec cmd {} error.", new Object[]{fsDevNode.getManagementIP(), cmd, e});
            throw new ToolException("execute cmd error", false);
        }
    }

    private static List<String> executeAgain(FSDevNode fsDevNode, String cmd, boolean isLog, int timeOut, DevNode devNode) throws ToolException {
        try {
            ICliConnection ssh = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
            return CommonUtils.execAndGetReturnWithTimeOut(cmd, isLog, ssh, timeOut);
        }
        catch (Exception e) {
            LOGGER.error("Node {} exec cmd {} error.", new Object[]{fsDevNode.getManagementIP(), cmd, e});
            throw new ToolException("execute cmd error", false);
        }
    }

    public static String executeCmdWithLogAndGetRecord(FSDevNode fsDevNode, String cmd, boolean log) throws ToolException {
        DevNode devNode = CommonUtils.transFsDevNode2DevNode(fsDevNode);
        ICliConnection ssh = null;
        try {
            ssh = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
            return CommonUtils.execCmd(cmd, log, ssh);
        }
        catch (com.huawei.ism.tool.obase.exception.ToolException e) {
            if (null != ssh && !ssh.isConnected()) {
                LOGGER.info("Connection for {} is close, retry 1 time.", (Object)fsDevNode.getManagementIP());
                SshConnectionManager.releaseConnection((ICliConnection)ssh);
                CommonUtils.safeSleep(3000);
                try {
                    ssh = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
                    return CommonUtils.execCmd(cmd, log, ssh);
                }
                catch (Exception ex) {
                    LOGGER.error("Node {} exec cmd error.", (Object)fsDevNode.getManagementIP(), (Object)ex);
                    throw new ToolException("execute cmd error", false);
                }
            }
            throw new ToolException("execute cmd error", false);
        }
        catch (Exception e) {
            LOGGER.error("Node {} exec cmd error.", (Object)fsDevNode.getManagementIP(), (Object)e);
            throw new ToolException("execute cmd error", false);
        }
    }

    private static String execCmd(String cmd, boolean log, ICliConnection ssh) throws com.huawei.ism.tool.obase.exception.ToolException {
        if (log) {
            return ssh.execCmd(cmd);
        }
        return ssh.execCmdNoLog(cmd);
    }

    private static List<String> execAndGetReturn(String cmd, boolean needLog, ICliConnection ssh) throws com.huawei.ism.tool.obase.exception.ToolException {
        String cmdResult = needLog ? ssh.execCmd(cmd) : ssh.execCmdNoLog(cmd);
        if (StringUtils.isNULLStr((String)cmdResult)) {
            return Collections.emptyList();
        }
        List<String> resultList = Arrays.asList(cmdResult.split("\n"));
        if (resultList.size() <= 1) {
            LOGGER.info("Parsing result error,original ret: {}", (Object)cmdResult);
            return resultList;
        }
        return resultList.subList(1, resultList.size() - 1);
    }

    private static List<String> execAndGetReturnWithTimeOut(String cmd, boolean isLog, ICliConnection ssh, int timeOut) throws com.huawei.ism.tool.obase.exception.ToolException {
        String cmdResult = isLog ? ssh.execCmdWithTimout(cmd, timeOut) : ssh.execCmdNoLogTimout(cmd, timeOut);
        if (StringUtils.isNULLStr((String)cmdResult)) {
            return Collections.emptyList();
        }
        List<String> resultList = Arrays.asList(cmdResult.split("\n"));
        if (resultList.size() <= 1) {
            LOGGER.info("Parsing result error,original ret: {}", (Object)cmdResult);
            return resultList;
        }
        return resultList.subList(1, resultList.size() - 1);
    }

    public static void safeSleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            LOGGER.error("sleep error.");
        }
    }

    public static List<String> getIpFromText(String text) {
        ArrayList<String> ipSet = new ArrayList<String>();
        Matcher ipv4 = IPV4_PATTERN.matcher(text);
        Matcher ipv6 = IPV6_PATTERN.matcher(text);
        while (ipv4.find()) {
            String ipv4Str = ipv4.group();
            if (StringUtils.isNULLStr((String)ipv4Str)) continue;
            ipSet.add(ipv4Str.replaceAll("\\|", EMPTY_VALUE));
        }
        while (ipv6.find()) {
            String ipv6Str = ipv6.group();
            if (StringUtils.isNULLStr((String)ipv6Str)) continue;
            ipSet.add(ipv6Str.replaceAll("\\|", EMPTY_VALUE));
        }
        return ipSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSystemConfig(String key, String defValue) {
        try (FileInputStream in = new FileInputStream(SYSTEM_CONFIG_PATH);){
            Properties config = new Properties();
            config.load(in);
            String string = config.getProperty(key, defValue);
            return string;
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static boolean showWaringInfoAndConfirmContinue(List<FSDevNode> nodes, FsUpgradeFlowService service) {
        List<FSDevNode> needConfirmNodes = nodes.stream().filter(node -> !StringUtils.isNULLStr((String)node.getErrorDescription())).collect(Collectors.toList());
        if (needConfirmNodes.isEmpty()) {
            return true;
        }
        String errorMsg = ((FSDevNode)((Object)needConfirmNodes.get(0))).getErrorDescription();
        if (!StringUtils.isNULLStr((String)errorMsg)) {
            WarningDialog dialog;
            if (needConfirmNodes.size() > 1) {
                errorMsg = ResourceUtil.getString((String)"upgrade.compute.node.dpc.all.waring");
            }
            if ((dialog = DialogUtils.showYesNoDialog((Window)UpgradeContext.getInstance().getMainDialog(), (String)(errorMsg + ResourceUtil.getString((String)"upgrade.compute.node.dpc.cpu.waring1")))).getValue() != 0) {
                LOGGER.info("User select cancel to continue.");
                return false;
            }
        }
        needConfirmNodes.forEach(FSDevNode::clearMsg);
        service.changeAutoAnswer2Yes();
        return true;
    }

    public static String getTitleFromBtn(JButton button) {
        String btnTxt;
        if (button == null || button.getText() == null) {
            return EMPTY_VALUE;
        }
        String title = btnTxt = button.getText();
        int endIndex = btnTxt.indexOf(LEFT_BRACKET);
        if (endIndex != -1) {
            title = btnTxt.substring(0, endIndex);
        }
        return title;
    }

    public static void closeConnection(FSDevNode fsDevNode) {
        DevNode devNode = CommonUtils.transFsDevNode2DevNode(fsDevNode);
        SshConnectionManager.releaseConnection((DevNode)devNode);
    }

    public static void switchToRootIfNeed(FSDevNode fsDevNode) {
        DevNode devNode = CommonUtils.transFsDevNode2DevNode(fsDevNode);
        ICliConnection ssh = null;
        try {
            ssh = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
            SshConnection.switchToRootIfNeeded((DevNode)devNode, (ICliConnection)ssh);
        }
        catch (com.huawei.ism.tool.obase.exception.ToolException e) {
            if (null != ssh && !ssh.isConnected()) {
                LOGGER.info("Connection for {} is close, retry 1 time.", (Object)fsDevNode.getManagementIP());
                SshConnectionManager.releaseConnection((ICliConnection)ssh);
                CommonUtils.safeSleep(3000);
                try {
                    ssh = SshConnectionManager.getSshConnection((DevNode)devNode, (ISshJudge)DEFAULT_SSH_JUDGE);
                    SshConnection.switchToRootIfNeeded((DevNode)devNode, (ICliConnection)ssh);
                }
                catch (Exception ex) {
                    LOGGER.error("Node {} switch to root error.", (Object)fsDevNode.getManagementIP(), (Object)ex);
                }
            }
            LOGGER.error("Node {} ssh connection is null or unconnected", (Object)fsDevNode.getManagementIP());
        }
        catch (Exception e) {
            LOGGER.error("Node {} switch to root error.", (Object)fsDevNode.getManagementIP(), (Object)e);
        }
    }

    public static boolean queryIsUpgrading(FSDevNode fsNode) {
        String cmd = "ps -ef|grep compute_upgrade|grep -v grep";
        try {
            List<String> ret = CommonUtils.executeFsDevNodeCmdWithTimeOut(fsNode, cmd, true, 30);
            return !ret.isEmpty() && ret.stream().anyMatch(retLine -> retLine.contains("compute_upgrade.sh") || retLine.contains("compute_upgrade_inner.sh"));
        }
        catch (ToolException e) {
            LOGGER.error("Query upgrade progress failed.", (Throwable)e);
            return false;
        }
    }

    public static boolean queryIsRollbackRunning(FSDevNode fsNode) {
        String cmd = "ps -ef | grep -E 'compute_rollback.sh|compute_rollback_inner.sh' | grep -v grep | wc -l";
        try {
            List<String> rets = CommonUtils.executeFsDevNodeCmd(fsNode, cmd, true);
            Integer rollbackProcessesNum = Integer.valueOf(rets.stream().map(ret -> ret.trim()).findFirst().orElse("0"));
            return !rets.isEmpty() && rollbackProcessesNum > 0;
        }
        catch (ToolException e) {
            LOGGER.error("Query rollback progress failed.", (Throwable)e);
            return false;
        }
    }

    public static void initNodeResult(FSDevNode node) {
        if (Objects.nonNull(node.getComputeNodeUpgradeResult().getStartTime())) {
            log.info("compute Node Upgrade Result not null");
            return;
        }
        log.info("init compute Node Upgrade Result.");
        ComputeNodeUpgradeResult computeNodeUpgradeResult = new ComputeNodeUpgradeResult();
        computeNodeUpgradeResult.setStartTime(new Date());
        computeNodeUpgradeResult.setEndTime(new Date());
        node.setComputeNodeUpgradeResult(computeNodeUpgradeResult);
    }

    public static void computeNodeUpgradeResult2Json(ComputeNodeUpgradeResult computeResult) {
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(new Gson().toJson((Object)computeResult));
        StreamUtils.writeStringFormFile(strs, (String)DEVICELIST_PATH, (String)COMPUTE_RESULT_FILE_NAME);
    }

    public static ComputeNodeUpgradeResult transJson2ComputeNodeUpgradeResult() {
        try {
            String dataFilePath = Paths.get(DEVICELIST_PATH, COMPUTE_RESULT_FILE_NAME).toString();
            File filePath = new File(dataFilePath);
            if (!filePath.exists()) {
                return new ComputeNodeUpgradeResult();
            }
            String jsonStr = CommonUtils.readFile(filePath);
            Gson gson = new Gson();
            return (ComputeNodeUpgradeResult)gson.fromJson(jsonStr, new TypeToken<ComputeNodeUpgradeResult>(){}.getType());
        }
        catch (JsonSyntaxException e) {
            LOGGER.info("parse local json {} fail", (Object)COMPUTE_RESULT_FILE_NAME);
            return new ComputeNodeUpgradeResult();
        }
    }

    public static boolean isDpcPrepare(List<FSDevNode> fsDevNodes) {
        boolean isComputeNodePrepare = Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(UpgradeContext.getInstance().getUpgradeScene());
        boolean isDpcNode = fsDevNodes.stream().anyMatch(FSDevNode::isDpcComputeNode);
        return isComputeNodePrepare && isDpcNode;
    }

    public static int countPullPkgSuccess(List<FSDevNode> fsDevNodes) {
        return (int)fsDevNodes.stream().filter(fsDevNode -> !fsDevNode.getUpgradeStatus().isUpgradePrepareStatus() || fsDevNode.getUpgradeStatus().isPullPkgSuccessStatus()).count();
    }

    public static List<FSDevNode> getNodeCanRollback(List<FSDevNode> fsDevNodes, boolean isDpc) {
        return fsDevNodes.stream().filter(devNode -> !devNode.getUpgradeStatus().isUpgradePrepareStatus() && !devNode.getUpgradeStatus().isSuccessStatus()).filter(fsDevNode -> isDpc ? !fsDevNode.isVbsNode() : fsDevNode.isVbsNode()).collect(Collectors.toList());
    }

    static {
        DEFAULT_SSH_JUDGE.appendSpecialEndStr(INTERACTIVE_KEY);
    }
}

