/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.utils;

import com.huawei.ism.tool.devicecenter.driver.model.ITDeviceType;
import com.huawei.ism.tool.devicecenter.entity.AbstractDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.excel.POIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;

public class ExcelUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ExcelUtils.class);
    private static final int EXCEL_ROW_NUM = 5;
    private static final int INDEX_NODE_NAME = 0;
    private static final int INDEX_NODE_IP = 1;
    private static final int INDEX_NODE_UNAME = 2;
    private static final int INDEX_NODE_PWD = 3;
    private static final int INDEX_NODE_PORT = 4;
    private static final int EXCEL_ROW_NUM_LIMIT = Integer.parseInt(ResourceUtil.getString((String)"upgrade.compute.node.import.template.large.limit"));
    private static final int EXCEL_FILE_SIZE_LIMIT = 0x4000000;

    public static void exportTemplate(List<FSDevNode> fsDevNodeList, String saveFilePath) throws IOException {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        sheet.setDefaultColumnWidth(32);
        workbook.setSheetName(0, ResourceUtil.getString((String)"upgrade.compute.node.import.template.sheet.name"));
        HSSFCellStyle lockStyle = workbook.createCellStyle();
        lockStyle.setLocked(true);
        lockStyle.setFillForegroundColor(IndexedColors.BLUE.getIndex());
        HSSFCellStyle unlockStyle = workbook.createCellStyle();
        unlockStyle.setLocked(false);
        ExcelUtils.initExportTemplateTableHead(sheet, lockStyle);
        for (int i = 0; i < fsDevNodeList.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            Cell ipCell = row.createCell(0);
            ipCell.setCellValue(fsDevNodeList.get(i).getManagementIP());
            for (int j = 1; j < 5; ++j) {
                Cell cell = row.createCell(j);
                cell.setCellStyle(unlockStyle);
            }
        }
        sheet.protectSheet(String.valueOf(((SecureRandom)SecurityUtils.createSecureRandom().orElseThrow(() -> new IOException("No such algorithm found"))).nextInt()));
        ExcelUtils.setSshForwardSheet(workbook, lockStyle);
        try (FileOutputStream fos = new FileOutputStream(saveFilePath);){
            workbook.write(fos);
        }
    }

    private static void setSshForwardSheet(HSSFWorkbook workbook, CellStyle lockStyle) {
        HSSFSheet sheet = workbook.createSheet(ResourceUtil.getString((String)"dsfwupgrade.wizard.selectnode.authenticate.forward"));
        sheet.setDefaultColumnWidth(32);
        CellRangeAddress cellAddresses = new CellRangeAddress(0, 0, 0, 4);
        sheet.addMergedRegion(cellAddresses);
        HSSFRow infoRow = sheet.createRow(0);
        infoRow.setHeight((short)(infoRow.getHeight() * 3));
        Cell infoCell = infoRow.createCell(0);
        infoCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.ssh.forward.tip"));
        infoCell.setCellStyle(lockStyle);
        infoCell.getCellStyle().setWrapText(true);
        ExcelUtils.initSshForwardTableHead(lockStyle, sheet);
    }

    private static void initSshForwardTableHead(CellStyle lockStyle, HSSFSheet sheet) {
        HSSFRow tableHeadRow = sheet.createRow(1);
        Cell nameCell = tableHeadRow.createCell(0);
        nameCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.ssh.forward.name"));
        nameCell.setCellStyle(lockStyle);
        Cell ipCell = tableHeadRow.createCell(1);
        ipCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.ssh.forward.ip"));
        ipCell.setCellStyle(lockStyle);
        Cell userNameCell = tableHeadRow.createCell(2);
        userNameCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.ssh.forward.user"));
        userNameCell.setCellStyle(lockStyle);
        Cell pwdCell = tableHeadRow.createCell(3);
        pwdCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.ssh.forward.pwd"));
        pwdCell.setCellStyle(lockStyle);
        Cell portCell = tableHeadRow.createCell(4);
        portCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.ssh.forward.port"));
        portCell.setCellStyle(lockStyle);
    }

    private static void initExportTemplateTableHead(Sheet sheet, CellStyle lockStyle) {
        Row tableHeadRow = sheet.createRow(0);
        Cell tableHeadIpCell = tableHeadRow.createCell(0);
        tableHeadIpCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.ip"));
        tableHeadIpCell.setCellStyle(lockStyle);
        Cell tableHeadUserCell = tableHeadRow.createCell(1);
        tableHeadUserCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.username"));
        tableHeadUserCell.setCellStyle(lockStyle);
        Cell tableHeadPasswordCell = tableHeadRow.createCell(2);
        tableHeadPasswordCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.password"));
        tableHeadUserCell.setCellStyle(lockStyle);
        Cell tableHeadRootPasswordCell = tableHeadRow.createCell(3);
        tableHeadRootPasswordCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.root.password"));
        tableHeadUserCell.setCellStyle(lockStyle);
        Cell tableHeadSshNameCell = tableHeadRow.createCell(4);
        tableHeadSshNameCell.setCellValue(ResourceUtil.getString((String)"upgrade.compute.node.excel.table.root.ssh.name"));
        tableHeadSshNameCell.setCellStyle(lockStyle);
    }

    public static List<AbstractDevice> importTemplate(List<FSDevNode> fsDevNodeList, File importFile) throws IOException, ToolException {
        if (importFile.length() > 0x4000000L) {
            throw new ToolException("upgrade.compute.node.import.template.too.large");
        }
        try (FileInputStream in = new FileInputStream(importFile);){
            HSSFWorkbook workBook = new HSSFWorkbook(in);
            HSSFSheet sheet = workBook.getSheetAt(0);
            int rows = sheet.getPhysicalNumberOfRows();
            if (rows > EXCEL_ROW_NUM_LIMIT) {
                LOGGER.error("excel rows num is to big");
                throw new ToolException("upgrade.compute.node.import.template.too.much", (Object[])new Integer[]{EXCEL_ROW_NUM_LIMIT});
            }
            KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap = ExcelUtils.parseSshSheet(workBook.getSheetAt(1));
            ArrayList<AbstractDevice> importExcelFSDevNode = new ArrayList<AbstractDevice>();
            for (int i = 1; i < rows; ++i) {
                String managementIp = sheet.getRow(i).getCell(0).getStringCellValue().trim();
                String userName = ExcelUtils.getCellValue(sheet.getRow(i).getCell(1)).trim();
                String password = ExcelUtils.getCellValue(sheet.getRow(i).getCell(2)).trim();
                String rootPassword = ExcelUtils.getCellValue(sheet.getRow(i).getCell(3)).trim();
                String sshName = ExcelUtils.getCellValue(sheet.getRow(i).getCell(4)).trim();
                if (!StringUtils.isNULLStr((String)sshName) && !sshMap.keySet().contains(sshName)) {
                    LOGGER.error("ssh forward name of computer node is not exist.");
                    throw new ToolException("upgrade.compute.node.import.template.forward.name.not.exist");
                }
                fsDevNodeList.stream().filter(node -> node.getManagementIP().equals(managementIp)).forEach(node -> {
                    node.setStartIPAddress(node.getManagementIP());
                    node.setEndIPAddress(node.getManagementIP());
                    node.setUserName(userName);
                    node.setUserPwd(password);
                    node.setRootPwd(rootPassword);
                    node.setItDeviceType(ITDeviceType.SERVER_OS);
                    node.setIp(node.getManagementIP());
                    node.setSshForwardList((List)sshMap.getOrDefault((Object)sshName, new ArrayList()));
                    importExcelFSDevNode.add((AbstractDevice)node);
                });
            }
            ArrayList<AbstractDevice> arrayList = importExcelFSDevNode;
            return arrayList;
        }
    }

    private static KeyOrderedHashMap<String, List<MultiRouteNode>> parseSshSheet(Sheet sshInfoSheet) throws ToolException {
        int rows = sshInfoSheet.getLastRowNum() + 1;
        KeyOrderedHashMap sshMap = new KeyOrderedHashMap();
        for (int startLine = 2; startLine < rows; ++startLine) {
            Pair<Boolean, Integer> mergedResultPair = ExcelUtils.handleMergedCell(sshInfoSheet, startLine, (KeyOrderedHashMap<String, List<MultiRouteNode>>)sshMap);
            if (((Boolean)mergedResultPair.getLeft()).booleanValue()) {
                startLine = (Integer)mergedResultPair.getRight();
                continue;
            }
            String name = POIUtils.getStringCellValue((Cell)sshInfoSheet.getRow(startLine).getCell(0)).trim();
            String ip = POIUtils.getStringCellValue((Cell)sshInfoSheet.getRow(startLine).getCell(1)).trim();
            if (StringUtils.isNULLStr((String)name) && StringUtils.isNULLStr((String)ip)) continue;
            if (StringUtils.isNULLStr((String)name) && !StringUtils.isNULLStr((String)ip)) {
                LOGGER.error("ssh forward name is empty.");
                throw new ToolException("upgrade.compute.node.import.template.forward.name.empty");
            }
            ExcelUtils.checkNameValid((KeyOrderedHashMap<String, List<MultiRouteNode>>)sshMap, name);
            ArrayList<MultiRouteNode> listMu = new ArrayList<MultiRouteNode>();
            MultiRouteNode multiRouteNode = ExcelUtils.getNewMu(sshInfoSheet, startLine);
            ExcelUtils.addMultiRouteNode(listMu, multiRouteNode);
            sshMap.put((Object)name, listMu);
        }
        return sshMap;
    }

    private static void addMultiRouteNode(List<MultiRouteNode> listMu, MultiRouteNode multiRouteNode) throws ToolException {
        if (listMu.stream().map(MultiRouteNode::getHost).anyMatch(multiRouteNode.getHost()::equalsIgnoreCase)) {
            LOGGER.error("ssh forward node is repeated.");
            throw new ToolException("upgrade.compute.node.import.template.forward.node.repeated");
        }
        listMu.add(multiRouteNode);
    }

    private static boolean checkNameValid(KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap, String name) throws ToolException {
        if (!StringUtils.hasMatchStr((String)name, (String)"^[a-zA-Z_][0-9a-zA-Z_-]*")) {
            LOGGER.error("ssh forward name is illegal.");
            throw new ToolException("upgrade.compute.node.import.template.forward.name.illegal");
        }
        if (sshMap.keySet().contains(name)) {
            LOGGER.error("ssh forward name is repeated.");
            throw new ToolException("upgrade.compute.node.import.template.forward.name.repeated");
        }
        return true;
    }

    private static Pair<Boolean, Integer> handleMergedCell(Sheet sshInfoSheet, int startLine, KeyOrderedHashMap<String, List<MultiRouteNode>> sshMap) throws ToolException {
        int tempStartLine = startLine;
        for (CellRangeAddress space : sshInfoSheet.getMergedRegions()) {
            int startUniteLine = space.getFirstRow();
            int endUniteLine = space.getLastRow();
            if (endUniteLine == 0 || tempStartLine < startUniteLine || tempStartLine > endUniteLine) continue;
            Row row = sshInfoSheet.getRow(tempStartLine);
            String name = POIUtils.getStringCellValue((Cell)row.getCell(0));
            ExcelUtils.checkNameValid(sshMap, name);
            ArrayList<MultiRouteNode> listMu = new ArrayList<MultiRouteNode>();
            while (startUniteLine <= endUniteLine) {
                MultiRouteNode multiRouteNode = ExcelUtils.getNewMu(sshInfoSheet, startUniteLine);
                ExcelUtils.addMultiRouteNode(listMu, multiRouteNode);
                tempStartLine = startUniteLine++;
            }
            if (!listMu.isEmpty()) {
                sshMap.put((Object)name, listMu);
            }
            return Pair.of((Object)true, (Object)tempStartLine);
        }
        return Pair.of((Object)false, (Object)tempStartLine);
    }

    private static MultiRouteNode getNewMu(Sheet sshInfoSheet, int line) throws ToolException {
        Row row = sshInfoSheet.getRow(line);
        String host = POIUtils.getStringCellValue((Cell)row.getCell(1));
        String uName = POIUtils.getStringCellValue((Cell)row.getCell(2));
        String pwd = POIUtils.getStringCellValue((Cell)row.getCell(3));
        int port = StringUtils.str2Int((String)POIUtils.getStringCellValue((Cell)row.getCell(4)));
        MultiRouteNode multiRouteNode = new MultiRouteNode(host, port, uName, pwd);
        if (!multiRouteNode.isValid()) {
            LOGGER.error("ssh forward node has invalid params.");
            throw new ToolException("upgrade.compute.node.import.template.forward.node.invalid");
        }
        return multiRouteNode;
    }

    public static String getCellValue(Cell cell) {
        DataFormatter formatter = new DataFormatter();
        return formatter.formatCellValue(cell);
    }
}

