/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.utils;

import com.huawei.ism.tool.distributedfwupg.utils.UpgradeContext;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PackageConfigLoader {
    private static final PackageConfigLoader INSTANCE = new PackageConfigLoader();
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PackageConfigLoader.class);
    private static final File STRATEGY_FILE = new File(new File(ApplicationContext.getInstance().getWorkPath()), "packages" + File.separator + "fusion_storage" + File.separator + "strategy.xml");

    private PackageConfigLoader() {
    }

    public static PackageConfigLoader getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStrategy() {
        Element root;
        File file = STRATEGY_FILE;
        if (!file.exists()) {
            LOGGER.info("not found file:{}", (Object)file);
            return;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Document doc = XmlUtils.parseDocument((InputStream)in);
            root = doc.getDocumentElement();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Failed to load strategy.xml ");
            return;
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)in);
        }
        Collection supportsByScene = XmlUtils.getChildren((Element)root, (String)"product");
        for (Element supportByScene : supportsByScene) {
            if (!this.inScene(XmlUtils.getTextContentOfChild((Element)supportByScene, (String)"scene"))) continue;
            PackageConfigLoader.loadSupportVersions(supportByScene);
            return;
        }
        PackageConfigLoader.loadSupportVersions(XmlUtils.getChild((Element)root, (String)"default"));
    }

    private boolean inScene(String sceneInfos) {
        if (StringUtils.isNULLStr((String)sceneInfos)) {
            return false;
        }
        return Arrays.stream(sceneInfos.split(",")).anyMatch(scene -> scene.equals(UpgradeContext.getInstance().getUpgradeScene()));
    }

    private static void loadSupportVersions(Element product) {
        if (product == null) {
            return;
        }
        String supportVersions = XmlUtils.getTextContentOfChild((Element)product, (String)"supportversion");
        List<DeviceType> supportDevTypes = PackageConfigLoader.getSupportOrExcludeTypes(supportVersions);
        UpgradeContext.getInstance().setSupportDevTypeList(supportDevTypes);
        PackageConfigLoader.initComputeBlackVersionConfig(product);
        Element supportDescElem = XmlUtils.getChild((Element)product, (String)"supportdesc");
        List<Map<String, String>> supportDescList = PackageConfigLoader.loadSupportDesc(supportDescElem);
        UpgradeContext.getInstance().setSupportDesc(supportDescList);
        String servertypeStr = XmlUtils.getTextContentOfChild((Element)product, (String)"servertype");
        List<DeviceType> supportServerList = PackageConfigLoader.getSupportOrExcludeTypes(servertypeStr);
        UpgradeContext.getInstance().setSupportServerTypeList(supportServerList);
    }

    private static void initComputeBlackVersionConfig(Element product) {
        if (UpgradeContext.getInstance().isComputeUpgradeScene()) {
            LOGGER.info("init compute upgrade black version");
            String blackVersions = XmlUtils.getTextContentOfChild((Element)product, (String)"blackversion");
            UpgradeContext.getInstance().setBlackDevTypes(PackageConfigLoader.getSupportOrExcludeTypes(blackVersions));
        }
    }

    private static List<Map<String, String>> loadSupportDesc(Element logicElement) {
        ArrayList<Map<String, String>> supportDescList = new ArrayList<Map<String, String>>();
        for (Element typeElement : XmlUtils.getChildren((Element)logicElement, (String)"type")) {
            HashMap<String, String> supportDesc = new HashMap<String, String>();
            supportDesc.put("devType", typeElement.getAttribute("devType"));
            supportDesc.put("version", typeElement.getAttribute("version"));
            supportDesc.put("serverType", typeElement.getAttribute("serverType"));
            supportDescList.add(supportDesc);
        }
        return supportDescList;
    }

    private static List<DeviceType> getSupportOrExcludeTypes(String supportVersions) {
        String[] vers;
        ArrayList<DeviceType> supportList = new ArrayList<DeviceType>();
        for (String ver : vers = supportVersions.split(",")) {
            supportList.add(DeviceType.valueOf((String)ver.trim()));
        }
        return supportList;
    }
}

