/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.utils;

import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.FSDevNode;
import com.huawei.ism.tool.distributedfwupg.observer.IUpdateUIObserver;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.distributedfwupg.utils.CommonUtils;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.ISceneBean;
import com.huawei.ism.tool.framework.pubservice.entity.ScenePathValue;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeContext
extends AbstractContext {
    private static final Logger log = LoggerFactory.getLogger(UpgradeContext.class);
    private static final UpgradeContext INSTANCE = new UpgradeContext();
    private static final String SCENE_RESULT_PATH = "jsonSceneResultPath";
    private IUpdateUIObserver uiObserver;
    private JDialog mainDialog;
    private JDialog dialog;
    private JDialog wizardDialog;
    private List<Map<String, String>> supportDesc;
    private List<DeviceType> supportDevTypeList = new ArrayList<DeviceType>();
    private List<DeviceType> blackDevTypes = new ArrayList<DeviceType>();
    private List<DeviceType> supportServerTypeList = new ArrayList<DeviceType>();
    private String upgradeScene;
    private String batchId;

    public static UpgradeContext getInstance() {
        return INSTANCE;
    }

    public IUpdateUIObserver getUiObserver() {
        return this.uiObserver;
    }

    public void setUiObserver(IUpdateUIObserver uiObserver) {
        this.uiObserver = uiObserver;
    }

    public JDialog getMainDialog() {
        return this.mainDialog;
    }

    public void setMainDialog(JDialog mainDialog) {
        this.mainDialog = mainDialog;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
    }

    public void setWizardDialog(JDialog wizardDialog) {
        this.wizardDialog = wizardDialog;
    }

    public JDialog getWizardDialog() {
        return this.wizardDialog;
    }

    public List<Map<String, String>> getSupportDesc() {
        if (this.supportDesc == null) {
            this.supportDesc = new ArrayList<Map<String, String>>();
        }
        return this.supportDesc;
    }

    public void setSupportDesc(List<Map<String, String>> supportDesc) {
        this.supportDesc = supportDesc;
    }

    public List<DeviceType> getSupportDevTypeList() {
        return this.supportDevTypeList;
    }

    public void setSupportDevTypeList(List<DeviceType> supportDevTypeList) {
        this.supportDevTypeList = supportDevTypeList;
    }

    public List<DeviceType> getSupportServerTypeList() {
        return this.supportServerTypeList;
    }

    public void setSupportServerTypeList(List<DeviceType> supportServerTypeList) {
        this.supportServerTypeList = supportServerTypeList;
    }

    public void clear() {
        this.wizardDialog = null;
    }

    public String getUpgradeScene() {
        return this.upgradeScene;
    }

    public void setUpgradeScene(String upgradeScene) {
        this.upgradeScene = upgradeScene;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public boolean needOsAuth() {
        if (Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(this.upgradeScene)) {
            return Boolean.parseBoolean(CommonUtils.getSystemConfig("fw.os.auth.check", "true"));
        }
        return true;
    }

    public boolean needBmcAuth() {
        if (Constants.FsUpgradeScene.FirmwarePrepare.getDesc().equals(this.upgradeScene)) {
            return Boolean.parseBoolean(CommonUtils.getSystemConfig("fw.bmc.auth.check", "true"));
        }
        return !Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(this.upgradeScene);
    }

    public boolean isComputeUpgradeScene() {
        return Constants.FsUpgradeScene.ComputeNodePrepare.getDesc().equals(this.upgradeScene) || Constants.FsUpgradeScene.ComputeNodeUpgrade.getDesc().equals(this.upgradeScene);
    }

    public boolean isDpcUpgrade() {
        return FsUpgradeService.getCurUpgradeFsDev(false).getFsDevNodeList().stream().anyMatch(FSDevNode::isDpcComputeNode);
    }

    public void setSceneCollectDir() {
        HibernateContainer.getInstance().put("BundleUpgradeResult", (Object)this.getSceneCollectDir());
    }

    public String getSceneCollectDir() {
        ScenePathValue scenePathValue = new ScenePathValue("");
        try {
            ISceneBean envirValueByKey = SceneEnvironmentImpl.getInstance().getEnvirValueByKey(SCENE_RESULT_PATH);
            if (envirValueByKey instanceof ScenePathValue) {
                scenePathValue = (ScenePathValue)envirValueByKey;
            }
            return scenePathValue.getJsonSceneResultPathValue();
        }
        catch (ToolException e) {
            log.error("can't get scene path value", (Throwable)e);
            return "";
        }
    }

    public static String getBatchIdFromFSClusterDevice() {
        FSClusterDevice fsClusterDevice = FsUpgradeService.getCurUpgradeFsDev(false);
        String floatIp2FileName = fsClusterDevice.getFloatIp2FileName();
        SimpleDateFormat formatter = new SimpleDateFormat("_yyyyMMdd_HHmm");
        String timeStr = formatter.format(new Date());
        return floatIp2FileName.concat(timeStr);
    }

    public void setBlackDevTypes(List<DeviceType> blackDevTypes) {
        this.blackDevTypes = blackDevTypes;
    }

    public List<DeviceType> getBlackDevTypes() {
        return this.blackDevTypes;
    }
}

