/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.utils;

import com.huawei.bundleupgrade.utils.DomXMLUtil;
import com.huawei.ism.tool.distributedfwupg.entity.Constants;
import com.huawei.ism.tool.distributedfwupg.entity.FSClusterDevice;
import com.huawei.ism.tool.distributedfwupg.entity.UpgradeScriptConfig;
import com.huawei.ism.tool.distributedfwupg.service.FsUpgradeService;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpgradeScriptConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeScriptConfigUtils.class);
    private static List<UpgradeScriptConfig> configList;
    private static final String UPGRADE_CONFIG_XML_PATH;
    private static final String WORK_PATH;
    private static final String COMMA = ",";
    private static UpgradeScriptConfig nowDevConfig;

    public static synchronized UpgradeScriptConfig getUpgradeScriptConfig() {
        return nowDevConfig;
    }

    private static void init() {
        UpgradeScriptConfigUtils.initconfig();
        FSClusterDevice clusterDev = FsUpgradeService.getCurUpgradeFsDev(false);
        for (UpgradeScriptConfig config : configList) {
            if (!config.isSupport(clusterDev)) continue;
            nowDevConfig = config;
            return;
        }
    }

    private static void initconfig() {
        configList = new ArrayList<UpgradeScriptConfig>();
        File configXml = new File(UPGRADE_CONFIG_XML_PATH);
        if (!configXml.exists()) {
            LOGGER.error("upgrade_config is no exists.");
            return;
        }
        try (FileInputStream stream = new FileInputStream(configXml);){
            Document document = DomXMLUtil.parseDocument(stream);
            if (null == document) {
                LOGGER.error("Failed to parse the upgrade_config XML file.");
                return;
            }
            UpgradeScriptConfigUtils.builedConfigList(document);
        }
        catch (FileNotFoundException exp) {
            LOGGER.error("Init upgrade_config error.");
        }
        catch (Exception exp) {
            LOGGER.error("Init upgrade_config error.", (Throwable)exp);
        }
    }

    private static void builedConfigList(Document document) {
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)document, (String)"configs/config");
        if (nodeList == null) {
            LOGGER.error("config xml search is null");
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            UpgradeScriptConfigUtils.builedUpgradeScriptConfig(node).ifPresent(config -> configList.add((UpgradeScriptConfig)config));
        }
    }

    private static Optional<UpgradeScriptConfig> builedUpgradeScriptConfig(Node node) {
        String productVersions;
        String productModels;
        if (!(node instanceof Element)) {
            return Optional.empty();
        }
        Element config = (Element)node;
        String name = XmlUtils.getTextContentOfChild((Element)config, (String)"scriptName");
        if (StringUtils.isNULLStr((String)name)) {
            return Optional.empty();
        }
        String execType = XmlUtils.getTextContentOfChild((Element)config, (String)"scriptExecType");
        UpgradeScriptConfig upgradeScriptConfig = new UpgradeScriptConfig();
        upgradeScriptConfig.setScriptName(name);
        upgradeScriptConfig.setScriptExecType(execType);
        String path = XmlUtils.getTextContentOfChild((Element)config, (String)"scriptPath");
        if (!StringUtils.isNULLStr((String)path)) {
            upgradeScriptConfig.setScriptPath(WORK_PATH + path);
        }
        if (!StringUtils.isNULLStr((String)(productModels = XmlUtils.getTextContentOfChild((Element)config, (String)"productModels")))) {
            Collections.addAll(upgradeScriptConfig.getSupportModelSet(), productModels.split(COMMA));
        }
        if (!StringUtils.isNULLStr((String)(productVersions = XmlUtils.getTextContentOfChild((Element)config, (String)"productVersions")))) {
            Collections.addAll(upgradeScriptConfig.getSupportVersionSet(), productVersions.split(COMMA));
        }
        return Optional.of(upgradeScriptConfig);
    }

    static {
        UPGRADE_CONFIG_XML_PATH = Constants.LOCAL_UPGRADE_SCRIPT_PATH + File.separator + "upgrade_config.xml";
        WORK_PATH = ApplicationContext.getInstance().getWorkPath() + File.separator;
        UpgradeScriptConfigUtils.init();
    }
}

