/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.adaptor.impl;

import com.huawei.ism.tool.distributedfwupg.web.adaptor.CloudaUpgradeController;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ComputeUpgradeService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CloudaUpgradeControllerImpl
implements CloudaUpgradeController {
    private static final Logger log = LoggerFactory.getLogger(CloudaUpgradeControllerImpl.class);
    private final ComputeUpgradeService upgradeService;
    private final UpgradeStatusService upgradeStatusService;

    @Override
    public Response<?> startUpgradeTask(List<String> clusterIds, String type) {
        log.info("start upgrade clouda task for device :{}", clusterIds);
        this.upgradeStatusService.checkDeviceStatus(clusterIds, UpgradeOption.UPGRADE_CLOUD_A);
        this.upgradeService.startUpgradeClouda(clusterIds);
        log.info("start upgrade clouda task success");
        return Response.success();
    }

    public CloudaUpgradeControllerImpl(ComputeUpgradeService upgradeService, UpgradeStatusService upgradeStatusService) {
        this.upgradeService = upgradeService;
        this.upgradeStatusService = upgradeStatusService;
    }
}

