/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.adaptor.impl;

import com.huawei.ism.tool.distributedfwupg.web.adaptor.CommonUpgradeController;
import com.huawei.ism.tool.distributedfwupg.web.application.factory.UpgradeFuncFactory;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ComputeUpgradeService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ReportService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CommonUpgradeControllerImpl
implements CommonUpgradeController {
    private static final Logger log = LoggerFactory.getLogger(CommonUpgradeControllerImpl.class);
    private final UpgradeStatusService upgradeStatusService;
    private final UpgradeFuncFactory upgradeFuncFactory;
    private final ComputeUpgradeService computeUpgradeService;
    private final ReportService reportService;

    @Override
    public Response<?> startUpgradeTask(List<String> clusterIds, String type) {
        log.info("start task for type :{}", (Object)type);
        UpgradeOption upgradeOption = UpgradeOption.of(type);
        this.upgradeStatusService.checkDeviceStatus(clusterIds, upgradeOption);
        this.upgradeFuncFactory.queryOptionFunc(upgradeOption).accept(clusterIds);
        log.info("start task for type :{} success", (Object)type);
        return Response.success();
    }

    @Override
    public Response<?> retryTask(List<String> clusterIds) {
        log.info("start retry task for device :{}", clusterIds);
        this.computeUpgradeService.startRetry(clusterIds);
        log.info("start retry task success");
        return Response.success();
    }

    @Override
    public Response<?> refreshEditableStatus(List<String> clusterIds) {
        log.info("start to refresh for device :{}", clusterIds);
        this.computeUpgradeService.refreshEditableStatus(clusterIds);
        log.info("start to refresh success");
        return Response.success((Object)"");
    }

    @Override
    public Response<?> exportReport() {
        log.info("start export report for upgrade");
        String result = this.reportService.exportReport();
        log.info("start export report for upgrade success");
        return Response.success((Object)result);
    }

    public CommonUpgradeControllerImpl(UpgradeStatusService upgradeStatusService, UpgradeFuncFactory upgradeFuncFactory, ComputeUpgradeService computeUpgradeService, ReportService reportService) {
        this.upgradeStatusService = upgradeStatusService;
        this.upgradeFuncFactory = upgradeFuncFactory;
        this.computeUpgradeService = computeUpgradeService;
        this.reportService = reportService;
    }
}

