/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.adaptor.impl;

import com.huawei.ism.tool.distributedfwupg.web.adaptor.ComputeNodeUpgradeController;
import com.huawei.ism.tool.distributedfwupg.web.application.service.ComputeUpgradeService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ComputeUpgradeControllerImpl
implements ComputeNodeUpgradeController {
    private static final Logger log = LoggerFactory.getLogger(ComputeUpgradeControllerImpl.class);
    private final ComputeUpgradeService deviceUpgradeService;
    private final UpgradeStatusService upgradeStatusService;
    private final Map<UpgradeOption, Consumer<List<String>>> func = new HashMap<UpgradeOption, Consumer<List<String>>>();

    @PostConstruct
    public void init() {
        this.func.put(UpgradeOption.PRE_CHECK, this.deviceUpgradeService::startUpgradePreCheck);
        this.func.put(UpgradeOption.COMPUTE_UPGRADE, this.deviceUpgradeService::startUpgrade);
        this.func.put(UpgradeOption.CONFIRM_UPGRADE, this.deviceUpgradeService::confirmUpgrade);
    }

    @Override
    public Response<?> startUpgradeTask(List<String> deviceIds, String type) {
        log.info("start :{} task for device :{}", (Object)type, deviceIds);
        UpgradeOption upgradeOption = UpgradeOption.of(type);
        this.upgradeStatusService.checkDeviceStatus(deviceIds, upgradeOption);
        this.func.get((Object)upgradeOption).accept(deviceIds);
        log.info("start :{} task success", (Object)type);
        return Response.success();
    }

    public ComputeUpgradeControllerImpl(ComputeUpgradeService deviceUpgradeService, UpgradeStatusService upgradeStatusService) {
        this.deviceUpgradeService = deviceUpgradeService;
        this.upgradeStatusService = upgradeStatusService;
    }
}

