/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.action;

import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.ConfirmUpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeEvent;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="confirmUpgradeAction")
public class ConfirmUpgradeAction
implements Action<ConfirmUpgradeStatus, UpgradeEvent> {
    private final DeviceResultCache deviceResultCache;

    @UpdateClusterStatus
    public Optional<UpgradeEvent> execute(ExecuteContext<ConfirmUpgradeStatus, UpgradeEvent> context) {
        DevNode node = (DevNode)context.get((Object)"devNode");
        UpgradeResult deviceResult = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), UpgradeOption.CONFIRM_UPGRADE).getUpgradeResult();
        try {
            deviceResult.setStartTime();
            UpgradeRestUtil.requestConfirmUpgrade(node);
            return Optional.of(UpgradeEvent.QUERY_RESULT);
        }
        catch (ToolException e) {
            deviceResult.appendMessage(e.getErrorLocaleDescription());
            deviceResult.setTaskStatus(ConfirmUpgradeStatus.FAILURE);
            deviceResult.setEndTime();
            return Optional.of(UpgradeEvent.ERROR);
        }
    }

    public ConfirmUpgradeAction(DeviceResultCache deviceResultCache) {
        this.deviceResultCache = deviceResultCache;
    }
}

