/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.action;

import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.ConfirmUpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeEvent;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="postUpgradeHandleAction")
public class PostUpgradeHandleAction
implements Action<ConfirmUpgradeStatus, UpgradeEvent> {
    private final DeviceResultCache deviceResultCache;

    @UpdateClusterStatus
    public Optional<UpgradeEvent> execute(ExecuteContext<ConfirmUpgradeStatus, UpgradeEvent> context) {
        DevNode devNode = (DevNode)context.get((Object)"devNode");
        UpgradeResult deviceResult = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(devNode), UpgradeOption.CONFIRM_UPGRADE).getUpgradeResult();
        try {
            deviceResult.setEndTime();
            UpgradeRestUtil.requestExitUpgrade(devNode);
            deviceResult.setTaskStatus(ConfirmUpgradeStatus.FINISH);
            deviceResult.setProgress(100);
            return Optional.of(UpgradeEvent.EXIT_UPGRADE);
        }
        catch (ToolException e) {
            String messageTip = ResourceUtil.getString((String)"exit.upgrade.error");
            deviceResult.setTaskStatus(ConfirmUpgradeStatus.FAILURE);
            deviceResult.appendMessage(String.join((CharSequence)System.lineSeparator(), messageTip, e.getErrorLocaleDescription()));
            deviceResult.setEndTime();
            return Optional.of(UpgradeEvent.ERROR);
        }
    }

    public PostUpgradeHandleAction(DeviceResultCache deviceResultCache) {
        this.deviceResultCache = deviceResultCache;
    }
}

