/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.action;

import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.ReleaseConnection;
import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.application.checker.ProgressTimeoutChecker;
import com.huawei.ism.tool.distributedfwupg.web.application.service.DmeNodeFinishObserver;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.entity.ConfirmResult;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.ConfirmUpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.RollbackStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeEvent;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeTimeoutUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.stereotype.Component;

@Component(value="queryConfirmRollbackResultAction")
public class QueryConfirmRollbackResultAction
implements Action<RollbackStatus, UpgradeEvent> {
    private final DeviceResultCache deviceResultCache;
    private final UpgradeStatusService upgradeStatusService;
    private final DmeNodeFinishObserver dmeNodeFinishObserver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UpdateClusterStatus
    @ReleaseConnection
    public Optional<UpgradeEvent> execute(ExecuteContext<RollbackStatus, UpgradeEvent> context) {
        DevNode node = (DevNode)context.get((Object)"devNode");
        UpgradeResult deviceResult = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), UpgradeOption.CONFIRM_ROLLBACK).getUpgradeResult();
        deviceResult.initProgress();
        try {
            deviceResult.setTaskStatus(ConfirmUpgradeStatus.EXECUTING);
            UpgradeTaskStatus upgradeTaskStatus = this.upgradeStatusService.queryDeviceStatus(node);
            int progress = 0;
            ProgressTimeoutChecker timeoutChecker = ProgressTimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(120));
            while (Objects.equals((Object)UpgradeTaskStatus.ROLLBACKING, (Object)upgradeTaskStatus) || Objects.equals((Object)UpgradeTaskStatus.CONFIRMING, (Object)upgradeTaskStatus)) {
                ThreadUtils.sleep((long)5000L);
                upgradeTaskStatus = this.upgradeStatusService.queryDeviceStatus(node);
                deviceResult.setProgress(Math.min(progress += 20, 80));
                timeoutChecker.checkTimeout(deviceResult.getProgress());
            }
            deviceResult.setProgress(90);
            if (upgradeTaskStatus != UpgradeTaskStatus.CONFIRM_FAILURE) {
                deviceResult.setProgress(100);
                deviceResult.setTaskStatus(RollbackStatus.SUCCESS);
                Optional<UpgradeEvent> optional = Optional.of(UpgradeEvent.ROLLBACK_SUCCESS);
                return optional;
            }
            Object data = UpgradeRestUtil.queryConfirmResult(node).getContentMap().get("data");
            if (Objects.nonNull(data)) {
                this.parseResult(data, deviceResult);
            }
            deviceResult.appendMessage(ResourceUtil.getString((String)"rollback.confirm.error"));
            deviceResult.setTaskStatus(ConfirmUpgradeStatus.FAILURE);
            Optional<UpgradeEvent> optional = Optional.of(UpgradeEvent.ROLLBACK_FAILURE);
            return optional;
        }
        catch (ToolException e) {
            deviceResult.appendMessage(e.getErrorLocaleDescription());
            deviceResult.setTaskStatus(ConfirmUpgradeStatus.FAILURE);
        }
        finally {
            deviceResult.setEndTime();
            this.dmeNodeFinishObserver.notifyFinsh(node);
        }
        return Optional.of(UpgradeEvent.ERROR);
    }

    private void parseResult(Object data, UpgradeResult deviceResult) {
        if (data instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)data;
            if (jsonArray.length() == 0) {
                return;
            }
            deviceResult.setConfirmResult(IntStream.range(0, jsonArray.length()).mapToObj(arg_0 -> ((JSONArray)jsonArray).get(arg_0)).map(this::parseConfirmResult).collect(Collectors.toList()));
        }
    }

    private ConfirmResult parseConfirmResult(Object dataObj) {
        JSONObject jsonObject = QueryConfirmRollbackResultAction.getJsonObj(dataObj);
        ConfirmResult confirmResult = new ConfirmResult();
        confirmResult.setCode(jsonObject.getStringOrDefault("code", ""));
        confirmResult.setDescription(jsonObject.getStringOrDefault("description", ""));
        confirmResult.setSuggestion(jsonObject.getStringOrDefault("suggestion", ""));
        confirmResult.setComponentName(jsonObject.getStringOrDefault("componentName", ""));
        JSONArray nodes = jsonObject.getJSONArray("nodes");
        List<String> nodeIps = IntStream.range(0, nodes.length()).mapToObj(arg_0 -> ((JSONArray)nodes).get(arg_0)).map(Object::toString).collect(Collectors.toList());
        confirmResult.setFailedNodeIps(nodeIps);
        return confirmResult;
    }

    private static JSONObject getJsonObj(Object dataObj) {
        if (dataObj instanceof JSONObject) {
            return (JSONObject)dataObj;
        }
        return new JSONObject(dataObj);
    }

    public QueryConfirmRollbackResultAction(DeviceResultCache deviceResultCache, UpgradeStatusService upgradeStatusService, DmeNodeFinishObserver dmeNodeFinishObserver) {
        this.deviceResultCache = deviceResultCache;
        this.upgradeStatusService = upgradeStatusService;
        this.dmeNodeFinishObserver = dmeNodeFinishObserver;
    }
}

