/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.action;

import com.huawei.fitframework.core.common.util.ThreadUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.application.checker.ProgressTimeoutChecker;
import com.huawei.ism.tool.distributedfwupg.web.entity.ResultDetail;
import com.huawei.ism.tool.distributedfwupg.web.enums.RollbackStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeEvent;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeStatus;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeTimeoutUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="queryRollbackPreCheckResultAction")
public class QueryRollbackPreCheckResultAction
implements Action<RollbackStatus, UpgradeEvent> {
    private static final Logger log = LoggerFactory.getLogger(QueryRollbackPreCheckResultAction.class);
    private final DeviceResultCache deviceResultCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UpdateClusterStatus
    public Optional<UpgradeEvent> execute(ExecuteContext<RollbackStatus, UpgradeEvent> context) {
        DevNode node = (DevNode)context.get((Object)"devNode");
        ResultDetail result = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), UpgradeOption.ROLLBACK_PRE_CHECK);
        result.getUpgradeResult().initProgress();
        try {
            UpgradeRestUtil.updateRollbackPreCheckResult(node, result);
            ProgressTimeoutChecker timeoutChecker = ProgressTimeoutChecker.startFromNow(UpgradeTimeoutUtil.getUpgradeTimeoutMill(60));
            while (result.getUpgradeResult().getTaskStatus().isRunningStatus()) {
                ThreadUtils.sleep((long)5000L);
                UpgradeRestUtil.updateRollbackPreCheckResult(node, result);
                timeoutChecker.checkTimeout(result.getUpgradeResult().getProgress());
            }
            if (result.getUpgradeResult().getTaskStatus().isFailedStatus()) {
                Optional<UpgradeEvent> optional = Optional.of(UpgradeEvent.ERROR);
                return optional;
            }
            Optional<UpgradeEvent> optional = Optional.of(UpgradeEvent.ROLLBACK);
            return optional;
        }
        catch (ToolException e) {
            result.getUpgradeResult().setTaskStatus(UpgradeStatus.ERROR);
            result.getUpgradeResult().appendMessage(e.getErrorLocaleDescription());
        }
        finally {
            result.getUpgradeResult().setEndTime();
        }
        return Optional.of(UpgradeEvent.ERROR);
    }

    public QueryRollbackPreCheckResultAction(DeviceResultCache deviceResultCache) {
        this.deviceResultCache = deviceResultCache;
    }
}

