/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.action;

import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeCloudaStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeEvent;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.distributedfwupg.web.utils.NodeUtil;
import com.huawei.ism.tool.distributedfwupg.web.utils.UpgradeRestUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.stereotype.Component;

@Component(value="upgradeCloudaAction")
public class UpgradeCloudaAction
implements Action<UpgradeCloudaStatus, UpgradeEvent> {
    private final DeviceResultCache deviceResultCache;

    @UpdateClusterStatus
    public Optional<UpgradeEvent> execute(ExecuteContext<UpgradeCloudaStatus, UpgradeEvent> context) {
        DevNode node = (DevNode)context.get((Object)"devNode");
        UpgradeResult deviceResult = this.deviceResultCache.getDeviceResult(NodeUtil.getNodeId(node), UpgradeOption.UPGRADE_CLOUD_A).getUpgradeResult();
        try {
            deviceResult.setStartTime();
            ResponseInfo responseInfo = UpgradeRestUtil.requestUpgradeCloudA(node);
            UpgradeCloudaAction.parseErrorMsg(responseInfo);
            return Optional.of(UpgradeEvent.QUERY_RESULT);
        }
        catch (ToolException e) {
            deviceResult.appendMessage(e.getErrorLocaleDescription());
            deviceResult.setTaskStatus(UpgradeCloudaStatus.FAILURE);
            deviceResult.setEndTime();
            return Optional.of(UpgradeEvent.ERROR);
        }
    }

    private static void parseErrorMsg(ResponseInfo responseInfo) throws ToolException {
        Object data = responseInfo.getContentMap().get("data");
        if (Objects.isNull(data)) {
            return;
        }
        JSONObject jsonObj = UpgradeRestUtil.getJsonObj(data);
        String status = jsonObj.getStringOrDefault("status", "0");
        if ("0".equals(status)) {
            return;
        }
        JSONArray errorNodes = jsonObj.getJSONArray("check_failed_list");
        if (errorNodes.length() == 0) {
            return;
        }
        String errorNode = IntStream.range(0, errorNodes.length()).mapToObj(arg_0 -> ((JSONArray)errorNodes).get(arg_0)).map(Object::toString).collect(Collectors.joining(","));
        throw new ToolException("clouda.upgrade.error", new Object[]{errorNode});
    }

    public UpgradeCloudaAction(DeviceResultCache deviceResultCache) {
        this.deviceResultCache = deviceResultCache;
    }
}

