/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.advice;

import com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.ReleaseConnection;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.entity.UpgradeNode;
import com.huawei.ism.tool.distributedfwupg.web.exception.AopExecuteException;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ReleaseConnectionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ReleaseConnectionAdvice.class);

    @Pointcut(value="@annotation(com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.ReleaseConnection)")
    public void pointCut() {
    }

    @AfterReturning(value="pointCut() && @annotation(releaseConnection)")
    public void releaseConnection(JoinPoint joinPoint, ReleaseConnection releaseConnection) throws AopExecuteException {
        List<DevNode> nodes = this.findExecuteNodes(joinPoint, releaseConnection);
        nodes.forEach(this::releaseConnection);
    }

    private void releaseConnection(DevNode node) {
        log.info("release connection for node :{}", (Object)node.getIp());
        RestConnectionManager.releaseConn((DevNode)node);
    }

    private List<DevNode> findExecuteNodes(JoinPoint joinPoint, ReleaseConnection releaseConnection) throws AopExecuteException {
        if (StringUtils.isNULLStr((String)releaseConnection.value()) && joinPoint.getArgs().length != 1) {
            throw new AopExecuteException("release annotation has no sign arg, but method has more than one arg");
        }
        for (Object arg : joinPoint.getArgs()) {
            String argName = releaseConnection.value();
            if (StringUtils.isNULLStr((String)argName)) {
                return ReleaseConnectionAdvice.findOptionNodes(arg);
            }
            if (!arg.getClass().getName().equals(argName)) continue;
            return ReleaseConnectionAdvice.findOptionNodes(arg);
        }
        log.warn("join point :{}, device not found, do not release", (Object)joinPoint.getSignature().getName());
        return Collections.emptyList();
    }

    private static List<DevNode> findOptionNodes(Object arg) {
        Object node;
        if (arg instanceof DevNode) {
            return Collections.singletonList((DevNode)arg);
        }
        if (arg instanceof ExecuteContext && (node = ((ExecuteContext)arg).get((Object)"devNode")) instanceof DevNode) {
            return Collections.singletonList((DevNode)node);
        }
        if (arg instanceof List && ((List)arg).stream().allMatch(param -> param instanceof String)) {
            List<DevNode> nodes = ReleaseConnectionAdvice.findDevNode((List)arg);
            if (!CollectionUtil.isEmpty(nodes)) {
                return nodes;
            }
            List<DevNode> dmeNodes = ReleaseConnectionAdvice.findDmeNode((List)arg);
            if (!CollectionUtil.isEmpty(dmeNodes)) {
                return dmeNodes;
            }
        }
        if (arg instanceof String) {
            DevNode devNodeById = Context.INS.getDevNodeById((String)arg);
            if (devNodeById != null) {
                return Collections.singletonList(devNodeById);
            }
            UpgradeNode upgradeNode = Context.INS.getAiNodeMap().get(arg);
            if (upgradeNode != null && upgradeNode.getDevNode() != null) {
                return Collections.singletonList(upgradeNode.getDevNode());
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<DevNode> findDmeNode(List<?> arg) {
        return arg.stream().map(String::valueOf).map(Context.INS.getAiNodeMap()::get).filter(Objects::nonNull).map(UpgradeNode::getDevNode).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private static List<DevNode> findDevNode(List<?> arg) {
        return arg.stream().map(String::valueOf).map(Context.INS::getDevNodeById).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

