/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.advice;

import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.common.Context;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.exception.AopExecuteException;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.task.state.based.ExecuteContext;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class UpgradeClusterStatusAdvice {
    private static final Logger log = LoggerFactory.getLogger(UpgradeClusterStatusAdvice.class);
    private final UpgradeStatusService upgradeStatusService;

    @Pointcut(value="@annotation(com.huawei.ism.tool.distributedfwupg.web.application.advice.annotation.UpdateClusterStatus)")
    public void pointCut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointCut()")
    public Object updateClusterStatus(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        DevNode node = this.findDevNodeParam(proceedingJoinPoint);
        try {
            this.updateClusterStatus(node);
            Object object = UpgradeClusterStatusAdvice.executeJoinPoint(proceedingJoinPoint);
            return object;
        }
        finally {
            this.updateClusterStatus(node);
        }
    }

    private static Object executeJoinPoint(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        try {
            return proceedingJoinPoint.proceed();
        }
        catch (Throwable e) {
            log.error("execute join point error", e);
            throw e;
        }
    }

    private void updateClusterStatus(DevNode node) {
        UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(node);
        Context.INS.getUpgradeDevNode(node).setCurrentStatus(currentStatus);
    }

    private DevNode findDevNodeParam(ProceedingJoinPoint proceedingJoinPoint) throws AopExecuteException {
        for (Object arg : proceedingJoinPoint.getArgs()) {
            DevNode node;
            if (arg instanceof DevNode) {
                return (DevNode)arg;
            }
            if (!(arg instanceof ExecuteContext) || !Objects.nonNull(node = (DevNode)((ExecuteContext)arg).get((Object)"devNode"))) continue;
            return node;
        }
        throw new AopExecuteException("point cut should has the DevNode type param");
    }

    public UpgradeClusterStatusAdvice(UpgradeStatusService upgradeStatusService) {
        this.upgradeStatusService = upgradeStatusService;
    }
}

