/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.checker;

import com.huawei.ism.tool.obase.exception.ToolException;

public class TimeoutChecker {
    private final long startMills;
    private final long timeoutMills;

    public void checkTimeout() throws ToolException {
        if (System.currentTimeMillis() - this.startMills >= this.timeoutMills) {
            throw new ToolException("upgrade.compute.node.status.timeout");
        }
    }

    public static TimeoutChecker startFromNow(long timeoutMills) {
        if (timeoutMills <= 0L) {
            throw new IllegalArgumentException("time out invalid");
        }
        return new TimeoutChecker(System.currentTimeMillis(), timeoutMills);
    }

    private TimeoutChecker(long startMills, long timeoutMills) {
        this.startMills = startMills;
        this.timeoutMills = timeoutMills;
    }
}

