/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.factory;

import com.huawei.ism.tool.distributedfwupg.web.application.service.SceneEditableCheckService;
import com.huawei.ism.tool.distributedfwupg.web.enums.SceneEnum;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ClusterSceneCheckFactory {
    private final SceneEditableCheckService upgradeConfigCheckService;
    private final SceneEditableCheckService upgradeCheckService;
    private final SceneEditableCheckService upgradeCloudaCheckService;
    private final Map<SceneEnum, SceneEditableCheckService> checkServiceMap = new EnumMap<SceneEnum, SceneEditableCheckService>(SceneEnum.class);

    @PostConstruct
    public void init() {
        this.checkServiceMap.put(SceneEnum.UPGRADE_CONFIG, this.upgradeConfigCheckService);
        this.checkServiceMap.put(SceneEnum.PREPARE_UPGRADE, this.upgradeCloudaCheckService);
        this.checkServiceMap.put(SceneEnum.UPGRADE_COMPUTE, this.upgradeCheckService);
    }

    public SceneEditableCheckService getCurrentSceneCheckService() {
        return this.checkServiceMap.getOrDefault((Object)SceneEnum.getCurrentScene(), this.upgradeConfigCheckService);
    }

    public ClusterSceneCheckFactory(SceneEditableCheckService upgradeConfigCheckService, SceneEditableCheckService upgradeCheckService, SceneEditableCheckService upgradeCloudaCheckService) {
        this.upgradeConfigCheckService = upgradeConfigCheckService;
        this.upgradeCheckService = upgradeCheckService;
        this.upgradeCloudaCheckService = upgradeCloudaCheckService;
    }
}

