/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.factory;

import com.huawei.ism.tool.distributedfwupg.SceneUtils;
import com.huawei.ism.tool.distributedfwupg.web.application.factory.ClusterSceneCheckFactory;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeExecuteService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeRetryService;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeStatusService;
import com.huawei.ism.tool.distributedfwupg.web.entity.EditableResult;
import com.huawei.ism.tool.distributedfwupg.web.enums.CommonStatus;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeTaskStatus;
import com.huawei.ism.tool.distributedfwupg.web.result.DeviceResultCache;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RecoveryQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(RecoveryQueryFactory.class);
    private static final Map<UpgradeTaskStatus, Consumer<DevNode>> recoverQueryMap = new EnumMap<UpgradeTaskStatus, Consumer<DevNode>>(UpgradeTaskStatus.class);
    private final UpgradeExecuteService upgradeExecuteService;
    private final UpgradeRetryService upgradeRetryService;
    private final UpgradeStatusService upgradeStatusService;
    private final ClusterSceneCheckFactory checkDeviceEditable;
    private final DeviceResultCache deviceResultCache;

    @PostConstruct
    public void init() {
        recoverQueryMap.put(UpgradeTaskStatus.CLOUDA_UPGRADING, this.upgradeExecuteService::queryCloudaResult);
        recoverQueryMap.put(UpgradeTaskStatus.CLOUDA_UPGRADING_SUCCESS, this.upgradeExecuteService::queryCloudaResult);
        recoverQueryMap.put(UpgradeTaskStatus.CLOUDA_UPGRADING_FAILURE, this.upgradeExecuteService::queryCloudaResult);
        recoverQueryMap.put(UpgradeTaskStatus.DPC_PRE_CHECK, this.upgradeExecuteService::queryPreCheckResult);
        recoverQueryMap.put(UpgradeTaskStatus.DPC_PRE_CHECK_SUCCESS, this.upgradeExecuteService::queryPreCheckResult);
        recoverQueryMap.put(UpgradeTaskStatus.DPC_PRE_CHECK_FAILURE, this.upgradeExecuteService::queryPreCheckResult);
        recoverQueryMap.put(UpgradeTaskStatus.UPGRADING, this.upgradeExecuteService::queryUpgradeResult);
        recoverQueryMap.put(UpgradeTaskStatus.UPGRADE_PREPARING, this.upgradeExecuteService::queryUpgradeResult);
        recoverQueryMap.put(UpgradeTaskStatus.UPGRADE_FINISH, this.upgradeExecuteService::queryUpgradeResult);
        recoverQueryMap.put(UpgradeTaskStatus.UPGRADE_READY, this.upgradeExecuteService::queryUpgradeResult);
        recoverQueryMap.put(UpgradeTaskStatus.POST_CHECK, this.upgradeExecuteService::queryUpgradeResult);
        recoverQueryMap.put(UpgradeTaskStatus.POST_CHECK_FAILURE, this.upgradeExecuteService::queryUpgradeResult);
        recoverQueryMap.put(UpgradeTaskStatus.CONFIRMING, this.upgradeExecuteService::queryConfirmResult);
        recoverQueryMap.put(UpgradeTaskStatus.CONFIRM_FAILURE, this.upgradeExecuteService::queryConfirmResult);
        recoverQueryMap.put(UpgradeTaskStatus.DPC_ROLLBACK_PRE_CHECK, this.upgradeRetryService::requeryRollbackPreCheck);
        recoverQueryMap.put(UpgradeTaskStatus.DPC_ROLLBACK_PRE_CHECK_FAILURE, this.upgradeRetryService::requeryRollbackPreCheck);
        recoverQueryMap.put(UpgradeTaskStatus.DPC_ROLLBACK_PRE_CHECK_SUCCESS, this.upgradeRetryService::requeryRollbackPreCheck);
        recoverQueryMap.put(UpgradeTaskStatus.ROLLBACKING, this.upgradeRetryService::requeryRollback);
        recoverQueryMap.put(UpgradeTaskStatus.ROLLBACK_POST_CHECK, this.upgradeRetryService::requeryRollback);
        recoverQueryMap.put(UpgradeTaskStatus.ROLLBACK_POST_CHECK_SUCCESS, this.upgradeRetryService::requeryRollback);
        recoverQueryMap.put(UpgradeTaskStatus.ROLLBACK_POST_CHECK_FAILURE, this.upgradeRetryService::requeryRollback);
        recoverQueryMap.put(UpgradeTaskStatus.ROLLBACK_CONFIRMING, this.upgradeRetryService::requeryRollbackConfirming);
        recoverQueryMap.put(UpgradeTaskStatus.ROLLBACK_CONFIRMING_FAILURE, this.upgradeRetryService::requeryRollbackConfirming);
    }

    public void recoverQueryResult(DevNode node) {
        EditableResult editableResult = this.checkDeviceEditable.getCurrentSceneCheckService().checkDeviceEditable(node);
        if (!editableResult.isEditable()) {
            return;
        }
        UpgradeTaskStatus currentStatus = this.upgradeStatusService.getCurrentStatus(node);
        if (currentStatus == UpgradeTaskStatus.CLOUDA_UPGRADING_SUCCESS && SceneUtils.isDpcUpgradeScene()) {
            return;
        }
        Consumer<DevNode> devNodeConsumer = recoverQueryMap.get((Object)currentStatus);
        if (Objects.isNull(devNodeConsumer)) {
            log.warn("current status :{} not found result query func, may no need query", (Object)currentStatus);
            return;
        }
        try {
            log.info("current status :{} start recover result", (Object)currentStatus);
            devNodeConsumer.accept(node);
        }
        catch (Exception e) {
            log.error("recover result for device :{} failed ", (Object)node.getIp(), (Object)e);
            this.deviceResultCache.getDeviceExistsResult(node).stream().filter(result -> result.getUpgradeResult().getTaskStatus().isRunningStatus()).findAny().ifPresent(result -> result.getUpgradeResult().setTaskStatus(CommonStatus.ERROR));
        }
    }

    public RecoveryQueryFactory(UpgradeExecuteService upgradeExecuteService, UpgradeRetryService upgradeRetryService, UpgradeStatusService upgradeStatusService, ClusterSceneCheckFactory checkDeviceEditable, DeviceResultCache deviceResultCache) {
        this.upgradeExecuteService = upgradeExecuteService;
        this.upgradeRetryService = upgradeRetryService;
        this.upgradeStatusService = upgradeStatusService;
        this.checkDeviceEditable = checkDeviceEditable;
        this.deviceResultCache = deviceResultCache;
    }
}

