/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributedfwupg.web.application.factory;

import com.huawei.ism.tool.distributedfwupg.web.application.factory.func.RetryFunc;
import com.huawei.ism.tool.distributedfwupg.web.application.service.UpgradeRetryService;
import com.huawei.ism.tool.distributedfwupg.web.enums.UpgradeOption;
import com.huawei.ism.tool.distributedfwupg.web.exception.UpgradeException;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RetryTaskFactory {
    private static final Logger log = LoggerFactory.getLogger(RetryTaskFactory.class);
    private final UpgradeRetryService retryService;
    private final Map<UpgradeOption, RetryFunc<DevNode, UpgradeOption>> retryTaskQueryFunc = new HashMap<UpgradeOption, RetryFunc<DevNode, UpgradeOption>>();

    @PostConstruct
    public void init() {
        this.retryTaskQueryFunc.put(UpgradeOption.COMPUTE_UPGRADE, this.retryService::retryComputeUpgrade);
        this.retryTaskQueryFunc.put(UpgradeOption.ROLLBACK, this.retryService::retryRollback);
        this.retryTaskQueryFunc.put(UpgradeOption.ROLLBACK_POST_CHECK, this.retryService::retryRollback);
        this.retryTaskQueryFunc.put(UpgradeOption.UPGRADE_POST_CHECK, this.retryService::retryPostCheck);
        this.retryTaskQueryFunc.put(UpgradeOption.CONFIRM_ROLLBACK, this.retryService::retryConfirmRollback);
    }

    public RetryFunc<DevNode, UpgradeOption> queryRetryAction(UpgradeOption upgradeOption) throws UpgradeException {
        RetryFunc<DevNode, UpgradeOption> retryQueryAction = this.retryTaskQueryFunc.get((Object)upgradeOption);
        if (Objects.isNull(retryQueryAction)) {
            log.error("current option :{} not found exec func", (Object)upgradeOption);
            throw new UpgradeException("not.support.option", Collections.singletonList(upgradeOption.getDesc()));
        }
        return retryQueryAction;
    }

    public RetryTaskFactory(UpgradeRetryService retryService) {
        this.retryService = retryService;
    }
}

